/* rnaGenes.c was originally generated by the autoSql program, which also 
 * generated rnaGenes.h and rnaGenes.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "rnaGenes.h"


void rnaGenesStaticLoad(char **row, struct rnaGenes *ret)
/* Load a row from rnaGenes table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->aa = row[6];
ret->ac = row[7];
strcpy(ret->ci, row[8]);
ret->scan = atof(row[9]);
}

struct rnaGenes *rnaGenesLoad(char **row)
/* Load a rnaGenes from row fetched with select * from rnaGenes
 * from database.  Dispose of this with rnaGenesFree(). */
{
struct rnaGenes *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->aa = cloneString(row[6]);
ret->ac = cloneString(row[7]);
strcpy(ret->ci, row[8]);
ret->scan = atof(row[9]);
return ret;
}

struct rnaGenes *rnaGenesLoadAll(char *fileName) 
/* Load all rnaGenes from a whitespace-separated file.
 * Dispose of this with rnaGenesFreeList(). */
{
struct rnaGenes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = rnaGenesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rnaGenes *rnaGenesLoadAllByChar(char *fileName, char chopper) 
/* Load all rnaGenes from a chopper separated file.
 * Dispose of this with rnaGenesFreeList(). */
{
struct rnaGenes *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = rnaGenesLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct rnaGenes *rnaGenesCommaIn(char **pS, struct rnaGenes *ret)
/* Create a rnaGenes out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaGenes */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->aa = sqlStringComma(&s);
ret->ac = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->ci, sizeof(ret->ci));
ret->scan = sqlFloatComma(&s);
*pS = s;
return ret;
}

void rnaGenesFree(struct rnaGenes **pEl)
/* Free a single dynamically allocated rnaGenes such as created
 * with rnaGenesLoad(). */
{
struct rnaGenes *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->aa);
freeMem(el->ac);
freez(pEl);
}

void rnaGenesFreeList(struct rnaGenes **pList)
/* Free a list of dynamically allocated rnaGenes's */
{
struct rnaGenes *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    rnaGenesFree(&el);
    }
*pList = NULL;
}

void rnaGenesOutput(struct rnaGenes *el, FILE *f, char sep, char lastSep) 
/* Print out rnaGenes.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->aa);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ac);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ci);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->scan);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

