# taxonNode.sql was originally generated by the autoSql program, which also 
# generated taxonNode.c and taxonNode.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#ncbi taxonomy node tree
CREATE TABLE taxonNode (
    taxon int unsigned not null,	# node id in GenBank taxonomy database
    parent int unsigned not null,	# parent node id in GenBank taxonomy database
    rank varchar(255) not null,	# rank of this node (superkingdom, kingdom, ...) 
    emblcode varchar(255) not null,	# locus-name prefix; not unique
    division int unsigned not null,	# ncbiDivision id (0=Bacteria, 2=Mammal, 5=Primate, 6=Rodent, 10=Vertabrate...)
    inheritedDiv int unsigned not null,	# 1 if node inherits division from parent
    geneticCode int unsigned not null,	# genetic code used by species, see ncbiGencode
    inheritedGC int unsigned not null,	# 1 if node inherits genetic code from parent
    mitoGeneticCode int unsigned not null,	# genetic code of mitochondria see ncbiGencode
    inheritedMitoGC int unsigned not null,	# 1 if node inherits mitochondrial gencode from parent
    GenBankHidden int unsigned not null,	# 1 if name is suppressed in GenBank entry lineage
    notSequenced int unsigned not null,	# 1 if this subtree has no sequence data yet
    comments varchar(255) not null,	# free-text comments and citations
              #Indices
    PRIMARY KEY(taxon),
    INDEX(parent),
    INDEX(division)
);
