/* tomRough.c was originally generated by the autoSql program, which also 
 * generated tomRough.h and tomRough.sql.  This module links the database and the RAM 
 * representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "jksql.h"
#include "tomRough.h"


void tomRoughStaticLoad(char **row, struct tomRough *ret)
/* Load a row from tomRough table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->omimId = sqlSigned(row[0]);
ret->chromosome = row[1];
ret->startBand = row[2];
ret->endBand = row[3];
ret->description = row[4];
}

struct tomRough *tomRoughLoad(char **row)
/* Load a tomRough from row fetched with select * from tomRough
 * from database.  Dispose of this with tomRoughFree(). */
{
struct tomRough *ret;

AllocVar(ret);
ret->omimId = sqlSigned(row[0]);
ret->chromosome = cloneString(row[1]);
ret->startBand = cloneString(row[2]);
ret->endBand = cloneString(row[3]);
ret->description = cloneString(row[4]);
return ret;
}

struct tomRough *tomRoughCommaIn(char **pS, struct tomRough *ret)
/* Create a tomRough out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tomRough */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->omimId = sqlSignedComma(&s);
ret->chromosome = sqlStringComma(&s);
ret->startBand = sqlStringComma(&s);
ret->endBand = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void tomRoughFree(struct tomRough **pEl)
/* Free a single dynamically allocated tomRough such as created
 * with tomRoughLoad(). */
{
struct tomRough *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chromosome);
freeMem(el->startBand);
freeMem(el->endBand);
freeMem(el->description);
freez(pEl);
}

void tomRoughFreeList(struct tomRough **pList)
/* Free a list of dynamically allocated tomRough's */
{
struct tomRough *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    tomRoughFree(&el);
    }
*pList = NULL;
}

void tomRoughOutput(struct tomRough *el, FILE *f, char sep, char lastSep) 
/* Print out tomRough.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%d", el->omimId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chromosome);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->startBand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->endBand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

