/* cdw.c was originally generated by the autoSql program, which also 
 * generated cdw.h and cdw.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cdw.h"



char *cdwSettingsCommaSepFieldNames = "id,name,val";

void cdwSettingsStaticLoad(char **row, struct cdwSettings *ret)
/* Load a row from cdwSettings table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->val = row[2];
}

struct cdwSettings *cdwSettingsLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwSettings from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSettingsFreeList(). */
{
struct cdwSettings *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwSettingsLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwSettingsSaveToDb(struct sqlConnection *conn, struct cdwSettings *el, char *tableName, int updateSize)
/* Save cdwSettings as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s')", 
	tableName,  el->id,  el->name,  el->val);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwSettings *cdwSettingsLoad(char **row)
/* Load a cdwSettings from row fetched with select * from cdwSettings
 * from database.  Dispose of this with cdwSettingsFree(). */
{
struct cdwSettings *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->val = cloneString(row[2]);
return ret;
}

struct cdwSettings *cdwSettingsLoadAll(char *fileName) 
/* Load all cdwSettings from a whitespace-separated file.
 * Dispose of this with cdwSettingsFreeList(). */
{
struct cdwSettings *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = cdwSettingsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSettings *cdwSettingsLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwSettings from a chopper separated file.
 * Dispose of this with cdwSettingsFreeList(). */
{
struct cdwSettings *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwSettingsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSettings *cdwSettingsCommaIn(char **pS, struct cdwSettings *ret)
/* Create a cdwSettings out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSettings */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->val = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwSettingsFree(struct cdwSettings **pEl)
/* Free a single dynamically allocated cdwSettings such as created
 * with cdwSettingsLoad(). */
{
struct cdwSettings *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->val);
freez(pEl);
}

void cdwSettingsFreeList(struct cdwSettings **pList)
/* Free a list of dynamically allocated cdwSettings's */
{
struct cdwSettings *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwSettingsFree(&el);
    }
*pList = NULL;
}

void cdwSettingsOutput(struct cdwSettings *el, FILE *f, char sep, char lastSep) 
/* Print out cdwSettings.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->val);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwUserCommaSepFieldNames = "id,email,uuid,isAdmin,primaryGroup";

void cdwUserStaticLoad(char **row, struct cdwUser *ret)
/* Load a row from cdwUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->email = row[1];
safecpy(ret->uuid, sizeof(ret->uuid), row[2]);
ret->isAdmin = sqlSigned(row[3]);
ret->primaryGroup = sqlUnsigned(row[4]);
}

struct cdwUser *cdwUserLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwUserFreeList(). */
{
struct cdwUser *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwUserLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwUserSaveToDb(struct sqlConnection *conn, struct cdwUser *el, char *tableName, int updateSize)
/* Save cdwUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s',%d,%u)", 
	tableName,  el->id,  el->email,  el->uuid,  el->isAdmin,  el->primaryGroup);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwUser *cdwUserLoad(char **row)
/* Load a cdwUser from row fetched with select * from cdwUser
 * from database.  Dispose of this with cdwUserFree(). */
{
struct cdwUser *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->email = cloneString(row[1]);
safecpy(ret->uuid, sizeof(ret->uuid), row[2]);
ret->isAdmin = sqlSigned(row[3]);
ret->primaryGroup = sqlUnsigned(row[4]);
return ret;
}

struct cdwUser *cdwUserLoadAll(char *fileName) 
/* Load all cdwUser from a whitespace-separated file.
 * Dispose of this with cdwUserFreeList(). */
{
struct cdwUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cdwUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwUser *cdwUserLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwUser from a chopper separated file.
 * Dispose of this with cdwUserFreeList(). */
{
struct cdwUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwUser *cdwUserCommaIn(char **pS, struct cdwUser *ret)
/* Create a cdwUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwUser */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->email = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->uuid, sizeof(ret->uuid));
ret->isAdmin = sqlSignedComma(&s);
ret->primaryGroup = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwUserFree(struct cdwUser **pEl)
/* Free a single dynamically allocated cdwUser such as created
 * with cdwUserLoad(). */
{
struct cdwUser *el;

if ((el = *pEl) == NULL) return;
freeMem(el->email);
freez(pEl);
}

void cdwUserFreeList(struct cdwUser **pList)
/* Free a list of dynamically allocated cdwUser's */
{
struct cdwUser *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwUserFree(&el);
    }
*pList = NULL;
}

void cdwUserOutput(struct cdwUser *el, FILE *f, char sep, char lastSep) 
/* Print out cdwUser.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->email);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->uuid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->isAdmin);
fputc(sep,f);
fprintf(f, "%u", el->primaryGroup);
fputc(lastSep,f);
}


char *cdwGroupCommaSepFieldNames = "id,name,description";

void cdwGroupStaticLoad(char **row, struct cdwGroup *ret)
/* Load a row from cdwGroup table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->description = row[2];
}

struct cdwGroup *cdwGroupLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwGroup from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupFreeList(). */
{
struct cdwGroup *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwGroupLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwGroupSaveToDb(struct sqlConnection *conn, struct cdwGroup *el, char *tableName, int updateSize)
/* Save cdwGroup as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s')", 
	tableName,  el->id,  el->name,  el->description);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwGroup *cdwGroupLoad(char **row)
/* Load a cdwGroup from row fetched with select * from cdwGroup
 * from database.  Dispose of this with cdwGroupFree(). */
{
struct cdwGroup *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->description = cloneString(row[2]);
return ret;
}

struct cdwGroup *cdwGroupLoadAll(char *fileName) 
/* Load all cdwGroup from a whitespace-separated file.
 * Dispose of this with cdwGroupFreeList(). */
{
struct cdwGroup *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = cdwGroupLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroup *cdwGroupLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwGroup from a chopper separated file.
 * Dispose of this with cdwGroupFreeList(). */
{
struct cdwGroup *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwGroupLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroup *cdwGroupCommaIn(char **pS, struct cdwGroup *ret)
/* Create a cdwGroup out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroup */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwGroupFree(struct cdwGroup **pEl)
/* Free a single dynamically allocated cdwGroup such as created
 * with cdwGroupLoad(). */
{
struct cdwGroup *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freez(pEl);
}

void cdwGroupFreeList(struct cdwGroup **pList)
/* Free a list of dynamically allocated cdwGroup's */
{
struct cdwGroup *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwGroupFree(&el);
    }
*pList = NULL;
}

void cdwGroupOutput(struct cdwGroup *el, FILE *f, char sep, char lastSep) 
/* Print out cdwGroup.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwGroupFileCommaSepFieldNames = "fileId,groupId";

void cdwGroupFileStaticLoad(char **row, struct cdwGroupFile *ret)
/* Load a row from cdwGroupFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->fileId = sqlUnsigned(row[0]);
ret->groupId = sqlUnsigned(row[1]);
}

struct cdwGroupFile *cdwGroupFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwGroupFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupFileFreeList(). */
{
struct cdwGroupFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwGroupFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwGroupFileSaveToDb(struct sqlConnection *conn, struct cdwGroupFile *el, char *tableName, int updateSize)
/* Save cdwGroupFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u)", 
	tableName,  el->fileId,  el->groupId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwGroupFile *cdwGroupFileLoad(char **row)
/* Load a cdwGroupFile from row fetched with select * from cdwGroupFile
 * from database.  Dispose of this with cdwGroupFileFree(). */
{
struct cdwGroupFile *ret;

AllocVar(ret);
ret->fileId = sqlUnsigned(row[0]);
ret->groupId = sqlUnsigned(row[1]);
return ret;
}

struct cdwGroupFile *cdwGroupFileLoadAll(char *fileName) 
/* Load all cdwGroupFile from a whitespace-separated file.
 * Dispose of this with cdwGroupFileFreeList(). */
{
struct cdwGroupFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cdwGroupFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroupFile *cdwGroupFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwGroupFile from a chopper separated file.
 * Dispose of this with cdwGroupFileFreeList(). */
{
struct cdwGroupFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwGroupFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroupFile *cdwGroupFileCommaIn(char **pS, struct cdwGroupFile *ret)
/* Create a cdwGroupFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroupFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->fileId = sqlUnsignedComma(&s);
ret->groupId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwGroupFileFree(struct cdwGroupFile **pEl)
/* Free a single dynamically allocated cdwGroupFile such as created
 * with cdwGroupFileLoad(). */
{
struct cdwGroupFile *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwGroupFileFreeList(struct cdwGroupFile **pList)
/* Free a list of dynamically allocated cdwGroupFile's */
{
struct cdwGroupFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwGroupFileFree(&el);
    }
*pList = NULL;
}

void cdwGroupFileOutput(struct cdwGroupFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwGroupFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->groupId);
fputc(lastSep,f);
}


char *cdwGroupUserCommaSepFieldNames = "userId,groupId";

void cdwGroupUserStaticLoad(char **row, struct cdwGroupUser *ret)
/* Load a row from cdwGroupUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->userId = sqlUnsigned(row[0]);
ret->groupId = sqlUnsigned(row[1]);
}

struct cdwGroupUser *cdwGroupUserLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwGroupUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupUserFreeList(). */
{
struct cdwGroupUser *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwGroupUserLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwGroupUserSaveToDb(struct sqlConnection *conn, struct cdwGroupUser *el, char *tableName, int updateSize)
/* Save cdwGroupUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u)", 
	tableName,  el->userId,  el->groupId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwGroupUser *cdwGroupUserLoad(char **row)
/* Load a cdwGroupUser from row fetched with select * from cdwGroupUser
 * from database.  Dispose of this with cdwGroupUserFree(). */
{
struct cdwGroupUser *ret;

AllocVar(ret);
ret->userId = sqlUnsigned(row[0]);
ret->groupId = sqlUnsigned(row[1]);
return ret;
}

struct cdwGroupUser *cdwGroupUserLoadAll(char *fileName) 
/* Load all cdwGroupUser from a whitespace-separated file.
 * Dispose of this with cdwGroupUserFreeList(). */
{
struct cdwGroupUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cdwGroupUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroupUser *cdwGroupUserLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwGroupUser from a chopper separated file.
 * Dispose of this with cdwGroupUserFreeList(). */
{
struct cdwGroupUser *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwGroupUserLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwGroupUser *cdwGroupUserCommaIn(char **pS, struct cdwGroupUser *ret)
/* Create a cdwGroupUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroupUser */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->userId = sqlUnsignedComma(&s);
ret->groupId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwGroupUserFree(struct cdwGroupUser **pEl)
/* Free a single dynamically allocated cdwGroupUser such as created
 * with cdwGroupUserLoad(). */
{
struct cdwGroupUser *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwGroupUserFreeList(struct cdwGroupUser **pList)
/* Free a list of dynamically allocated cdwGroupUser's */
{
struct cdwGroupUser *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwGroupUserFree(&el);
    }
*pList = NULL;
}

void cdwGroupUserOutput(struct cdwGroupUser *el, FILE *f, char sep, char lastSep) 
/* Print out cdwGroupUser.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->userId);
fputc(sep,f);
fprintf(f, "%u", el->groupId);
fputc(lastSep,f);
}


char *cdwLabCommaSepFieldNames = "id,name,pi,institution,url";

void cdwLabStaticLoad(char **row, struct cdwLab *ret)
/* Load a row from cdwLab table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->pi = row[2];
ret->institution = row[3];
ret->url = row[4];
}

struct cdwLab *cdwLabLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwLab from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwLabFreeList(). */
{
struct cdwLab *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwLabLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwLabSaveToDb(struct sqlConnection *conn, struct cdwLab *el, char *tableName, int updateSize)
/* Save cdwLab as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->pi,  el->institution,  el->url);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwLab *cdwLabLoad(char **row)
/* Load a cdwLab from row fetched with select * from cdwLab
 * from database.  Dispose of this with cdwLabFree(). */
{
struct cdwLab *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->pi = cloneString(row[2]);
ret->institution = cloneString(row[3]);
ret->url = cloneString(row[4]);
return ret;
}

struct cdwLab *cdwLabLoadAll(char *fileName) 
/* Load all cdwLab from a whitespace-separated file.
 * Dispose of this with cdwLabFreeList(). */
{
struct cdwLab *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cdwLabLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwLab *cdwLabLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwLab from a chopper separated file.
 * Dispose of this with cdwLabFreeList(). */
{
struct cdwLab *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwLabLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwLab *cdwLabCommaIn(char **pS, struct cdwLab *ret)
/* Create a cdwLab out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwLab */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->pi = sqlStringComma(&s);
ret->institution = sqlStringComma(&s);
ret->url = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwLabFree(struct cdwLab **pEl)
/* Free a single dynamically allocated cdwLab such as created
 * with cdwLabLoad(). */
{
struct cdwLab *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->pi);
freeMem(el->institution);
freeMem(el->url);
freez(pEl);
}

void cdwLabFreeList(struct cdwLab **pList)
/* Free a list of dynamically allocated cdwLab's */
{
struct cdwLab *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwLabFree(&el);
    }
*pList = NULL;
}

void cdwLabOutput(struct cdwLab *el, FILE *f, char sep, char lastSep) 
/* Print out cdwLab.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pi);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->institution);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwScriptRegistryCommaSepFieldNames = "id,userId,name,description,secretHash,submitCount";

void cdwScriptRegistryStaticLoad(char **row, struct cdwScriptRegistry *ret)
/* Load a row from cdwScriptRegistry table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->userId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->description = row[3];
ret->secretHash = row[4];
ret->submitCount = sqlSigned(row[5]);
}

struct cdwScriptRegistry *cdwScriptRegistryLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwScriptRegistry from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwScriptRegistryFreeList(). */
{
struct cdwScriptRegistry *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwScriptRegistrySaveToDb(struct sqlConnection *conn, struct cdwScriptRegistry *el, char *tableName, int updateSize)
/* Save cdwScriptRegistry as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s','%s',%d)", 
	tableName,  el->id,  el->userId,  el->name,  el->description,  el->secretHash,  el->submitCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwScriptRegistry *cdwScriptRegistryLoad(char **row)
/* Load a cdwScriptRegistry from row fetched with select * from cdwScriptRegistry
 * from database.  Dispose of this with cdwScriptRegistryFree(). */
{
struct cdwScriptRegistry *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->userId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->description = cloneString(row[3]);
ret->secretHash = cloneString(row[4]);
ret->submitCount = sqlSigned(row[5]);
return ret;
}

struct cdwScriptRegistry *cdwScriptRegistryLoadAll(char *fileName) 
/* Load all cdwScriptRegistry from a whitespace-separated file.
 * Dispose of this with cdwScriptRegistryFreeList(). */
{
struct cdwScriptRegistry *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cdwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwScriptRegistry *cdwScriptRegistryLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwScriptRegistry from a chopper separated file.
 * Dispose of this with cdwScriptRegistryFreeList(). */
{
struct cdwScriptRegistry *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwScriptRegistryLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwScriptRegistry *cdwScriptRegistryCommaIn(char **pS, struct cdwScriptRegistry *ret)
/* Create a cdwScriptRegistry out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwScriptRegistry */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->userId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->secretHash = sqlStringComma(&s);
ret->submitCount = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwScriptRegistryFree(struct cdwScriptRegistry **pEl)
/* Free a single dynamically allocated cdwScriptRegistry such as created
 * with cdwScriptRegistryLoad(). */
{
struct cdwScriptRegistry *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->description);
freeMem(el->secretHash);
freez(pEl);
}

void cdwScriptRegistryFreeList(struct cdwScriptRegistry **pList)
/* Free a list of dynamically allocated cdwScriptRegistry's */
{
struct cdwScriptRegistry *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwScriptRegistryFree(&el);
    }
*pList = NULL;
}

void cdwScriptRegistryOutput(struct cdwScriptRegistry *el, FILE *f, char sep, char lastSep) 
/* Print out cdwScriptRegistry.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->userId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->secretHash);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->submitCount);
fputc(lastSep,f);
}


char *cdwHostCommaSepFieldNames = "id,name,lastOkTime,lastNotOkTime,firstAdded,errorMessage,openSuccesses,openFails,historyBits,paraFetchStreams";

void cdwHostStaticLoad(char **row, struct cdwHost *ret)
/* Load a row from cdwHost table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->lastOkTime = sqlLongLong(row[2]);
ret->lastNotOkTime = sqlLongLong(row[3]);
ret->firstAdded = sqlLongLong(row[4]);
ret->errorMessage = row[5];
ret->openSuccesses = sqlLongLong(row[6]);
ret->openFails = sqlLongLong(row[7]);
ret->historyBits = sqlLongLong(row[8]);
ret->paraFetchStreams = sqlSigned(row[9]);
}

struct cdwHost *cdwHostLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwHost from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwHostFreeList(). */
{
struct cdwHost *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwHostLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwHostSaveToDb(struct sqlConnection *conn, struct cdwHost *el, char *tableName, int updateSize)
/* Save cdwHost as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,%lld,'%s',%lld,%lld,%lld,%d)", 
	tableName,  el->id,  el->name,  el->lastOkTime,  el->lastNotOkTime,  el->firstAdded,  el->errorMessage,  el->openSuccesses,  el->openFails,  el->historyBits,  el->paraFetchStreams);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwHost *cdwHostLoad(char **row)
/* Load a cdwHost from row fetched with select * from cdwHost
 * from database.  Dispose of this with cdwHostFree(). */
{
struct cdwHost *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->lastOkTime = sqlLongLong(row[2]);
ret->lastNotOkTime = sqlLongLong(row[3]);
ret->firstAdded = sqlLongLong(row[4]);
ret->errorMessage = cloneString(row[5]);
ret->openSuccesses = sqlLongLong(row[6]);
ret->openFails = sqlLongLong(row[7]);
ret->historyBits = sqlLongLong(row[8]);
ret->paraFetchStreams = sqlSigned(row[9]);
return ret;
}

struct cdwHost *cdwHostLoadAll(char *fileName) 
/* Load all cdwHost from a whitespace-separated file.
 * Dispose of this with cdwHostFreeList(). */
{
struct cdwHost *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = cdwHostLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwHost *cdwHostLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwHost from a chopper separated file.
 * Dispose of this with cdwHostFreeList(). */
{
struct cdwHost *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwHostLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwHost *cdwHostCommaIn(char **pS, struct cdwHost *ret)
/* Create a cdwHost out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwHost */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->lastOkTime = sqlLongLongComma(&s);
ret->lastNotOkTime = sqlLongLongComma(&s);
ret->firstAdded = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->openSuccesses = sqlLongLongComma(&s);
ret->openFails = sqlLongLongComma(&s);
ret->historyBits = sqlLongLongComma(&s);
ret->paraFetchStreams = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwHostFree(struct cdwHost **pEl)
/* Free a single dynamically allocated cdwHost such as created
 * with cdwHostLoad(). */
{
struct cdwHost *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->errorMessage);
freez(pEl);
}

void cdwHostFreeList(struct cdwHost **pList)
/* Free a list of dynamically allocated cdwHost's */
{
struct cdwHost *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwHostFree(&el);
    }
*pList = NULL;
}

void cdwHostOutput(struct cdwHost *el, FILE *f, char sep, char lastSep) 
/* Print out cdwHost.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->lastOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->lastNotOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->firstAdded);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->openSuccesses);
fputc(sep,f);
fprintf(f, "%lld", el->openFails);
fputc(sep,f);
fprintf(f, "%lld", el->historyBits);
fputc(sep,f);
fprintf(f, "%d", el->paraFetchStreams);
fputc(lastSep,f);
}


char *cdwSubmitDirCommaSepFieldNames = "id,url,hostId,lastOkTime,lastNotOkTime,firstAdded,errorMessage,openSuccesses,openFails,historyBits";

void cdwSubmitDirStaticLoad(char **row, struct cdwSubmitDir *ret)
/* Load a row from cdwSubmitDir table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->url = row[1];
ret->hostId = sqlUnsigned(row[2]);
ret->lastOkTime = sqlLongLong(row[3]);
ret->lastNotOkTime = sqlLongLong(row[4]);
ret->firstAdded = sqlLongLong(row[5]);
ret->errorMessage = row[6];
ret->openSuccesses = sqlLongLong(row[7]);
ret->openFails = sqlLongLong(row[8]);
ret->historyBits = sqlLongLong(row[9]);
}

struct cdwSubmitDir *cdwSubmitDirLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwSubmitDir from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubmitDirFreeList(). */
{
struct cdwSubmitDir *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwSubmitDirSaveToDb(struct sqlConnection *conn, struct cdwSubmitDir *el, char *tableName, int updateSize)
/* Save cdwSubmitDir as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,%lld,%lld,%lld,'%s',%lld,%lld,%lld)", 
	tableName,  el->id,  el->url,  el->hostId,  el->lastOkTime,  el->lastNotOkTime,  el->firstAdded,  el->errorMessage,  el->openSuccesses,  el->openFails,  el->historyBits);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwSubmitDir *cdwSubmitDirLoad(char **row)
/* Load a cdwSubmitDir from row fetched with select * from cdwSubmitDir
 * from database.  Dispose of this with cdwSubmitDirFree(). */
{
struct cdwSubmitDir *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->url = cloneString(row[1]);
ret->hostId = sqlUnsigned(row[2]);
ret->lastOkTime = sqlLongLong(row[3]);
ret->lastNotOkTime = sqlLongLong(row[4]);
ret->firstAdded = sqlLongLong(row[5]);
ret->errorMessage = cloneString(row[6]);
ret->openSuccesses = sqlLongLong(row[7]);
ret->openFails = sqlLongLong(row[8]);
ret->historyBits = sqlLongLong(row[9]);
return ret;
}

struct cdwSubmitDir *cdwSubmitDirLoadAll(char *fileName) 
/* Load all cdwSubmitDir from a whitespace-separated file.
 * Dispose of this with cdwSubmitDirFreeList(). */
{
struct cdwSubmitDir *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = cdwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubmitDir *cdwSubmitDirLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwSubmitDir from a chopper separated file.
 * Dispose of this with cdwSubmitDirFreeList(). */
{
struct cdwSubmitDir *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwSubmitDirLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubmitDir *cdwSubmitDirCommaIn(char **pS, struct cdwSubmitDir *ret)
/* Create a cdwSubmitDir out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubmitDir */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->url = sqlStringComma(&s);
ret->hostId = sqlUnsignedComma(&s);
ret->lastOkTime = sqlLongLongComma(&s);
ret->lastNotOkTime = sqlLongLongComma(&s);
ret->firstAdded = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->openSuccesses = sqlLongLongComma(&s);
ret->openFails = sqlLongLongComma(&s);
ret->historyBits = sqlLongLongComma(&s);
*pS = s;
return ret;
}

void cdwSubmitDirFree(struct cdwSubmitDir **pEl)
/* Free a single dynamically allocated cdwSubmitDir such as created
 * with cdwSubmitDirLoad(). */
{
struct cdwSubmitDir *el;

if ((el = *pEl) == NULL) return;
freeMem(el->url);
freeMem(el->errorMessage);
freez(pEl);
}

void cdwSubmitDirFreeList(struct cdwSubmitDir **pList)
/* Free a list of dynamically allocated cdwSubmitDir's */
{
struct cdwSubmitDir *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwSubmitDirFree(&el);
    }
*pList = NULL;
}

void cdwSubmitDirOutput(struct cdwSubmitDir *el, FILE *f, char sep, char lastSep) 
/* Print out cdwSubmitDir.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->hostId);
fputc(sep,f);
fprintf(f, "%lld", el->lastOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->lastNotOkTime);
fputc(sep,f);
fprintf(f, "%lld", el->firstAdded);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->openSuccesses);
fputc(sep,f);
fprintf(f, "%lld", el->openFails);
fputc(sep,f);
fprintf(f, "%lld", el->historyBits);
fputc(lastSep,f);
}


char *cdwMetaTagsCommaSepFieldNames = "id,md5,tags";

void cdwMetaTagsStaticLoad(char **row, struct cdwMetaTags *ret)
/* Load a row from cdwMetaTags table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
safecpy(ret->md5, sizeof(ret->md5), row[1]);
ret->tags = row[2];
}

struct cdwMetaTags *cdwMetaTagsLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwMetaTags from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwMetaTagsFreeList(). */
{
struct cdwMetaTags *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwMetaTagsLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwMetaTagsSaveToDb(struct sqlConnection *conn, struct cdwMetaTags *el, char *tableName, int updateSize)
/* Save cdwMetaTags as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s')", 
	tableName,  el->id,  el->md5,  el->tags);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwMetaTags *cdwMetaTagsLoad(char **row)
/* Load a cdwMetaTags from row fetched with select * from cdwMetaTags
 * from database.  Dispose of this with cdwMetaTagsFree(). */
{
struct cdwMetaTags *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
safecpy(ret->md5, sizeof(ret->md5), row[1]);
ret->tags = cloneString(row[2]);
return ret;
}

struct cdwMetaTags *cdwMetaTagsLoadAll(char *fileName) 
/* Load all cdwMetaTags from a whitespace-separated file.
 * Dispose of this with cdwMetaTagsFreeList(). */
{
struct cdwMetaTags *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileRow(lf, row))
    {
    el = cdwMetaTagsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwMetaTags *cdwMetaTagsLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwMetaTags from a chopper separated file.
 * Dispose of this with cdwMetaTagsFreeList(). */
{
struct cdwMetaTags *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[3];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwMetaTagsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwMetaTags *cdwMetaTagsCommaIn(char **pS, struct cdwMetaTags *ret)
/* Create a cdwMetaTags out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwMetaTags */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->md5, sizeof(ret->md5));
ret->tags = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwMetaTagsFree(struct cdwMetaTags **pEl)
/* Free a single dynamically allocated cdwMetaTags such as created
 * with cdwMetaTagsLoad(). */
{
struct cdwMetaTags *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tags);
freez(pEl);
}

void cdwMetaTagsFreeList(struct cdwMetaTags **pList)
/* Free a list of dynamically allocated cdwMetaTags's */
{
struct cdwMetaTags *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwMetaTagsFree(&el);
    }
*pList = NULL;
}

void cdwMetaTagsOutput(struct cdwMetaTags *el, FILE *f, char sep, char lastSep) 
/* Print out cdwMetaTags.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->md5);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tags);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwFileCommaSepFieldNames = "id,submitId,submitDirId,userId,submitFileName,cdwFileName,startUploadTime,endUploadTime,updateTime,size,md5,tags,metaTagsId,errorMessage,deprecated,replacedBy,userAccess,groupAccess,allAccess";

void cdwFileStaticLoad(char **row, struct cdwFile *ret)
/* Load a row from cdwFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->submitId = sqlUnsigned(row[1]);
ret->submitDirId = sqlUnsigned(row[2]);
ret->userId = sqlUnsigned(row[3]);
ret->submitFileName = row[4];
ret->cdwFileName = row[5];
ret->startUploadTime = sqlLongLong(row[6]);
ret->endUploadTime = sqlLongLong(row[7]);
ret->updateTime = sqlLongLong(row[8]);
ret->size = sqlLongLong(row[9]);
safecpy(ret->md5, sizeof(ret->md5), row[10]);
ret->tags = row[11];
ret->metaTagsId = sqlUnsigned(row[12]);
ret->errorMessage = row[13];
ret->deprecated = row[14];
ret->replacedBy = sqlUnsigned(row[15]);
ret->userAccess = sqlSigned(row[16]);
ret->groupAccess = sqlSigned(row[17]);
ret->allAccess = sqlSigned(row[18]);
}

struct cdwFile *cdwFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwFileFreeList(). */
{
struct cdwFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwFileSaveToDb(struct sqlConnection *conn, struct cdwFile *el, char *tableName, int updateSize)
/* Save cdwFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%u,'%s','%s',%lld,%lld,%lld,%lld,'%s','%s',%u,'%s','%s',%u,%d,%d,%d)", 
	tableName,  el->id,  el->submitId,  el->submitDirId,  el->userId,  el->submitFileName,  el->cdwFileName,  el->startUploadTime,  el->endUploadTime,  el->updateTime,  el->size,  el->md5,  el->tags,  el->metaTagsId,  el->errorMessage,  el->deprecated,  el->replacedBy,  el->userAccess,  el->groupAccess,  el->allAccess);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwFile *cdwFileLoad(char **row)
/* Load a cdwFile from row fetched with select * from cdwFile
 * from database.  Dispose of this with cdwFileFree(). */
{
struct cdwFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->submitId = sqlUnsigned(row[1]);
ret->submitDirId = sqlUnsigned(row[2]);
ret->userId = sqlUnsigned(row[3]);
ret->submitFileName = cloneString(row[4]);
ret->cdwFileName = cloneString(row[5]);
ret->startUploadTime = sqlLongLong(row[6]);
ret->endUploadTime = sqlLongLong(row[7]);
ret->updateTime = sqlLongLong(row[8]);
ret->size = sqlLongLong(row[9]);
safecpy(ret->md5, sizeof(ret->md5), row[10]);
ret->tags = cloneString(row[11]);
ret->metaTagsId = sqlUnsigned(row[12]);
ret->errorMessage = cloneString(row[13]);
ret->deprecated = cloneString(row[14]);
ret->replacedBy = sqlUnsigned(row[15]);
ret->userAccess = sqlSigned(row[16]);
ret->groupAccess = sqlSigned(row[17]);
ret->allAccess = sqlSigned(row[18]);
return ret;
}

struct cdwFile *cdwFileLoadAll(char *fileName) 
/* Load all cdwFile from a whitespace-separated file.
 * Dispose of this with cdwFileFreeList(). */
{
struct cdwFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[19];

while (lineFileRow(lf, row))
    {
    el = cdwFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwFile *cdwFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwFile from a chopper separated file.
 * Dispose of this with cdwFileFreeList(). */
{
struct cdwFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[19];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwFile *cdwFileCommaIn(char **pS, struct cdwFile *ret)
/* Create a cdwFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->submitId = sqlUnsignedComma(&s);
ret->submitDirId = sqlUnsignedComma(&s);
ret->userId = sqlUnsignedComma(&s);
ret->submitFileName = sqlStringComma(&s);
ret->cdwFileName = sqlStringComma(&s);
ret->startUploadTime = sqlLongLongComma(&s);
ret->endUploadTime = sqlLongLongComma(&s);
ret->updateTime = sqlLongLongComma(&s);
ret->size = sqlLongLongComma(&s);
sqlFixedStringComma(&s, ret->md5, sizeof(ret->md5));
ret->tags = sqlStringComma(&s);
ret->metaTagsId = sqlUnsignedComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->deprecated = sqlStringComma(&s);
ret->replacedBy = sqlUnsignedComma(&s);
ret->userAccess = sqlSignedComma(&s);
ret->groupAccess = sqlSignedComma(&s);
ret->allAccess = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwFileFree(struct cdwFile **pEl)
/* Free a single dynamically allocated cdwFile such as created
 * with cdwFileLoad(). */
{
struct cdwFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->submitFileName);
freeMem(el->cdwFileName);
freeMem(el->tags);
freeMem(el->errorMessage);
freeMem(el->deprecated);
freez(pEl);
}

void cdwFileFreeList(struct cdwFile **pList)
/* Free a list of dynamically allocated cdwFile's */
{
struct cdwFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwFileFree(&el);
    }
*pList = NULL;
}

void cdwFileOutput(struct cdwFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->submitId);
fputc(sep,f);
fprintf(f, "%u", el->submitDirId);
fputc(sep,f);
fprintf(f, "%u", el->userId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->submitFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cdwFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->endUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->updateTime);
fputc(sep,f);
fprintf(f, "%lld", el->size);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->md5);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tags);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->metaTagsId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->deprecated);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->replacedBy);
fputc(sep,f);
fprintf(f, "%d", el->userAccess);
fputc(sep,f);
fprintf(f, "%d", el->groupAccess);
fputc(sep,f);
fprintf(f, "%d", el->allAccess);
fputc(lastSep,f);
}


char *cdwSubmitCommaSepFieldNames = "id,url,startUploadTime,endUploadTime,userId,manifestFileId,metaFileId,submitDirId,fileCount,oldFiles,newFiles,byteCount,oldBytes,newBytes,errorMessage,fileIdInTransit,metaChangeCount,wrangler";

void cdwSubmitStaticLoad(char **row, struct cdwSubmit *ret)
/* Load a row from cdwSubmit table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->url = row[1];
ret->startUploadTime = sqlLongLong(row[2]);
ret->endUploadTime = sqlLongLong(row[3]);
ret->userId = sqlUnsigned(row[4]);
ret->manifestFileId = sqlUnsigned(row[5]);
ret->metaFileId = sqlUnsigned(row[6]);
ret->submitDirId = sqlUnsigned(row[7]);
ret->fileCount = sqlUnsigned(row[8]);
ret->oldFiles = sqlUnsigned(row[9]);
ret->newFiles = sqlUnsigned(row[10]);
ret->byteCount = sqlLongLong(row[11]);
ret->oldBytes = sqlLongLong(row[12]);
ret->newBytes = sqlLongLong(row[13]);
ret->errorMessage = row[14];
ret->fileIdInTransit = sqlUnsigned(row[15]);
ret->metaChangeCount = sqlUnsigned(row[16]);
ret->wrangler = row[17];
}

struct cdwSubmit *cdwSubmitLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwSubmit from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubmitFreeList(). */
{
struct cdwSubmit *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwSubmitLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwSubmitSaveToDb(struct sqlConnection *conn, struct cdwSubmit *el, char *tableName, int updateSize)
/* Save cdwSubmit as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,%u,%u,%u,%u,%u,%u,%u,%lld,%lld,%lld,'%s',%u,%u,'%s')", 
	tableName,  el->id,  el->url,  el->startUploadTime,  el->endUploadTime,  el->userId,  el->manifestFileId,  el->metaFileId,  el->submitDirId,  el->fileCount,  el->oldFiles,  el->newFiles,  el->byteCount,  el->oldBytes,  el->newBytes,  el->errorMessage,  el->fileIdInTransit,  el->metaChangeCount,  el->wrangler);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwSubmit *cdwSubmitLoad(char **row)
/* Load a cdwSubmit from row fetched with select * from cdwSubmit
 * from database.  Dispose of this with cdwSubmitFree(). */
{
struct cdwSubmit *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->url = cloneString(row[1]);
ret->startUploadTime = sqlLongLong(row[2]);
ret->endUploadTime = sqlLongLong(row[3]);
ret->userId = sqlUnsigned(row[4]);
ret->manifestFileId = sqlUnsigned(row[5]);
ret->metaFileId = sqlUnsigned(row[6]);
ret->submitDirId = sqlUnsigned(row[7]);
ret->fileCount = sqlUnsigned(row[8]);
ret->oldFiles = sqlUnsigned(row[9]);
ret->newFiles = sqlUnsigned(row[10]);
ret->byteCount = sqlLongLong(row[11]);
ret->oldBytes = sqlLongLong(row[12]);
ret->newBytes = sqlLongLong(row[13]);
ret->errorMessage = cloneString(row[14]);
ret->fileIdInTransit = sqlUnsigned(row[15]);
ret->metaChangeCount = sqlUnsigned(row[16]);
ret->wrangler = cloneString(row[17]);
return ret;
}

struct cdwSubmit *cdwSubmitLoadAll(char *fileName) 
/* Load all cdwSubmit from a whitespace-separated file.
 * Dispose of this with cdwSubmitFreeList(). */
{
struct cdwSubmit *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = cdwSubmitLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubmit *cdwSubmitLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwSubmit from a chopper separated file.
 * Dispose of this with cdwSubmitFreeList(). */
{
struct cdwSubmit *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwSubmitLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubmit *cdwSubmitCommaIn(char **pS, struct cdwSubmit *ret)
/* Create a cdwSubmit out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubmit */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->url = sqlStringComma(&s);
ret->startUploadTime = sqlLongLongComma(&s);
ret->endUploadTime = sqlLongLongComma(&s);
ret->userId = sqlUnsignedComma(&s);
ret->manifestFileId = sqlUnsignedComma(&s);
ret->metaFileId = sqlUnsignedComma(&s);
ret->submitDirId = sqlUnsignedComma(&s);
ret->fileCount = sqlUnsignedComma(&s);
ret->oldFiles = sqlUnsignedComma(&s);
ret->newFiles = sqlUnsignedComma(&s);
ret->byteCount = sqlLongLongComma(&s);
ret->oldBytes = sqlLongLongComma(&s);
ret->newBytes = sqlLongLongComma(&s);
ret->errorMessage = sqlStringComma(&s);
ret->fileIdInTransit = sqlUnsignedComma(&s);
ret->metaChangeCount = sqlUnsignedComma(&s);
ret->wrangler = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwSubmitFree(struct cdwSubmit **pEl)
/* Free a single dynamically allocated cdwSubmit such as created
 * with cdwSubmitLoad(). */
{
struct cdwSubmit *el;

if ((el = *pEl) == NULL) return;
freeMem(el->url);
freeMem(el->errorMessage);
freeMem(el->wrangler);
freez(pEl);
}

void cdwSubmitFreeList(struct cdwSubmit **pList)
/* Free a list of dynamically allocated cdwSubmit's */
{
struct cdwSubmit *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwSubmitFree(&el);
    }
*pList = NULL;
}

void cdwSubmitOutput(struct cdwSubmit *el, FILE *f, char sep, char lastSep) 
/* Print out cdwSubmit.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->url);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startUploadTime);
fputc(sep,f);
fprintf(f, "%lld", el->endUploadTime);
fputc(sep,f);
fprintf(f, "%u", el->userId);
fputc(sep,f);
fprintf(f, "%u", el->manifestFileId);
fputc(sep,f);
fprintf(f, "%u", el->metaFileId);
fputc(sep,f);
fprintf(f, "%u", el->submitDirId);
fputc(sep,f);
fprintf(f, "%u", el->fileCount);
fputc(sep,f);
fprintf(f, "%u", el->oldFiles);
fputc(sep,f);
fprintf(f, "%u", el->newFiles);
fputc(sep,f);
fprintf(f, "%lld", el->byteCount);
fputc(sep,f);
fprintf(f, "%lld", el->oldBytes);
fputc(sep,f);
fprintf(f, "%lld", el->newBytes);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->errorMessage);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileIdInTransit);
fputc(sep,f);
fprintf(f, "%u", el->metaChangeCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->wrangler);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwSubscriberCommaSepFieldNames = "id,name,runOrder,filePattern,dirPattern,tagPattern,onFileEndUpload";

void cdwSubscriberStaticLoad(char **row, struct cdwSubscriber *ret)
/* Load a row from cdwSubscriber table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->runOrder = sqlDouble(row[2]);
ret->filePattern = row[3];
ret->dirPattern = row[4];
ret->tagPattern = row[5];
ret->onFileEndUpload = row[6];
}

struct cdwSubscriber *cdwSubscriberLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwSubscriber from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubscriberFreeList(). */
{
struct cdwSubscriber *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwSubscriberLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwSubscriberSaveToDb(struct sqlConnection *conn, struct cdwSubscriber *el, char *tableName, int updateSize)
/* Save cdwSubscriber as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%g,'%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->runOrder,  el->filePattern,  el->dirPattern,  el->tagPattern,  el->onFileEndUpload);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwSubscriber *cdwSubscriberLoad(char **row)
/* Load a cdwSubscriber from row fetched with select * from cdwSubscriber
 * from database.  Dispose of this with cdwSubscriberFree(). */
{
struct cdwSubscriber *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->runOrder = sqlDouble(row[2]);
ret->filePattern = cloneString(row[3]);
ret->dirPattern = cloneString(row[4]);
ret->tagPattern = cloneString(row[5]);
ret->onFileEndUpload = cloneString(row[6]);
return ret;
}

struct cdwSubscriber *cdwSubscriberLoadAll(char *fileName) 
/* Load all cdwSubscriber from a whitespace-separated file.
 * Dispose of this with cdwSubscriberFreeList(). */
{
struct cdwSubscriber *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = cdwSubscriberLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubscriber *cdwSubscriberLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwSubscriber from a chopper separated file.
 * Dispose of this with cdwSubscriberFreeList(). */
{
struct cdwSubscriber *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwSubscriberLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwSubscriber *cdwSubscriberCommaIn(char **pS, struct cdwSubscriber *ret)
/* Create a cdwSubscriber out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubscriber */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->runOrder = sqlDoubleComma(&s);
ret->filePattern = sqlStringComma(&s);
ret->dirPattern = sqlStringComma(&s);
ret->tagPattern = sqlStringComma(&s);
ret->onFileEndUpload = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwSubscriberFree(struct cdwSubscriber **pEl)
/* Free a single dynamically allocated cdwSubscriber such as created
 * with cdwSubscriberLoad(). */
{
struct cdwSubscriber *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->filePattern);
freeMem(el->dirPattern);
freeMem(el->tagPattern);
freeMem(el->onFileEndUpload);
freez(pEl);
}

void cdwSubscriberFreeList(struct cdwSubscriber **pList)
/* Free a list of dynamically allocated cdwSubscriber's */
{
struct cdwSubscriber *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwSubscriberFree(&el);
    }
*pList = NULL;
}

void cdwSubscriberOutput(struct cdwSubscriber *el, FILE *f, char sep, char lastSep) 
/* Print out cdwSubscriber.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->runOrder);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->filePattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dirPattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tagPattern);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->onFileEndUpload);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwAssemblyCommaSepFieldNames = "id,taxon,name,ucscDb,twoBitId,baseCount,realBaseCount,seqCount";

void cdwAssemblyStaticLoad(char **row, struct cdwAssembly *ret)
/* Load a row from cdwAssembly table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->taxon = sqlUnsigned(row[1]);
ret->name = row[2];
ret->ucscDb = row[3];
ret->twoBitId = sqlUnsigned(row[4]);
ret->baseCount = sqlLongLong(row[5]);
ret->realBaseCount = sqlLongLong(row[6]);
ret->seqCount = sqlUnsigned(row[7]);
}

struct cdwAssembly *cdwAssemblyLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwAssembly from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwAssemblyFreeList(). */
{
struct cdwAssembly *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwAssemblyLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwAssemblySaveToDb(struct sqlConnection *conn, struct cdwAssembly *el, char *tableName, int updateSize)
/* Save cdwAssembly as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s',%u,%lld,%lld,%u)", 
	tableName,  el->id,  el->taxon,  el->name,  el->ucscDb,  el->twoBitId,  el->baseCount,  el->realBaseCount,  el->seqCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwAssembly *cdwAssemblyLoad(char **row)
/* Load a cdwAssembly from row fetched with select * from cdwAssembly
 * from database.  Dispose of this with cdwAssemblyFree(). */
{
struct cdwAssembly *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->taxon = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->ucscDb = cloneString(row[3]);
ret->twoBitId = sqlUnsigned(row[4]);
ret->baseCount = sqlLongLong(row[5]);
ret->realBaseCount = sqlLongLong(row[6]);
ret->seqCount = sqlUnsigned(row[7]);
return ret;
}

struct cdwAssembly *cdwAssemblyLoadAll(char *fileName) 
/* Load all cdwAssembly from a whitespace-separated file.
 * Dispose of this with cdwAssemblyFreeList(). */
{
struct cdwAssembly *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = cdwAssemblyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwAssembly *cdwAssemblyLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwAssembly from a chopper separated file.
 * Dispose of this with cdwAssemblyFreeList(). */
{
struct cdwAssembly *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwAssemblyLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwAssembly *cdwAssemblyCommaIn(char **pS, struct cdwAssembly *ret)
/* Create a cdwAssembly out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwAssembly */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->taxon = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->ucscDb = sqlStringComma(&s);
ret->twoBitId = sqlUnsignedComma(&s);
ret->baseCount = sqlLongLongComma(&s);
ret->realBaseCount = sqlLongLongComma(&s);
ret->seqCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwAssemblyFree(struct cdwAssembly **pEl)
/* Free a single dynamically allocated cdwAssembly such as created
 * with cdwAssemblyLoad(). */
{
struct cdwAssembly *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->ucscDb);
freez(pEl);
}

void cdwAssemblyFreeList(struct cdwAssembly **pList)
/* Free a list of dynamically allocated cdwAssembly's */
{
struct cdwAssembly *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwAssemblyFree(&el);
    }
*pList = NULL;
}

void cdwAssemblyOutput(struct cdwAssembly *el, FILE *f, char sep, char lastSep) 
/* Print out cdwAssembly.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ucscDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->twoBitId);
fputc(sep,f);
fprintf(f, "%lld", el->baseCount);
fputc(sep,f);
fprintf(f, "%lld", el->realBaseCount);
fputc(sep,f);
fprintf(f, "%u", el->seqCount);
fputc(lastSep,f);
}


char *cdwBiosampleCommaSepFieldNames = "id,term,taxon,sex";

void cdwBiosampleStaticLoad(char **row, struct cdwBiosample *ret)
/* Load a row from cdwBiosample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->term = row[1];
ret->taxon = sqlUnsigned(row[2]);
ret->sex = row[3];
}

struct cdwBiosample *cdwBiosampleLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwBiosample from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwBiosampleFreeList(). */
{
struct cdwBiosample *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwBiosampleLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwBiosampleSaveToDb(struct sqlConnection *conn, struct cdwBiosample *el, char *tableName, int updateSize)
/* Save cdwBiosample as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,'%s')", 
	tableName,  el->id,  el->term,  el->taxon,  el->sex);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwBiosample *cdwBiosampleLoad(char **row)
/* Load a cdwBiosample from row fetched with select * from cdwBiosample
 * from database.  Dispose of this with cdwBiosampleFree(). */
{
struct cdwBiosample *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->term = cloneString(row[1]);
ret->taxon = sqlUnsigned(row[2]);
ret->sex = cloneString(row[3]);
return ret;
}

struct cdwBiosample *cdwBiosampleLoadAll(char *fileName) 
/* Load all cdwBiosample from a whitespace-separated file.
 * Dispose of this with cdwBiosampleFreeList(). */
{
struct cdwBiosample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = cdwBiosampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwBiosample *cdwBiosampleLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwBiosample from a chopper separated file.
 * Dispose of this with cdwBiosampleFreeList(). */
{
struct cdwBiosample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwBiosampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwBiosample *cdwBiosampleCommaIn(char **pS, struct cdwBiosample *ret)
/* Create a cdwBiosample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwBiosample */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->term = sqlStringComma(&s);
ret->taxon = sqlUnsignedComma(&s);
ret->sex = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwBiosampleFree(struct cdwBiosample **pEl)
/* Free a single dynamically allocated cdwBiosample such as created
 * with cdwBiosampleLoad(). */
{
struct cdwBiosample *el;

if ((el = *pEl) == NULL) return;
freeMem(el->term);
freeMem(el->sex);
freez(pEl);
}

void cdwBiosampleFreeList(struct cdwBiosample **pList)
/* Free a list of dynamically allocated cdwBiosample's */
{
struct cdwBiosample *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwBiosampleFree(&el);
    }
*pList = NULL;
}

void cdwBiosampleOutput(struct cdwBiosample *el, FILE *f, char sep, char lastSep) 
/* Print out cdwBiosample.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->term);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->taxon);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sex);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwExperimentCommaSepFieldNames = "accession,dataType,lab,biosample,rfa,assayType,ipTarget,control";

void cdwExperimentStaticLoad(char **row, struct cdwExperiment *ret)
/* Load a row from cdwExperiment table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

safecpy(ret->accession, sizeof(ret->accession), row[0]);
ret->dataType = row[1];
ret->lab = row[2];
ret->biosample = row[3];
ret->rfa = row[4];
ret->assayType = row[5];
ret->ipTarget = row[6];
ret->control = row[7];
}

struct cdwExperiment *cdwExperimentLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwExperiment from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwExperimentFreeList(). */
{
struct cdwExperiment *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwExperimentLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwExperimentSaveToDb(struct sqlConnection *conn, struct cdwExperiment *el, char *tableName, int updateSize)
/* Save cdwExperiment as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s','%s','%s','%s','%s','%s','%s')", 
	tableName,  el->accession,  el->dataType,  el->lab,  el->biosample,  el->rfa,  el->assayType,  el->ipTarget,  el->control);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwExperiment *cdwExperimentLoad(char **row)
/* Load a cdwExperiment from row fetched with select * from cdwExperiment
 * from database.  Dispose of this with cdwExperimentFree(). */
{
struct cdwExperiment *ret;

AllocVar(ret);
safecpy(ret->accession, sizeof(ret->accession), row[0]);
ret->dataType = cloneString(row[1]);
ret->lab = cloneString(row[2]);
ret->biosample = cloneString(row[3]);
ret->rfa = cloneString(row[4]);
ret->assayType = cloneString(row[5]);
ret->ipTarget = cloneString(row[6]);
ret->control = cloneString(row[7]);
return ret;
}

struct cdwExperiment *cdwExperimentLoadAll(char *fileName) 
/* Load all cdwExperiment from a whitespace-separated file.
 * Dispose of this with cdwExperimentFreeList(). */
{
struct cdwExperiment *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = cdwExperimentLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwExperiment *cdwExperimentLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwExperiment from a chopper separated file.
 * Dispose of this with cdwExperimentFreeList(). */
{
struct cdwExperiment *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwExperimentLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwExperiment *cdwExperimentCommaIn(char **pS, struct cdwExperiment *ret)
/* Create a cdwExperiment out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwExperiment */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->accession, sizeof(ret->accession));
ret->dataType = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
ret->biosample = sqlStringComma(&s);
ret->rfa = sqlStringComma(&s);
ret->assayType = sqlStringComma(&s);
ret->ipTarget = sqlStringComma(&s);
ret->control = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwExperimentFree(struct cdwExperiment **pEl)
/* Free a single dynamically allocated cdwExperiment such as created
 * with cdwExperimentLoad(). */
{
struct cdwExperiment *el;

if ((el = *pEl) == NULL) return;
freeMem(el->dataType);
freeMem(el->lab);
freeMem(el->biosample);
freeMem(el->rfa);
freeMem(el->assayType);
freeMem(el->ipTarget);
freeMem(el->control);
freez(pEl);
}

void cdwExperimentFreeList(struct cdwExperiment **pList)
/* Free a list of dynamically allocated cdwExperiment's */
{
struct cdwExperiment *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwExperimentFree(&el);
    }
*pList = NULL;
}

void cdwExperimentOutput(struct cdwExperiment *el, FILE *f, char sep, char lastSep) 
/* Print out cdwExperiment.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->accession);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->dataType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->biosample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->rfa);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assayType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ipTarget);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->control);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwValidFileCommaSepFieldNames = "id,licensePlate,fileId,format,outputType,experiment,replicate,enrichedIn,ucscDb,itemCount,basesInItems,sampleCount,basesInSample,sampleBed,mapRatio,sampleCoverage,depth,singleQaStatus,replicateQaStatus,part,pairedEnd,qaVersion,uniqueMapRatio,lane";

void cdwValidFileStaticLoad(char **row, struct cdwValidFile *ret)
/* Load a row from cdwValidFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
safecpy(ret->licensePlate, sizeof(ret->licensePlate), row[1]);
ret->fileId = sqlUnsigned(row[2]);
ret->format = row[3];
ret->outputType = row[4];
ret->experiment = row[5];
ret->replicate = row[6];
ret->enrichedIn = row[7];
ret->ucscDb = row[8];
ret->itemCount = sqlLongLong(row[9]);
ret->basesInItems = sqlLongLong(row[10]);
ret->sampleCount = sqlLongLong(row[11]);
ret->basesInSample = sqlLongLong(row[12]);
ret->sampleBed = row[13];
ret->mapRatio = sqlDouble(row[14]);
ret->sampleCoverage = sqlDouble(row[15]);
ret->depth = sqlDouble(row[16]);
ret->singleQaStatus = sqlSigned(row[17]);
ret->replicateQaStatus = sqlSigned(row[18]);
ret->part = row[19];
ret->pairedEnd = row[20];
ret->qaVersion = sqlSigned(row[21]);
ret->uniqueMapRatio = sqlDouble(row[22]);
ret->lane = row[23];
}

struct cdwValidFile *cdwValidFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwValidFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwValidFileFreeList(). */
{
struct cdwValidFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwValidFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwValidFileSaveToDb(struct sqlConnection *conn, struct cdwValidFile *el, char *tableName, int updateSize)
/* Save cdwValidFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%u,'%s','%s','%s','%s','%s','%s',%lld,%lld,%lld,%lld,'%s',%g,%g,%g,%d,%d,'%s','%s',%d,%g,'%s')", 
	tableName,  el->id,  el->licensePlate,  el->fileId,  el->format,  el->outputType,  el->experiment,  el->replicate,  el->enrichedIn,  el->ucscDb,  el->itemCount,  el->basesInItems,  el->sampleCount,  el->basesInSample,  el->sampleBed,  el->mapRatio,  el->sampleCoverage,  el->depth,  el->singleQaStatus,  el->replicateQaStatus,  el->part,  el->pairedEnd,  el->qaVersion,  el->uniqueMapRatio,  el->lane);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwValidFile *cdwValidFileLoad(char **row)
/* Load a cdwValidFile from row fetched with select * from cdwValidFile
 * from database.  Dispose of this with cdwValidFileFree(). */
{
struct cdwValidFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
safecpy(ret->licensePlate, sizeof(ret->licensePlate), row[1]);
ret->fileId = sqlUnsigned(row[2]);
ret->format = cloneString(row[3]);
ret->outputType = cloneString(row[4]);
ret->experiment = cloneString(row[5]);
ret->replicate = cloneString(row[6]);
ret->enrichedIn = cloneString(row[7]);
ret->ucscDb = cloneString(row[8]);
ret->itemCount = sqlLongLong(row[9]);
ret->basesInItems = sqlLongLong(row[10]);
ret->sampleCount = sqlLongLong(row[11]);
ret->basesInSample = sqlLongLong(row[12]);
ret->sampleBed = cloneString(row[13]);
ret->mapRatio = sqlDouble(row[14]);
ret->sampleCoverage = sqlDouble(row[15]);
ret->depth = sqlDouble(row[16]);
ret->singleQaStatus = sqlSigned(row[17]);
ret->replicateQaStatus = sqlSigned(row[18]);
ret->part = cloneString(row[19]);
ret->pairedEnd = cloneString(row[20]);
ret->qaVersion = sqlSigned(row[21]);
ret->uniqueMapRatio = sqlDouble(row[22]);
ret->lane = cloneString(row[23]);
return ret;
}

struct cdwValidFile *cdwValidFileLoadAll(char *fileName) 
/* Load all cdwValidFile from a whitespace-separated file.
 * Dispose of this with cdwValidFileFreeList(). */
{
struct cdwValidFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileRow(lf, row))
    {
    el = cdwValidFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwValidFile *cdwValidFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwValidFile from a chopper separated file.
 * Dispose of this with cdwValidFileFreeList(). */
{
struct cdwValidFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[24];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwValidFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwValidFile *cdwValidFileCommaIn(char **pS, struct cdwValidFile *ret)
/* Create a cdwValidFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwValidFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->licensePlate, sizeof(ret->licensePlate));
ret->fileId = sqlUnsignedComma(&s);
ret->format = sqlStringComma(&s);
ret->outputType = sqlStringComma(&s);
ret->experiment = sqlStringComma(&s);
ret->replicate = sqlStringComma(&s);
ret->enrichedIn = sqlStringComma(&s);
ret->ucscDb = sqlStringComma(&s);
ret->itemCount = sqlLongLongComma(&s);
ret->basesInItems = sqlLongLongComma(&s);
ret->sampleCount = sqlLongLongComma(&s);
ret->basesInSample = sqlLongLongComma(&s);
ret->sampleBed = sqlStringComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
ret->sampleCoverage = sqlDoubleComma(&s);
ret->depth = sqlDoubleComma(&s);
ret->singleQaStatus = sqlSignedComma(&s);
ret->replicateQaStatus = sqlSignedComma(&s);
ret->part = sqlStringComma(&s);
ret->pairedEnd = sqlStringComma(&s);
ret->qaVersion = sqlSignedComma(&s);
ret->uniqueMapRatio = sqlDoubleComma(&s);
ret->lane = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwValidFileFree(struct cdwValidFile **pEl)
/* Free a single dynamically allocated cdwValidFile such as created
 * with cdwValidFileLoad(). */
{
struct cdwValidFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->format);
freeMem(el->outputType);
freeMem(el->experiment);
freeMem(el->replicate);
freeMem(el->enrichedIn);
freeMem(el->ucscDb);
freeMem(el->sampleBed);
freeMem(el->part);
freeMem(el->pairedEnd);
freeMem(el->lane);
freez(pEl);
}

void cdwValidFileFreeList(struct cdwValidFile **pList)
/* Free a list of dynamically allocated cdwValidFile's */
{
struct cdwValidFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwValidFileFree(&el);
    }
*pList = NULL;
}

void cdwValidFileOutput(struct cdwValidFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwValidFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->licensePlate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->format);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->outputType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->experiment);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->replicate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->enrichedIn);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ucscDb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->itemCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInItems);
fputc(sep,f);
fprintf(f, "%lld", el->sampleCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSample);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleBed);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(sep,f);
fprintf(f, "%g", el->sampleCoverage);
fputc(sep,f);
fprintf(f, "%g", el->depth);
fputc(sep,f);
fprintf(f, "%d", el->singleQaStatus);
fputc(sep,f);
fprintf(f, "%d", el->replicateQaStatus);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->part);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pairedEnd);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->qaVersion);
fputc(sep,f);
fprintf(f, "%g", el->uniqueMapRatio);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lane);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwFastqFileCommaSepFieldNames = "id,fileId,sampleCount,basesInSample,sampleFileName,readCount,baseCount,readSizeMean,readSizeStd,readSizeMin,readSizeMax,qualMean,qualStd,qualMin,qualMax,qualType,qualZero,atRatio,aRatio,cRatio,gRatio,tRatio,nRatio,qualPos,aAtPos,cAtPos,gAtPos,tAtPos,nAtPos";

struct cdwFastqFile *cdwFastqFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwFastqFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwFastqFileFreeList(). */
{
struct cdwFastqFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwFastqFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwFastqFileSaveToDb(struct sqlConnection *conn, struct cdwFastqFile *el, char *tableName, int updateSize)
/* Save cdwFastqFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
char  *qualPosArray, *aAtPosArray, *cAtPosArray, *gAtPosArray, *tAtPosArray, *nAtPosArray;
qualPosArray = sqlDoubleArrayToString(el->qualPos, el->readSizeMax);
aAtPosArray = sqlDoubleArrayToString(el->aAtPos, el->readSizeMax);
cAtPosArray = sqlDoubleArrayToString(el->cAtPos, el->readSizeMax);
gAtPosArray = sqlDoubleArrayToString(el->gAtPos, el->readSizeMax);
tAtPosArray = sqlDoubleArrayToString(el->tAtPos, el->readSizeMax);
nAtPosArray = sqlDoubleArrayToString(el->nAtPos, el->readSizeMax);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%lld,%lld,'%s',%lld,%lld,%g,%g,%d,%d,%g,%g,%g,%g,'%s',%d,%g,%g,%g,%g,%g,%g,'%s','%s','%s','%s','%s','%s')", 
	tableName,  el->id,  el->fileId,  el->sampleCount,  el->basesInSample,  el->sampleFileName,  el->readCount,  el->baseCount,  el->readSizeMean,  el->readSizeStd,  el->readSizeMin,  el->readSizeMax,  el->qualMean,  el->qualStd,  el->qualMin,  el->qualMax,  el->qualType,  el->qualZero,  el->atRatio,  el->aRatio,  el->cRatio,  el->gRatio,  el->tRatio,  el->nRatio,  qualPosArray ,  aAtPosArray ,  cAtPosArray ,  gAtPosArray ,  tAtPosArray ,  nAtPosArray );
sqlUpdate(conn, update->string);
dyStringFree(&update);
freez(&qualPosArray);
freez(&aAtPosArray);
freez(&cAtPosArray);
freez(&gAtPosArray);
freez(&tAtPosArray);
freez(&nAtPosArray);
}

struct cdwFastqFile *cdwFastqFileLoad(char **row)
/* Load a cdwFastqFile from row fetched with select * from cdwFastqFile
 * from database.  Dispose of this with cdwFastqFileFree(). */
{
struct cdwFastqFile *ret;

AllocVar(ret);
ret->readSizeMax = sqlSigned(row[10]);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleCount = sqlLongLong(row[2]);
ret->basesInSample = sqlLongLong(row[3]);
ret->sampleFileName = cloneString(row[4]);
ret->readCount = sqlLongLong(row[5]);
ret->baseCount = sqlLongLong(row[6]);
ret->readSizeMean = sqlDouble(row[7]);
ret->readSizeStd = sqlDouble(row[8]);
ret->readSizeMin = sqlSigned(row[9]);
ret->qualMean = sqlDouble(row[11]);
ret->qualStd = sqlDouble(row[12]);
ret->qualMin = sqlDouble(row[13]);
ret->qualMax = sqlDouble(row[14]);
ret->qualType = cloneString(row[15]);
ret->qualZero = sqlSigned(row[16]);
ret->atRatio = sqlDouble(row[17]);
ret->aRatio = sqlDouble(row[18]);
ret->cRatio = sqlDouble(row[19]);
ret->gRatio = sqlDouble(row[20]);
ret->tRatio = sqlDouble(row[21]);
ret->nRatio = sqlDouble(row[22]);
{
int sizeOne;
sqlDoubleDynamicArray(row[23], &ret->qualPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[24], &ret->aAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[25], &ret->cAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[26], &ret->gAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[27], &ret->tAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
{
int sizeOne;
sqlDoubleDynamicArray(row[28], &ret->nAtPos, &sizeOne);
assert(sizeOne == ret->readSizeMax);
}
return ret;
}

struct cdwFastqFile *cdwFastqFileLoadAll(char *fileName) 
/* Load all cdwFastqFile from a whitespace-separated file.
 * Dispose of this with cdwFastqFileFreeList(). */
{
struct cdwFastqFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[29];

while (lineFileRow(lf, row))
    {
    el = cdwFastqFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwFastqFile *cdwFastqFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwFastqFile from a chopper separated file.
 * Dispose of this with cdwFastqFileFreeList(). */
{
struct cdwFastqFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[29];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwFastqFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwFastqFile *cdwFastqFileCommaIn(char **pS, struct cdwFastqFile *ret)
/* Create a cdwFastqFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwFastqFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->sampleCount = sqlLongLongComma(&s);
ret->basesInSample = sqlLongLongComma(&s);
ret->sampleFileName = sqlStringComma(&s);
ret->readCount = sqlLongLongComma(&s);
ret->baseCount = sqlLongLongComma(&s);
ret->readSizeMean = sqlDoubleComma(&s);
ret->readSizeStd = sqlDoubleComma(&s);
ret->readSizeMin = sqlSignedComma(&s);
ret->readSizeMax = sqlSignedComma(&s);
ret->qualMean = sqlDoubleComma(&s);
ret->qualStd = sqlDoubleComma(&s);
ret->qualMin = sqlDoubleComma(&s);
ret->qualMax = sqlDoubleComma(&s);
ret->qualType = sqlStringComma(&s);
ret->qualZero = sqlSignedComma(&s);
ret->atRatio = sqlDoubleComma(&s);
ret->aRatio = sqlDoubleComma(&s);
ret->cRatio = sqlDoubleComma(&s);
ret->gRatio = sqlDoubleComma(&s);
ret->tRatio = sqlDoubleComma(&s);
ret->nRatio = sqlDoubleComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->qualPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->qualPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->aAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->aAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->cAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->cAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->gAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->gAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->tAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->tAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->nAtPos, ret->readSizeMax);
for (i=0; i<ret->readSizeMax; ++i)
    {
    ret->nAtPos[i] = sqlDoubleComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void cdwFastqFileFree(struct cdwFastqFile **pEl)
/* Free a single dynamically allocated cdwFastqFile such as created
 * with cdwFastqFileLoad(). */
{
struct cdwFastqFile *el;

if ((el = *pEl) == NULL) return;
freeMem(el->sampleFileName);
freeMem(el->qualType);
freeMem(el->qualPos);
freeMem(el->aAtPos);
freeMem(el->cAtPos);
freeMem(el->gAtPos);
freeMem(el->tAtPos);
freeMem(el->nAtPos);
freez(pEl);
}

void cdwFastqFileFreeList(struct cdwFastqFile **pList)
/* Free a list of dynamically allocated cdwFastqFile's */
{
struct cdwFastqFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwFastqFileFree(&el);
    }
*pList = NULL;
}

void cdwFastqFileOutput(struct cdwFastqFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwFastqFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%lld", el->sampleCount);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSample);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleFileName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->readCount);
fputc(sep,f);
fprintf(f, "%lld", el->baseCount);
fputc(sep,f);
fprintf(f, "%g", el->readSizeMean);
fputc(sep,f);
fprintf(f, "%g", el->readSizeStd);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMin);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMax);
fputc(sep,f);
fprintf(f, "%g", el->qualMean);
fputc(sep,f);
fprintf(f, "%g", el->qualStd);
fputc(sep,f);
fprintf(f, "%g", el->qualMin);
fputc(sep,f);
fprintf(f, "%g", el->qualMax);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->qualType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->qualZero);
fputc(sep,f);
fprintf(f, "%g", el->atRatio);
fputc(sep,f);
fprintf(f, "%g", el->aRatio);
fputc(sep,f);
fprintf(f, "%g", el->cRatio);
fputc(sep,f);
fprintf(f, "%g", el->gRatio);
fputc(sep,f);
fprintf(f, "%g", el->tRatio);
fputc(sep,f);
fprintf(f, "%g", el->nRatio);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->qualPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->aAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->cAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->gAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->tAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->readSizeMax; ++i)
    {
    fprintf(f, "%g", el->nAtPos[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}


char *cdwBamFileCommaSepFieldNames = "id,fileId,isPaired,isSortedByTarget,readCount,readBaseCount,mappedCount,uniqueMappedCount,readSizeMean,readSizeStd,readSizeMin,readSizeMax,u4mReadCount,u4mUniquePos,u4mUniqueRatio,targetBaseCount,targetSeqCount";

void cdwBamFileStaticLoad(char **row, struct cdwBamFile *ret)
/* Load a row from cdwBamFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->isPaired = sqlSigned(row[2]);
ret->isSortedByTarget = sqlSigned(row[3]);
ret->readCount = sqlLongLong(row[4]);
ret->readBaseCount = sqlLongLong(row[5]);
ret->mappedCount = sqlLongLong(row[6]);
ret->uniqueMappedCount = sqlLongLong(row[7]);
ret->readSizeMean = sqlDouble(row[8]);
ret->readSizeStd = sqlDouble(row[9]);
ret->readSizeMin = sqlSigned(row[10]);
ret->readSizeMax = sqlSigned(row[11]);
ret->u4mReadCount = sqlSigned(row[12]);
ret->u4mUniquePos = sqlSigned(row[13]);
ret->u4mUniqueRatio = sqlDouble(row[14]);
ret->targetBaseCount = sqlLongLong(row[15]);
ret->targetSeqCount = sqlUnsigned(row[16]);
}

struct cdwBamFile *cdwBamFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwBamFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwBamFileFreeList(). */
{
struct cdwBamFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwBamFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwBamFileSaveToDb(struct sqlConnection *conn, struct cdwBamFile *el, char *tableName, int updateSize)
/* Save cdwBamFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%d,%d,%lld,%lld,%lld,%lld,%g,%g,%d,%d,%d,%d,%g,%lld,%u)", 
	tableName,  el->id,  el->fileId,  el->isPaired,  el->isSortedByTarget,  el->readCount,  el->readBaseCount,  el->mappedCount,  el->uniqueMappedCount,  el->readSizeMean,  el->readSizeStd,  el->readSizeMin,  el->readSizeMax,  el->u4mReadCount,  el->u4mUniquePos,  el->u4mUniqueRatio,  el->targetBaseCount,  el->targetSeqCount);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwBamFile *cdwBamFileLoad(char **row)
/* Load a cdwBamFile from row fetched with select * from cdwBamFile
 * from database.  Dispose of this with cdwBamFileFree(). */
{
struct cdwBamFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->isPaired = sqlSigned(row[2]);
ret->isSortedByTarget = sqlSigned(row[3]);
ret->readCount = sqlLongLong(row[4]);
ret->readBaseCount = sqlLongLong(row[5]);
ret->mappedCount = sqlLongLong(row[6]);
ret->uniqueMappedCount = sqlLongLong(row[7]);
ret->readSizeMean = sqlDouble(row[8]);
ret->readSizeStd = sqlDouble(row[9]);
ret->readSizeMin = sqlSigned(row[10]);
ret->readSizeMax = sqlSigned(row[11]);
ret->u4mReadCount = sqlSigned(row[12]);
ret->u4mUniquePos = sqlSigned(row[13]);
ret->u4mUniqueRatio = sqlDouble(row[14]);
ret->targetBaseCount = sqlLongLong(row[15]);
ret->targetSeqCount = sqlUnsigned(row[16]);
return ret;
}

struct cdwBamFile *cdwBamFileLoadAll(char *fileName) 
/* Load all cdwBamFile from a whitespace-separated file.
 * Dispose of this with cdwBamFileFreeList(). */
{
struct cdwBamFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[17];

while (lineFileRow(lf, row))
    {
    el = cdwBamFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwBamFile *cdwBamFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwBamFile from a chopper separated file.
 * Dispose of this with cdwBamFileFreeList(). */
{
struct cdwBamFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[17];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwBamFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwBamFile *cdwBamFileCommaIn(char **pS, struct cdwBamFile *ret)
/* Create a cdwBamFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwBamFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->isPaired = sqlSignedComma(&s);
ret->isSortedByTarget = sqlSignedComma(&s);
ret->readCount = sqlLongLongComma(&s);
ret->readBaseCount = sqlLongLongComma(&s);
ret->mappedCount = sqlLongLongComma(&s);
ret->uniqueMappedCount = sqlLongLongComma(&s);
ret->readSizeMean = sqlDoubleComma(&s);
ret->readSizeStd = sqlDoubleComma(&s);
ret->readSizeMin = sqlSignedComma(&s);
ret->readSizeMax = sqlSignedComma(&s);
ret->u4mReadCount = sqlSignedComma(&s);
ret->u4mUniquePos = sqlSignedComma(&s);
ret->u4mUniqueRatio = sqlDoubleComma(&s);
ret->targetBaseCount = sqlLongLongComma(&s);
ret->targetSeqCount = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwBamFileFree(struct cdwBamFile **pEl)
/* Free a single dynamically allocated cdwBamFile such as created
 * with cdwBamFileLoad(). */
{
struct cdwBamFile *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwBamFileFreeList(struct cdwBamFile **pList)
/* Free a list of dynamically allocated cdwBamFile's */
{
struct cdwBamFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwBamFileFree(&el);
    }
*pList = NULL;
}

void cdwBamFileOutput(struct cdwBamFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwBamFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%d", el->isPaired);
fputc(sep,f);
fprintf(f, "%d", el->isSortedByTarget);
fputc(sep,f);
fprintf(f, "%lld", el->readCount);
fputc(sep,f);
fprintf(f, "%lld", el->readBaseCount);
fputc(sep,f);
fprintf(f, "%lld", el->mappedCount);
fputc(sep,f);
fprintf(f, "%lld", el->uniqueMappedCount);
fputc(sep,f);
fprintf(f, "%g", el->readSizeMean);
fputc(sep,f);
fprintf(f, "%g", el->readSizeStd);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMin);
fputc(sep,f);
fprintf(f, "%d", el->readSizeMax);
fputc(sep,f);
fprintf(f, "%d", el->u4mReadCount);
fputc(sep,f);
fprintf(f, "%d", el->u4mUniquePos);
fputc(sep,f);
fprintf(f, "%g", el->u4mUniqueRatio);
fputc(sep,f);
fprintf(f, "%lld", el->targetBaseCount);
fputc(sep,f);
fprintf(f, "%u", el->targetSeqCount);
fputc(lastSep,f);
}


char *cdwVcfFileCommaSepFieldNames = "id,fileId,vcfMajorVersion,vcfMinorVersion,genotypeCount,itemCount,chromsHit,passItemCount,passRatio,snpItemCount,snpRatio,sumOfSizes,basesCovered,xBasesCovered,yBasesCovered,mBasesCovered,haploidCount,haploidRatio,phasedCount,phasedRatio,gotDepth,depthMin,depthMean,depthMax,depthStd";

void cdwVcfFileStaticLoad(char **row, struct cdwVcfFile *ret)
/* Load a row from cdwVcfFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->vcfMajorVersion = sqlSigned(row[2]);
ret->vcfMinorVersion = sqlSigned(row[3]);
ret->genotypeCount = sqlSigned(row[4]);
ret->itemCount = sqlLongLong(row[5]);
ret->chromsHit = sqlSigned(row[6]);
ret->passItemCount = sqlLongLong(row[7]);
ret->passRatio = sqlDouble(row[8]);
ret->snpItemCount = sqlLongLong(row[9]);
ret->snpRatio = sqlDouble(row[10]);
ret->sumOfSizes = sqlLongLong(row[11]);
ret->basesCovered = sqlLongLong(row[12]);
ret->xBasesCovered = sqlSigned(row[13]);
ret->yBasesCovered = sqlSigned(row[14]);
ret->mBasesCovered = sqlSigned(row[15]);
ret->haploidCount = sqlLongLong(row[16]);
ret->haploidRatio = sqlDouble(row[17]);
ret->phasedCount = sqlLongLong(row[18]);
ret->phasedRatio = sqlDouble(row[19]);
ret->gotDepth = sqlSigned(row[20]);
ret->depthMin = sqlDouble(row[21]);
ret->depthMean = sqlDouble(row[22]);
ret->depthMax = sqlDouble(row[23]);
ret->depthStd = sqlDouble(row[24]);
}

struct cdwVcfFile *cdwVcfFileLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwVcfFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwVcfFileFreeList(). */
{
struct cdwVcfFile *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwVcfFileLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwVcfFileSaveToDb(struct sqlConnection *conn, struct cdwVcfFile *el, char *tableName, int updateSize)
/* Save cdwVcfFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%d,%d,%d,%lld,%d,%lld,%g,%lld,%g,%lld,%lld,%d,%d,%d,%lld,%g,%lld,%g,%d,%g,%g,%g,%g)", 
	tableName,  el->id,  el->fileId,  el->vcfMajorVersion,  el->vcfMinorVersion,  el->genotypeCount,  el->itemCount,  el->chromsHit,  el->passItemCount,  el->passRatio,  el->snpItemCount,  el->snpRatio,  el->sumOfSizes,  el->basesCovered,  el->xBasesCovered,  el->yBasesCovered,  el->mBasesCovered,  el->haploidCount,  el->haploidRatio,  el->phasedCount,  el->phasedRatio,  el->gotDepth,  el->depthMin,  el->depthMean,  el->depthMax,  el->depthStd);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwVcfFile *cdwVcfFileLoad(char **row)
/* Load a cdwVcfFile from row fetched with select * from cdwVcfFile
 * from database.  Dispose of this with cdwVcfFileFree(). */
{
struct cdwVcfFile *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->vcfMajorVersion = sqlSigned(row[2]);
ret->vcfMinorVersion = sqlSigned(row[3]);
ret->genotypeCount = sqlSigned(row[4]);
ret->itemCount = sqlLongLong(row[5]);
ret->chromsHit = sqlSigned(row[6]);
ret->passItemCount = sqlLongLong(row[7]);
ret->passRatio = sqlDouble(row[8]);
ret->snpItemCount = sqlLongLong(row[9]);
ret->snpRatio = sqlDouble(row[10]);
ret->sumOfSizes = sqlLongLong(row[11]);
ret->basesCovered = sqlLongLong(row[12]);
ret->xBasesCovered = sqlSigned(row[13]);
ret->yBasesCovered = sqlSigned(row[14]);
ret->mBasesCovered = sqlSigned(row[15]);
ret->haploidCount = sqlLongLong(row[16]);
ret->haploidRatio = sqlDouble(row[17]);
ret->phasedCount = sqlLongLong(row[18]);
ret->phasedRatio = sqlDouble(row[19]);
ret->gotDepth = sqlSigned(row[20]);
ret->depthMin = sqlDouble(row[21]);
ret->depthMean = sqlDouble(row[22]);
ret->depthMax = sqlDouble(row[23]);
ret->depthStd = sqlDouble(row[24]);
return ret;
}

struct cdwVcfFile *cdwVcfFileLoadAll(char *fileName) 
/* Load all cdwVcfFile from a whitespace-separated file.
 * Dispose of this with cdwVcfFileFreeList(). */
{
struct cdwVcfFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[25];

while (lineFileRow(lf, row))
    {
    el = cdwVcfFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwVcfFile *cdwVcfFileLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwVcfFile from a chopper separated file.
 * Dispose of this with cdwVcfFileFreeList(). */
{
struct cdwVcfFile *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[25];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwVcfFileLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwVcfFile *cdwVcfFileCommaIn(char **pS, struct cdwVcfFile *ret)
/* Create a cdwVcfFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwVcfFile */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->vcfMajorVersion = sqlSignedComma(&s);
ret->vcfMinorVersion = sqlSignedComma(&s);
ret->genotypeCount = sqlSignedComma(&s);
ret->itemCount = sqlLongLongComma(&s);
ret->chromsHit = sqlSignedComma(&s);
ret->passItemCount = sqlLongLongComma(&s);
ret->passRatio = sqlDoubleComma(&s);
ret->snpItemCount = sqlLongLongComma(&s);
ret->snpRatio = sqlDoubleComma(&s);
ret->sumOfSizes = sqlLongLongComma(&s);
ret->basesCovered = sqlLongLongComma(&s);
ret->xBasesCovered = sqlSignedComma(&s);
ret->yBasesCovered = sqlSignedComma(&s);
ret->mBasesCovered = sqlSignedComma(&s);
ret->haploidCount = sqlLongLongComma(&s);
ret->haploidRatio = sqlDoubleComma(&s);
ret->phasedCount = sqlLongLongComma(&s);
ret->phasedRatio = sqlDoubleComma(&s);
ret->gotDepth = sqlSignedComma(&s);
ret->depthMin = sqlDoubleComma(&s);
ret->depthMean = sqlDoubleComma(&s);
ret->depthMax = sqlDoubleComma(&s);
ret->depthStd = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwVcfFileFree(struct cdwVcfFile **pEl)
/* Free a single dynamically allocated cdwVcfFile such as created
 * with cdwVcfFileLoad(). */
{
struct cdwVcfFile *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwVcfFileFreeList(struct cdwVcfFile **pList)
/* Free a list of dynamically allocated cdwVcfFile's */
{
struct cdwVcfFile *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwVcfFileFree(&el);
    }
*pList = NULL;
}

void cdwVcfFileOutput(struct cdwVcfFile *el, FILE *f, char sep, char lastSep) 
/* Print out cdwVcfFile.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%d", el->vcfMajorVersion);
fputc(sep,f);
fprintf(f, "%d", el->vcfMinorVersion);
fputc(sep,f);
fprintf(f, "%d", el->genotypeCount);
fputc(sep,f);
fprintf(f, "%lld", el->itemCount);
fputc(sep,f);
fprintf(f, "%d", el->chromsHit);
fputc(sep,f);
fprintf(f, "%lld", el->passItemCount);
fputc(sep,f);
fprintf(f, "%g", el->passRatio);
fputc(sep,f);
fprintf(f, "%lld", el->snpItemCount);
fputc(sep,f);
fprintf(f, "%g", el->snpRatio);
fputc(sep,f);
fprintf(f, "%lld", el->sumOfSizes);
fputc(sep,f);
fprintf(f, "%lld", el->basesCovered);
fputc(sep,f);
fprintf(f, "%d", el->xBasesCovered);
fputc(sep,f);
fprintf(f, "%d", el->yBasesCovered);
fputc(sep,f);
fprintf(f, "%d", el->mBasesCovered);
fputc(sep,f);
fprintf(f, "%lld", el->haploidCount);
fputc(sep,f);
fprintf(f, "%g", el->haploidRatio);
fputc(sep,f);
fprintf(f, "%lld", el->phasedCount);
fputc(sep,f);
fprintf(f, "%g", el->phasedRatio);
fputc(sep,f);
fprintf(f, "%d", el->gotDepth);
fputc(sep,f);
fprintf(f, "%g", el->depthMin);
fputc(sep,f);
fprintf(f, "%g", el->depthMean);
fputc(sep,f);
fprintf(f, "%g", el->depthMax);
fputc(sep,f);
fprintf(f, "%g", el->depthStd);
fputc(lastSep,f);
}


char *cdwQaFailCommaSepFieldNames = "id,fileId,qaVersion,reason";

void cdwQaFailStaticLoad(char **row, struct cdwQaFail *ret)
/* Load a row from cdwQaFail table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaVersion = sqlUnsigned(row[2]);
ret->reason = row[3];
}

struct cdwQaFail *cdwQaFailLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaFail from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaFailFreeList(). */
{
struct cdwQaFail *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaFailLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaFailSaveToDb(struct sqlConnection *conn, struct cdwQaFail *el, char *tableName, int updateSize)
/* Save cdwQaFail as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,'%s')", 
	tableName,  el->id,  el->fileId,  el->qaVersion,  el->reason);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaFail *cdwQaFailLoad(char **row)
/* Load a cdwQaFail from row fetched with select * from cdwQaFail
 * from database.  Dispose of this with cdwQaFailFree(). */
{
struct cdwQaFail *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaVersion = sqlUnsigned(row[2]);
ret->reason = cloneString(row[3]);
return ret;
}

struct cdwQaFail *cdwQaFailLoadAll(char *fileName) 
/* Load all cdwQaFail from a whitespace-separated file.
 * Dispose of this with cdwQaFailFreeList(). */
{
struct cdwQaFail *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = cdwQaFailLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaFail *cdwQaFailLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaFail from a chopper separated file.
 * Dispose of this with cdwQaFailFreeList(). */
{
struct cdwQaFail *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaFailLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaFail *cdwQaFailCommaIn(char **pS, struct cdwQaFail *ret)
/* Create a cdwQaFail out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaFail */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaVersion = sqlUnsignedComma(&s);
ret->reason = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwQaFailFree(struct cdwQaFail **pEl)
/* Free a single dynamically allocated cdwQaFail such as created
 * with cdwQaFailLoad(). */
{
struct cdwQaFail *el;

if ((el = *pEl) == NULL) return;
freeMem(el->reason);
freez(pEl);
}

void cdwQaFailFreeList(struct cdwQaFail **pList)
/* Free a list of dynamically allocated cdwQaFail's */
{
struct cdwQaFail *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaFailFree(&el);
    }
*pList = NULL;
}

void cdwQaFailOutput(struct cdwQaFail *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaFail.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaVersion);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->reason);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwQaEnrichTargetCommaSepFieldNames = "id,assemblyId,name,fileId,targetSize";

void cdwQaEnrichTargetStaticLoad(char **row, struct cdwQaEnrichTarget *ret)
/* Load a row from cdwQaEnrichTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
ret->name = row[2];
ret->fileId = sqlUnsigned(row[3]);
ret->targetSize = sqlLongLong(row[4]);
}

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaEnrichTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */
{
struct cdwQaEnrichTarget *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaEnrichTargetSaveToDb(struct sqlConnection *conn, struct cdwQaEnrichTarget *el, char *tableName, int updateSize)
/* Save cdwQaEnrichTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%u,%lld)", 
	tableName,  el->id,  el->assemblyId,  el->name,  el->fileId,  el->targetSize);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoad(char **row)
/* Load a cdwQaEnrichTarget from row fetched with select * from cdwQaEnrichTarget
 * from database.  Dispose of this with cdwQaEnrichTargetFree(). */
{
struct cdwQaEnrichTarget *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
ret->name = cloneString(row[2]);
ret->fileId = sqlUnsigned(row[3]);
ret->targetSize = sqlLongLong(row[4]);
return ret;
}

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadAll(char *fileName) 
/* Load all cdwQaEnrichTarget from a whitespace-separated file.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */
{
struct cdwQaEnrichTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cdwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaEnrichTarget from a chopper separated file.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */
{
struct cdwQaEnrichTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaEnrichTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaEnrichTarget *cdwQaEnrichTargetCommaIn(char **pS, struct cdwQaEnrichTarget *ret)
/* Create a cdwQaEnrichTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaEnrichTarget */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->assemblyId = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->targetSize = sqlLongLongComma(&s);
*pS = s;
return ret;
}

void cdwQaEnrichTargetFree(struct cdwQaEnrichTarget **pEl)
/* Free a single dynamically allocated cdwQaEnrichTarget such as created
 * with cdwQaEnrichTargetLoad(). */
{
struct cdwQaEnrichTarget *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freez(pEl);
}

void cdwQaEnrichTargetFreeList(struct cdwQaEnrichTarget **pList)
/* Free a list of dynamically allocated cdwQaEnrichTarget's */
{
struct cdwQaEnrichTarget *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaEnrichTargetFree(&el);
    }
*pList = NULL;
}

void cdwQaEnrichTargetOutput(struct cdwQaEnrichTarget *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaEnrichTarget.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->assemblyId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%lld", el->targetSize);
fputc(lastSep,f);
}


char *cdwQaEnrichCommaSepFieldNames = "id,fileId,qaEnrichTargetId,targetBaseHits,targetUniqHits,coverage,enrichment,uniqEnrich";

void cdwQaEnrichStaticLoad(char **row, struct cdwQaEnrich *ret)
/* Load a row from cdwQaEnrich table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaEnrichTargetId = sqlUnsigned(row[2]);
ret->targetBaseHits = sqlLongLong(row[3]);
ret->targetUniqHits = sqlLongLong(row[4]);
ret->coverage = sqlDouble(row[5]);
ret->enrichment = sqlDouble(row[6]);
ret->uniqEnrich = sqlDouble(row[7]);
}

struct cdwQaEnrich *cdwQaEnrichLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaEnrich from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaEnrichFreeList(). */
{
struct cdwQaEnrich *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaEnrichSaveToDb(struct sqlConnection *conn, struct cdwQaEnrich *el, char *tableName, int updateSize)
/* Save cdwQaEnrich as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%lld,%lld,%g,%g,%g)", 
	tableName,  el->id,  el->fileId,  el->qaEnrichTargetId,  el->targetBaseHits,  el->targetUniqHits,  el->coverage,  el->enrichment,  el->uniqEnrich);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaEnrich *cdwQaEnrichLoad(char **row)
/* Load a cdwQaEnrich from row fetched with select * from cdwQaEnrich
 * from database.  Dispose of this with cdwQaEnrichFree(). */
{
struct cdwQaEnrich *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaEnrichTargetId = sqlUnsigned(row[2]);
ret->targetBaseHits = sqlLongLong(row[3]);
ret->targetUniqHits = sqlLongLong(row[4]);
ret->coverage = sqlDouble(row[5]);
ret->enrichment = sqlDouble(row[6]);
ret->uniqEnrich = sqlDouble(row[7]);
return ret;
}

struct cdwQaEnrich *cdwQaEnrichLoadAll(char *fileName) 
/* Load all cdwQaEnrich from a whitespace-separated file.
 * Dispose of this with cdwQaEnrichFreeList(). */
{
struct cdwQaEnrich *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = cdwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaEnrich *cdwQaEnrichLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaEnrich from a chopper separated file.
 * Dispose of this with cdwQaEnrichFreeList(). */
{
struct cdwQaEnrich *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaEnrichLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaEnrich *cdwQaEnrichCommaIn(char **pS, struct cdwQaEnrich *ret)
/* Create a cdwQaEnrich out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaEnrich */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaEnrichTargetId = sqlUnsignedComma(&s);
ret->targetBaseHits = sqlLongLongComma(&s);
ret->targetUniqHits = sqlLongLongComma(&s);
ret->coverage = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->uniqEnrich = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaEnrichFree(struct cdwQaEnrich **pEl)
/* Free a single dynamically allocated cdwQaEnrich such as created
 * with cdwQaEnrichLoad(). */
{
struct cdwQaEnrich *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaEnrichFreeList(struct cdwQaEnrich **pList)
/* Free a list of dynamically allocated cdwQaEnrich's */
{
struct cdwQaEnrich *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaEnrichFree(&el);
    }
*pList = NULL;
}

void cdwQaEnrichOutput(struct cdwQaEnrich *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaEnrich.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaEnrichTargetId);
fputc(sep,f);
fprintf(f, "%lld", el->targetBaseHits);
fputc(sep,f);
fprintf(f, "%lld", el->targetUniqHits);
fputc(sep,f);
fprintf(f, "%g", el->coverage);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%g", el->uniqEnrich);
fputc(lastSep,f);
}


char *cdwQaContamTargetCommaSepFieldNames = "id,assemblyId";

void cdwQaContamTargetStaticLoad(char **row, struct cdwQaContamTarget *ret)
/* Load a row from cdwQaContamTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
}

struct cdwQaContamTarget *cdwQaContamTargetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaContamTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaContamTargetFreeList(). */
{
struct cdwQaContamTarget *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaContamTargetSaveToDb(struct sqlConnection *conn, struct cdwQaContamTarget *el, char *tableName, int updateSize)
/* Save cdwQaContamTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u)", 
	tableName,  el->id,  el->assemblyId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaContamTarget *cdwQaContamTargetLoad(char **row)
/* Load a cdwQaContamTarget from row fetched with select * from cdwQaContamTarget
 * from database.  Dispose of this with cdwQaContamTargetFree(). */
{
struct cdwQaContamTarget *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->assemblyId = sqlUnsigned(row[1]);
return ret;
}

struct cdwQaContamTarget *cdwQaContamTargetLoadAll(char *fileName) 
/* Load all cdwQaContamTarget from a whitespace-separated file.
 * Dispose of this with cdwQaContamTargetFreeList(). */
{
struct cdwQaContamTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = cdwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaContamTarget *cdwQaContamTargetLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaContamTarget from a chopper separated file.
 * Dispose of this with cdwQaContamTargetFreeList(). */
{
struct cdwQaContamTarget *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaContamTargetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaContamTarget *cdwQaContamTargetCommaIn(char **pS, struct cdwQaContamTarget *ret)
/* Create a cdwQaContamTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaContamTarget */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->assemblyId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void cdwQaContamTargetFree(struct cdwQaContamTarget **pEl)
/* Free a single dynamically allocated cdwQaContamTarget such as created
 * with cdwQaContamTargetLoad(). */
{
struct cdwQaContamTarget *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaContamTargetFreeList(struct cdwQaContamTarget **pList)
/* Free a list of dynamically allocated cdwQaContamTarget's */
{
struct cdwQaContamTarget *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaContamTargetFree(&el);
    }
*pList = NULL;
}

void cdwQaContamTargetOutput(struct cdwQaContamTarget *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaContamTarget.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->assemblyId);
fputc(lastSep,f);
}


char *cdwQaContamCommaSepFieldNames = "id,fileId,qaContamTargetId,mapRatio";

void cdwQaContamStaticLoad(char **row, struct cdwQaContam *ret)
/* Load a row from cdwQaContam table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaContamTargetId = sqlUnsigned(row[2]);
ret->mapRatio = sqlDouble(row[3]);
}

struct cdwQaContam *cdwQaContamLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaContam from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaContamFreeList(). */
{
struct cdwQaContam *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaContamLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaContamSaveToDb(struct sqlConnection *conn, struct cdwQaContam *el, char *tableName, int updateSize)
/* Save cdwQaContam as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g)", 
	tableName,  el->id,  el->fileId,  el->qaContamTargetId,  el->mapRatio);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaContam *cdwQaContamLoad(char **row)
/* Load a cdwQaContam from row fetched with select * from cdwQaContam
 * from database.  Dispose of this with cdwQaContamFree(). */
{
struct cdwQaContam *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->qaContamTargetId = sqlUnsigned(row[2]);
ret->mapRatio = sqlDouble(row[3]);
return ret;
}

struct cdwQaContam *cdwQaContamLoadAll(char *fileName) 
/* Load all cdwQaContam from a whitespace-separated file.
 * Dispose of this with cdwQaContamFreeList(). */
{
struct cdwQaContam *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = cdwQaContamLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaContam *cdwQaContamLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaContam from a chopper separated file.
 * Dispose of this with cdwQaContamFreeList(). */
{
struct cdwQaContam *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaContamLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaContam *cdwQaContamCommaIn(char **pS, struct cdwQaContam *ret)
/* Create a cdwQaContam out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaContam */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->qaContamTargetId = sqlUnsignedComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaContamFree(struct cdwQaContam **pEl)
/* Free a single dynamically allocated cdwQaContam such as created
 * with cdwQaContamLoad(). */
{
struct cdwQaContam *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaContamFreeList(struct cdwQaContam **pList)
/* Free a list of dynamically allocated cdwQaContam's */
{
struct cdwQaContam *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaContamFree(&el);
    }
*pList = NULL;
}

void cdwQaContamOutput(struct cdwQaContam *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaContam.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->qaContamTargetId);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(lastSep,f);
}


char *cdwQaRepeatCommaSepFieldNames = "id,fileId,repeatClass,mapRatio";

void cdwQaRepeatStaticLoad(char **row, struct cdwQaRepeat *ret)
/* Load a row from cdwQaRepeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->repeatClass = row[2];
ret->mapRatio = sqlDouble(row[3]);
}

struct cdwQaRepeat *cdwQaRepeatLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaRepeat from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaRepeatFreeList(). */
{
struct cdwQaRepeat *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaRepeatSaveToDb(struct sqlConnection *conn, struct cdwQaRepeat *el, char *tableName, int updateSize)
/* Save cdwQaRepeat as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s',%g)", 
	tableName,  el->id,  el->fileId,  el->repeatClass,  el->mapRatio);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaRepeat *cdwQaRepeatLoad(char **row)
/* Load a cdwQaRepeat from row fetched with select * from cdwQaRepeat
 * from database.  Dispose of this with cdwQaRepeatFree(). */
{
struct cdwQaRepeat *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->repeatClass = cloneString(row[2]);
ret->mapRatio = sqlDouble(row[3]);
return ret;
}

struct cdwQaRepeat *cdwQaRepeatLoadAll(char *fileName) 
/* Load all cdwQaRepeat from a whitespace-separated file.
 * Dispose of this with cdwQaRepeatFreeList(). */
{
struct cdwQaRepeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = cdwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaRepeat *cdwQaRepeatLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaRepeat from a chopper separated file.
 * Dispose of this with cdwQaRepeatFreeList(). */
{
struct cdwQaRepeat *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaRepeatLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaRepeat *cdwQaRepeatCommaIn(char **pS, struct cdwQaRepeat *ret)
/* Create a cdwQaRepeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaRepeat */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->repeatClass = sqlStringComma(&s);
ret->mapRatio = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaRepeatFree(struct cdwQaRepeat **pEl)
/* Free a single dynamically allocated cdwQaRepeat such as created
 * with cdwQaRepeatLoad(). */
{
struct cdwQaRepeat *el;

if ((el = *pEl) == NULL) return;
freeMem(el->repeatClass);
freez(pEl);
}

void cdwQaRepeatFreeList(struct cdwQaRepeat **pList)
/* Free a list of dynamically allocated cdwQaRepeat's */
{
struct cdwQaRepeat *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaRepeatFree(&el);
    }
*pList = NULL;
}

void cdwQaRepeatOutput(struct cdwQaRepeat *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaRepeat.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->repeatClass);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%g", el->mapRatio);
fputc(lastSep,f);
}


char *cdwQaPairSampleOverlapCommaSepFieldNames = "id,elderFileId,youngerFileId,elderSampleBases,youngerSampleBases,sampleOverlapBases,sampleSampleEnrichment";

void cdwQaPairSampleOverlapStaticLoad(char **row, struct cdwQaPairSampleOverlap *ret)
/* Load a row from cdwQaPairSampleOverlap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->elderSampleBases = sqlLongLong(row[3]);
ret->youngerSampleBases = sqlLongLong(row[4]);
ret->sampleOverlapBases = sqlLongLong(row[5]);
ret->sampleSampleEnrichment = sqlDouble(row[6]);
}

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaPairSampleOverlap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */
{
struct cdwQaPairSampleOverlap *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaPairSampleOverlapSaveToDb(struct sqlConnection *conn, struct cdwQaPairSampleOverlap *el, char *tableName, int updateSize)
/* Save cdwQaPairSampleOverlap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%lld,%lld,%lld,%g)", 
	tableName,  el->id,  el->elderFileId,  el->youngerFileId,  el->elderSampleBases,  el->youngerSampleBases,  el->sampleOverlapBases,  el->sampleSampleEnrichment);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoad(char **row)
/* Load a cdwQaPairSampleOverlap from row fetched with select * from cdwQaPairSampleOverlap
 * from database.  Dispose of this with cdwQaPairSampleOverlapFree(). */
{
struct cdwQaPairSampleOverlap *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->elderSampleBases = sqlLongLong(row[3]);
ret->youngerSampleBases = sqlLongLong(row[4]);
ret->sampleOverlapBases = sqlLongLong(row[5]);
ret->sampleSampleEnrichment = sqlDouble(row[6]);
return ret;
}

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadAll(char *fileName) 
/* Load all cdwQaPairSampleOverlap from a whitespace-separated file.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */
{
struct cdwQaPairSampleOverlap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = cdwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaPairSampleOverlap from a chopper separated file.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */
{
struct cdwQaPairSampleOverlap *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaPairSampleOverlapLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapCommaIn(char **pS, struct cdwQaPairSampleOverlap *ret)
/* Create a cdwQaPairSampleOverlap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairSampleOverlap */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->elderFileId = sqlUnsignedComma(&s);
ret->youngerFileId = sqlUnsignedComma(&s);
ret->elderSampleBases = sqlLongLongComma(&s);
ret->youngerSampleBases = sqlLongLongComma(&s);
ret->sampleOverlapBases = sqlLongLongComma(&s);
ret->sampleSampleEnrichment = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaPairSampleOverlapFree(struct cdwQaPairSampleOverlap **pEl)
/* Free a single dynamically allocated cdwQaPairSampleOverlap such as created
 * with cdwQaPairSampleOverlapLoad(). */
{
struct cdwQaPairSampleOverlap *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaPairSampleOverlapFreeList(struct cdwQaPairSampleOverlap **pList)
/* Free a list of dynamically allocated cdwQaPairSampleOverlap's */
{
struct cdwQaPairSampleOverlap *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaPairSampleOverlapFree(&el);
    }
*pList = NULL;
}

void cdwQaPairSampleOverlapOutput(struct cdwQaPairSampleOverlap *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaPairSampleOverlap.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->elderFileId);
fputc(sep,f);
fprintf(f, "%u", el->youngerFileId);
fputc(sep,f);
fprintf(f, "%lld", el->elderSampleBases);
fputc(sep,f);
fprintf(f, "%lld", el->youngerSampleBases);
fputc(sep,f);
fprintf(f, "%lld", el->sampleOverlapBases);
fputc(sep,f);
fprintf(f, "%g", el->sampleSampleEnrichment);
fputc(lastSep,f);
}


char *cdwQaPairCorrelationCommaSepFieldNames = "id,elderFileId,youngerFileId,pearsonInEnriched,pearsonOverall,pearsonClipped";

void cdwQaPairCorrelationStaticLoad(char **row, struct cdwQaPairCorrelation *ret)
/* Load a row from cdwQaPairCorrelation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->pearsonInEnriched = sqlDouble(row[3]);
ret->pearsonOverall = sqlDouble(row[4]);
ret->pearsonClipped = sqlDouble(row[5]);
}

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaPairCorrelation from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */
{
struct cdwQaPairCorrelation *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaPairCorrelationSaveToDb(struct sqlConnection *conn, struct cdwQaPairCorrelation *el, char *tableName, int updateSize)
/* Save cdwQaPairCorrelation as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%g)", 
	tableName,  el->id,  el->elderFileId,  el->youngerFileId,  el->pearsonInEnriched,  el->pearsonOverall,  el->pearsonClipped);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoad(char **row)
/* Load a cdwQaPairCorrelation from row fetched with select * from cdwQaPairCorrelation
 * from database.  Dispose of this with cdwQaPairCorrelationFree(). */
{
struct cdwQaPairCorrelation *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->elderFileId = sqlUnsigned(row[1]);
ret->youngerFileId = sqlUnsigned(row[2]);
ret->pearsonInEnriched = sqlDouble(row[3]);
ret->pearsonOverall = sqlDouble(row[4]);
ret->pearsonClipped = sqlDouble(row[5]);
return ret;
}

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadAll(char *fileName) 
/* Load all cdwQaPairCorrelation from a whitespace-separated file.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */
{
struct cdwQaPairCorrelation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cdwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaPairCorrelation from a chopper separated file.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */
{
struct cdwQaPairCorrelation *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaPairCorrelationLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairCorrelation *cdwQaPairCorrelationCommaIn(char **pS, struct cdwQaPairCorrelation *ret)
/* Create a cdwQaPairCorrelation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairCorrelation */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->elderFileId = sqlUnsignedComma(&s);
ret->youngerFileId = sqlUnsignedComma(&s);
ret->pearsonInEnriched = sqlDoubleComma(&s);
ret->pearsonOverall = sqlDoubleComma(&s);
ret->pearsonClipped = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaPairCorrelationFree(struct cdwQaPairCorrelation **pEl)
/* Free a single dynamically allocated cdwQaPairCorrelation such as created
 * with cdwQaPairCorrelationLoad(). */
{
struct cdwQaPairCorrelation *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaPairCorrelationFreeList(struct cdwQaPairCorrelation **pList)
/* Free a list of dynamically allocated cdwQaPairCorrelation's */
{
struct cdwQaPairCorrelation *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaPairCorrelationFree(&el);
    }
*pList = NULL;
}

void cdwQaPairCorrelationOutput(struct cdwQaPairCorrelation *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaPairCorrelation.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->elderFileId);
fputc(sep,f);
fprintf(f, "%u", el->youngerFileId);
fputc(sep,f);
fprintf(f, "%g", el->pearsonInEnriched);
fputc(sep,f);
fprintf(f, "%g", el->pearsonOverall);
fputc(sep,f);
fprintf(f, "%g", el->pearsonClipped);
fputc(lastSep,f);
}


char *cdwQaPairedEndFastqCommaSepFieldNames = "id,fileId1,fileId2,concordance,distanceMean,distanceStd,distanceMin,distanceMax,recordComplete";

void cdwQaPairedEndFastqStaticLoad(char **row, struct cdwQaPairedEndFastq *ret)
/* Load a row from cdwQaPairedEndFastq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId1 = sqlUnsigned(row[1]);
ret->fileId2 = sqlUnsigned(row[2]);
ret->concordance = sqlDouble(row[3]);
ret->distanceMean = sqlDouble(row[4]);
ret->distanceStd = sqlDouble(row[5]);
ret->distanceMin = sqlDouble(row[6]);
ret->distanceMax = sqlDouble(row[7]);
ret->recordComplete = sqlSigned(row[8]);
}

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaPairedEndFastq from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */
{
struct cdwQaPairedEndFastq *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaPairedEndFastqSaveToDb(struct sqlConnection *conn, struct cdwQaPairedEndFastq *el, char *tableName, int updateSize)
/* Save cdwQaPairedEndFastq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%g,%g,%g,%d)", 
	tableName,  el->id,  el->fileId1,  el->fileId2,  el->concordance,  el->distanceMean,  el->distanceStd,  el->distanceMin,  el->distanceMax,  el->recordComplete);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoad(char **row)
/* Load a cdwQaPairedEndFastq from row fetched with select * from cdwQaPairedEndFastq
 * from database.  Dispose of this with cdwQaPairedEndFastqFree(). */
{
struct cdwQaPairedEndFastq *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId1 = sqlUnsigned(row[1]);
ret->fileId2 = sqlUnsigned(row[2]);
ret->concordance = sqlDouble(row[3]);
ret->distanceMean = sqlDouble(row[4]);
ret->distanceStd = sqlDouble(row[5]);
ret->distanceMin = sqlDouble(row[6]);
ret->distanceMax = sqlDouble(row[7]);
ret->recordComplete = sqlSigned(row[8]);
return ret;
}

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadAll(char *fileName) 
/* Load all cdwQaPairedEndFastq from a whitespace-separated file.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */
{
struct cdwQaPairedEndFastq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = cdwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaPairedEndFastq from a chopper separated file.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */
{
struct cdwQaPairedEndFastq *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaPairedEndFastqLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqCommaIn(char **pS, struct cdwQaPairedEndFastq *ret)
/* Create a cdwQaPairedEndFastq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairedEndFastq */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId1 = sqlUnsignedComma(&s);
ret->fileId2 = sqlUnsignedComma(&s);
ret->concordance = sqlDoubleComma(&s);
ret->distanceMean = sqlDoubleComma(&s);
ret->distanceStd = sqlDoubleComma(&s);
ret->distanceMin = sqlDoubleComma(&s);
ret->distanceMax = sqlDoubleComma(&s);
ret->recordComplete = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwQaPairedEndFastqFree(struct cdwQaPairedEndFastq **pEl)
/* Free a single dynamically allocated cdwQaPairedEndFastq such as created
 * with cdwQaPairedEndFastqLoad(). */
{
struct cdwQaPairedEndFastq *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaPairedEndFastqFreeList(struct cdwQaPairedEndFastq **pList)
/* Free a list of dynamically allocated cdwQaPairedEndFastq's */
{
struct cdwQaPairedEndFastq *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaPairedEndFastqFree(&el);
    }
*pList = NULL;
}

void cdwQaPairedEndFastqOutput(struct cdwQaPairedEndFastq *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaPairedEndFastq.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId1);
fputc(sep,f);
fprintf(f, "%u", el->fileId2);
fputc(sep,f);
fprintf(f, "%g", el->concordance);
fputc(sep,f);
fprintf(f, "%g", el->distanceMean);
fputc(sep,f);
fprintf(f, "%g", el->distanceStd);
fputc(sep,f);
fprintf(f, "%g", el->distanceMin);
fputc(sep,f);
fprintf(f, "%g", el->distanceMax);
fputc(sep,f);
fprintf(f, "%d", el->recordComplete);
fputc(lastSep,f);
}


char *cdwQaWigSpotCommaSepFieldNames = "id,wigId,spotId,spotRatio,enrichment,basesInGenome,basesInSpots,sumSignal,spotSumSignal";

void cdwQaWigSpotStaticLoad(char **row, struct cdwQaWigSpot *ret)
/* Load a row from cdwQaWigSpot table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->wigId = sqlUnsigned(row[1]);
ret->spotId = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
}

struct cdwQaWigSpot *cdwQaWigSpotLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaWigSpot from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaWigSpotFreeList(). */
{
struct cdwQaWigSpot *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaWigSpotSaveToDb(struct sqlConnection *conn, struct cdwQaWigSpot *el, char *tableName, int updateSize)
/* Save cdwQaWigSpot as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%lld,%lld,%g,%g)", 
	tableName,  el->id,  el->wigId,  el->spotId,  el->spotRatio,  el->enrichment,  el->basesInGenome,  el->basesInSpots,  el->sumSignal,  el->spotSumSignal);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaWigSpot *cdwQaWigSpotLoad(char **row)
/* Load a cdwQaWigSpot from row fetched with select * from cdwQaWigSpot
 * from database.  Dispose of this with cdwQaWigSpotFree(). */
{
struct cdwQaWigSpot *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->wigId = sqlUnsigned(row[1]);
ret->spotId = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
return ret;
}

struct cdwQaWigSpot *cdwQaWigSpotLoadAll(char *fileName) 
/* Load all cdwQaWigSpot from a whitespace-separated file.
 * Dispose of this with cdwQaWigSpotFreeList(). */
{
struct cdwQaWigSpot *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = cdwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaWigSpot *cdwQaWigSpotLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaWigSpot from a chopper separated file.
 * Dispose of this with cdwQaWigSpotFreeList(). */
{
struct cdwQaWigSpot *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaWigSpotLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaWigSpot *cdwQaWigSpotCommaIn(char **pS, struct cdwQaWigSpot *ret)
/* Create a cdwQaWigSpot out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaWigSpot */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->wigId = sqlUnsignedComma(&s);
ret->spotId = sqlUnsignedComma(&s);
ret->spotRatio = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->basesInGenome = sqlLongLongComma(&s);
ret->basesInSpots = sqlLongLongComma(&s);
ret->sumSignal = sqlDoubleComma(&s);
ret->spotSumSignal = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void cdwQaWigSpotFree(struct cdwQaWigSpot **pEl)
/* Free a single dynamically allocated cdwQaWigSpot such as created
 * with cdwQaWigSpotLoad(). */
{
struct cdwQaWigSpot *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void cdwQaWigSpotFreeList(struct cdwQaWigSpot **pList)
/* Free a list of dynamically allocated cdwQaWigSpot's */
{
struct cdwQaWigSpot *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaWigSpotFree(&el);
    }
*pList = NULL;
}

void cdwQaWigSpotOutput(struct cdwQaWigSpot *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaWigSpot.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->wigId);
fputc(sep,f);
fprintf(f, "%u", el->spotId);
fputc(sep,f);
fprintf(f, "%g", el->spotRatio);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%lld", el->basesInGenome);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSpots);
fputc(sep,f);
fprintf(f, "%g", el->sumSignal);
fputc(sep,f);
fprintf(f, "%g", el->spotSumSignal);
fputc(lastSep,f);
}


char *cdwQaDnaseSingleStats5mCommaSepFieldNames = "id,fileId,sampleReads,spotRatio,enrichment,basesInGenome,basesInSpots,sumSignal,spotSumSignal,estFragLength,corrEstFragLen,phantomPeak,corrPhantomPeak,argMinCorr,minCorr,nsc,rsc,rscQualityTag";

void cdwQaDnaseSingleStats5mStaticLoad(char **row, struct cdwQaDnaseSingleStats5m *ret)
/* Load a row from cdwQaDnaseSingleStats5m table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleReads = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
ret->estFragLength = row[9];
ret->corrEstFragLen = row[10];
ret->phantomPeak = sqlSigned(row[11]);
ret->corrPhantomPeak = sqlDouble(row[12]);
ret->argMinCorr = sqlSigned(row[13]);
ret->minCorr = sqlDouble(row[14]);
ret->nsc = sqlDouble(row[15]);
ret->rsc = sqlDouble(row[16]);
ret->rscQualityTag = sqlSigned(row[17]);
}

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwQaDnaseSingleStats5m from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */
{
struct cdwQaDnaseSingleStats5m *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwQaDnaseSingleStats5mSaveToDb(struct sqlConnection *conn, struct cdwQaDnaseSingleStats5m *el, char *tableName, int updateSize)
/* Save cdwQaDnaseSingleStats5m as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,%u,%g,%g,%lld,%lld,%g,%g,'%s','%s',%d,%g,%d,%g,%g,%g,%d)", 
	tableName,  el->id,  el->fileId,  el->sampleReads,  el->spotRatio,  el->enrichment,  el->basesInGenome,  el->basesInSpots,  el->sumSignal,  el->spotSumSignal,  el->estFragLength,  el->corrEstFragLen,  el->phantomPeak,  el->corrPhantomPeak,  el->argMinCorr,  el->minCorr,  el->nsc,  el->rsc,  el->rscQualityTag);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoad(char **row)
/* Load a cdwQaDnaseSingleStats5m from row fetched with select * from cdwQaDnaseSingleStats5m
 * from database.  Dispose of this with cdwQaDnaseSingleStats5mFree(). */
{
struct cdwQaDnaseSingleStats5m *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->sampleReads = sqlUnsigned(row[2]);
ret->spotRatio = sqlDouble(row[3]);
ret->enrichment = sqlDouble(row[4]);
ret->basesInGenome = sqlLongLong(row[5]);
ret->basesInSpots = sqlLongLong(row[6]);
ret->sumSignal = sqlDouble(row[7]);
ret->spotSumSignal = sqlDouble(row[8]);
ret->estFragLength = cloneString(row[9]);
ret->corrEstFragLen = cloneString(row[10]);
ret->phantomPeak = sqlSigned(row[11]);
ret->corrPhantomPeak = sqlDouble(row[12]);
ret->argMinCorr = sqlSigned(row[13]);
ret->minCorr = sqlDouble(row[14]);
ret->nsc = sqlDouble(row[15]);
ret->rsc = sqlDouble(row[16]);
ret->rscQualityTag = sqlSigned(row[17]);
return ret;
}

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadAll(char *fileName) 
/* Load all cdwQaDnaseSingleStats5m from a whitespace-separated file.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */
{
struct cdwQaDnaseSingleStats5m *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileRow(lf, row))
    {
    el = cdwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwQaDnaseSingleStats5m from a chopper separated file.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */
{
struct cdwQaDnaseSingleStats5m *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[18];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwQaDnaseSingleStats5mLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mCommaIn(char **pS, struct cdwQaDnaseSingleStats5m *ret)
/* Create a cdwQaDnaseSingleStats5m out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaDnaseSingleStats5m */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->sampleReads = sqlUnsignedComma(&s);
ret->spotRatio = sqlDoubleComma(&s);
ret->enrichment = sqlDoubleComma(&s);
ret->basesInGenome = sqlLongLongComma(&s);
ret->basesInSpots = sqlLongLongComma(&s);
ret->sumSignal = sqlDoubleComma(&s);
ret->spotSumSignal = sqlDoubleComma(&s);
ret->estFragLength = sqlStringComma(&s);
ret->corrEstFragLen = sqlStringComma(&s);
ret->phantomPeak = sqlSignedComma(&s);
ret->corrPhantomPeak = sqlDoubleComma(&s);
ret->argMinCorr = sqlSignedComma(&s);
ret->minCorr = sqlDoubleComma(&s);
ret->nsc = sqlDoubleComma(&s);
ret->rsc = sqlDoubleComma(&s);
ret->rscQualityTag = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwQaDnaseSingleStats5mFree(struct cdwQaDnaseSingleStats5m **pEl)
/* Free a single dynamically allocated cdwQaDnaseSingleStats5m such as created
 * with cdwQaDnaseSingleStats5mLoad(). */
{
struct cdwQaDnaseSingleStats5m *el;

if ((el = *pEl) == NULL) return;
freeMem(el->estFragLength);
freeMem(el->corrEstFragLen);
freez(pEl);
}

void cdwQaDnaseSingleStats5mFreeList(struct cdwQaDnaseSingleStats5m **pList)
/* Free a list of dynamically allocated cdwQaDnaseSingleStats5m's */
{
struct cdwQaDnaseSingleStats5m *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwQaDnaseSingleStats5mFree(&el);
    }
*pList = NULL;
}

void cdwQaDnaseSingleStats5mOutput(struct cdwQaDnaseSingleStats5m *el, FILE *f, char sep, char lastSep) 
/* Print out cdwQaDnaseSingleStats5m.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
fprintf(f, "%u", el->sampleReads);
fputc(sep,f);
fprintf(f, "%g", el->spotRatio);
fputc(sep,f);
fprintf(f, "%g", el->enrichment);
fputc(sep,f);
fprintf(f, "%lld", el->basesInGenome);
fputc(sep,f);
fprintf(f, "%lld", el->basesInSpots);
fputc(sep,f);
fprintf(f, "%g", el->sumSignal);
fputc(sep,f);
fprintf(f, "%g", el->spotSumSignal);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->estFragLength);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->corrEstFragLen);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->phantomPeak);
fputc(sep,f);
fprintf(f, "%g", el->corrPhantomPeak);
fputc(sep,f);
fprintf(f, "%d", el->argMinCorr);
fputc(sep,f);
fprintf(f, "%g", el->minCorr);
fputc(sep,f);
fprintf(f, "%g", el->nsc);
fputc(sep,f);
fprintf(f, "%g", el->rsc);
fputc(sep,f);
fprintf(f, "%d", el->rscQualityTag);
fputc(lastSep,f);
}


char *cdwJobCommaSepFieldNames = "id,commandLine,startTime,endTime,stderr,returnCode,pid,submitId";

void cdwJobStaticLoad(char **row, struct cdwJob *ret)
/* Load a row from cdwJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->commandLine = row[1];
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = row[4];
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
ret->submitId = sqlSigned(row[7]);
}

struct cdwJob *cdwJobLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwJobFreeList(). */
{
struct cdwJob *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwJobLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwJobSaveToDb(struct sqlConnection *conn, struct cdwJob *el, char *tableName, int updateSize)
/* Save cdwJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s',%lld,%lld,'%s',%d,%d,%d)", 
	tableName,  el->id,  el->commandLine,  el->startTime,  el->endTime,  el->stderr,  el->returnCode,  el->pid,  el->submitId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwJob *cdwJobLoad(char **row)
/* Load a cdwJob from row fetched with select * from cdwJob
 * from database.  Dispose of this with cdwJobFree(). */
{
struct cdwJob *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->commandLine = cloneString(row[1]);
ret->startTime = sqlLongLong(row[2]);
ret->endTime = sqlLongLong(row[3]);
ret->stderr = cloneString(row[4]);
ret->returnCode = sqlSigned(row[5]);
ret->pid = sqlSigned(row[6]);
ret->submitId = sqlSigned(row[7]);
return ret;
}

struct cdwJob *cdwJobLoadAll(char *fileName) 
/* Load all cdwJob from a whitespace-separated file.
 * Dispose of this with cdwJobFreeList(). */
{
struct cdwJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = cdwJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwJob *cdwJobLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwJob from a chopper separated file.
 * Dispose of this with cdwJobFreeList(). */
{
struct cdwJob *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwJobLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwJob *cdwJobCommaIn(char **pS, struct cdwJob *ret)
/* Create a cdwJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwJob */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->commandLine = sqlStringComma(&s);
ret->startTime = sqlLongLongComma(&s);
ret->endTime = sqlLongLongComma(&s);
ret->stderr = sqlStringComma(&s);
ret->returnCode = sqlSignedComma(&s);
ret->pid = sqlSignedComma(&s);
ret->submitId = sqlSignedComma(&s);
*pS = s;
return ret;
}

void cdwJobFree(struct cdwJob **pEl)
/* Free a single dynamically allocated cdwJob such as created
 * with cdwJobLoad(). */
{
struct cdwJob *el;

if ((el = *pEl) == NULL) return;
freeMem(el->commandLine);
freeMem(el->stderr);
freez(pEl);
}

void cdwJobFreeList(struct cdwJob **pList)
/* Free a list of dynamically allocated cdwJob's */
{
struct cdwJob *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwJobFree(&el);
    }
*pList = NULL;
}

void cdwJobOutput(struct cdwJob *el, FILE *f, char sep, char lastSep) 
/* Print out cdwJob.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->commandLine);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->startTime);
fputc(sep,f);
fprintf(f, "%lld", el->endTime);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->stderr);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->returnCode);
fputc(sep,f);
fprintf(f, "%d", el->pid);
fputc(sep,f);
fprintf(f, "%d", el->submitId);
fputc(lastSep,f);
}


char *cdwTrackVizCommaSepFieldNames = "id,fileId,shortLabel,longLabel,type,bigDataFile";

void cdwTrackVizStaticLoad(char **row, struct cdwTrackViz *ret)
/* Load a row from cdwTrackViz table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->shortLabel = row[2];
ret->longLabel = row[3];
ret->type = row[4];
ret->bigDataFile = row[5];
}

struct cdwTrackViz *cdwTrackVizLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwTrackViz from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwTrackVizFreeList(). */
{
struct cdwTrackViz *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwTrackVizLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwTrackVizSaveToDb(struct sqlConnection *conn, struct cdwTrackViz *el, char *tableName, int updateSize)
/* Save cdwTrackViz as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,%u,'%s','%s','%s','%s')", 
	tableName,  el->id,  el->fileId,  el->shortLabel,  el->longLabel,  el->type,  el->bigDataFile);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwTrackViz *cdwTrackVizLoad(char **row)
/* Load a cdwTrackViz from row fetched with select * from cdwTrackViz
 * from database.  Dispose of this with cdwTrackVizFree(). */
{
struct cdwTrackViz *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->fileId = sqlUnsigned(row[1]);
ret->shortLabel = cloneString(row[2]);
ret->longLabel = cloneString(row[3]);
ret->type = cloneString(row[4]);
ret->bigDataFile = cloneString(row[5]);
return ret;
}

struct cdwTrackViz *cdwTrackVizLoadAll(char *fileName) 
/* Load all cdwTrackViz from a whitespace-separated file.
 * Dispose of this with cdwTrackVizFreeList(). */
{
struct cdwTrackViz *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cdwTrackVizLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwTrackViz *cdwTrackVizLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwTrackViz from a chopper separated file.
 * Dispose of this with cdwTrackVizFreeList(). */
{
struct cdwTrackViz *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwTrackVizLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwTrackViz *cdwTrackVizCommaIn(char **pS, struct cdwTrackViz *ret)
/* Create a cdwTrackViz out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwTrackViz */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->fileId = sqlUnsignedComma(&s);
ret->shortLabel = sqlStringComma(&s);
ret->longLabel = sqlStringComma(&s);
ret->type = sqlStringComma(&s);
ret->bigDataFile = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwTrackVizFree(struct cdwTrackViz **pEl)
/* Free a single dynamically allocated cdwTrackViz such as created
 * with cdwTrackVizLoad(). */
{
struct cdwTrackViz *el;

if ((el = *pEl) == NULL) return;
freeMem(el->shortLabel);
freeMem(el->longLabel);
freeMem(el->type);
freeMem(el->bigDataFile);
freez(pEl);
}

void cdwTrackVizFreeList(struct cdwTrackViz **pList)
/* Free a list of dynamically allocated cdwTrackViz's */
{
struct cdwTrackViz *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwTrackVizFree(&el);
    }
*pList = NULL;
}

void cdwTrackVizOutput(struct cdwTrackViz *el, FILE *f, char sep, char lastSep) 
/* Print out cdwTrackViz.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
fprintf(f, "%u", el->fileId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->shortLabel);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->longLabel);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->type);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bigDataFile);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwDatasetCommaSepFieldNames = "id,name,label,description,pmid,pmcid,metaDivTags,metaLabelTags";

void cdwDatasetStaticLoad(char **row, struct cdwDataset *ret)
/* Load a row from cdwDataset table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->label = row[2];
ret->description = row[3];
ret->pmid = row[4];
ret->pmcid = row[5];
ret->metaDivTags = row[6];
ret->metaLabelTags = row[7];
}

struct cdwDataset *cdwDatasetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwDataset from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwDatasetFreeList(). */
{
struct cdwDataset *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwDatasetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwDatasetSaveToDb(struct sqlConnection *conn, struct cdwDataset *el, char *tableName, int updateSize)
/* Save cdwDataset as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->label,  el->description,  el->pmid,  el->pmcid,  el->metaDivTags,  el->metaLabelTags);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwDataset *cdwDatasetLoad(char **row)
/* Load a cdwDataset from row fetched with select * from cdwDataset
 * from database.  Dispose of this with cdwDatasetFree(). */
{
struct cdwDataset *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->label = cloneString(row[2]);
ret->description = cloneString(row[3]);
ret->pmid = cloneString(row[4]);
ret->pmcid = cloneString(row[5]);
ret->metaDivTags = cloneString(row[6]);
ret->metaLabelTags = cloneString(row[7]);
return ret;
}

struct cdwDataset *cdwDatasetLoadAll(char *fileName) 
/* Load all cdwDataset from a whitespace-separated file.
 * Dispose of this with cdwDatasetFreeList(). */
{
struct cdwDataset *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileRow(lf, row))
    {
    el = cdwDatasetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwDataset *cdwDatasetLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwDataset from a chopper separated file.
 * Dispose of this with cdwDatasetFreeList(). */
{
struct cdwDataset *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[8];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwDatasetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwDataset *cdwDatasetCommaIn(char **pS, struct cdwDataset *ret)
/* Create a cdwDataset out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwDataset */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->label = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->pmid = sqlStringComma(&s);
ret->pmcid = sqlStringComma(&s);
ret->metaDivTags = sqlStringComma(&s);
ret->metaLabelTags = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwDatasetFree(struct cdwDataset **pEl)
/* Free a single dynamically allocated cdwDataset such as created
 * with cdwDatasetLoad(). */
{
struct cdwDataset *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->label);
freeMem(el->description);
freeMem(el->pmid);
freeMem(el->pmcid);
freeMem(el->metaDivTags);
freeMem(el->metaLabelTags);
freez(pEl);
}

void cdwDatasetFreeList(struct cdwDataset **pList)
/* Free a list of dynamically allocated cdwDataset's */
{
struct cdwDataset *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwDatasetFree(&el);
    }
*pList = NULL;
}

void cdwDatasetOutput(struct cdwDataset *el, FILE *f, char sep, char lastSep) 
/* Print out cdwDataset.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->label);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pmid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pmcid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaDivTags);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaLabelTags);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *cdwJointDatasetCommaSepFieldNames = "id,name,label,description,childrenNames,metaDivTags";

void cdwJointDatasetStaticLoad(char **row, struct cdwJointDataset *ret)
/* Load a row from cdwJointDataset table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->id = sqlUnsigned(row[0]);
ret->name = row[1];
ret->label = row[2];
ret->description = row[3];
ret->childrenNames = row[4];
ret->metaDivTags = row[5];
}

struct cdwJointDataset *cdwJointDatasetLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all cdwJointDataset from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwJointDatasetFreeList(). */
{
struct cdwJointDataset *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = cdwJointDatasetLoad(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void cdwJointDatasetSaveToDb(struct sqlConnection *conn, struct cdwJointDataset *el, char *tableName, int updateSize)
/* Save cdwJointDataset as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( %u,'%s','%s','%s','%s','%s')", 
	tableName,  el->id,  el->name,  el->label,  el->description,  el->childrenNames,  el->metaDivTags);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct cdwJointDataset *cdwJointDatasetLoad(char **row)
/* Load a cdwJointDataset from row fetched with select * from cdwJointDataset
 * from database.  Dispose of this with cdwJointDatasetFree(). */
{
struct cdwJointDataset *ret;

AllocVar(ret);
ret->id = sqlUnsigned(row[0]);
ret->name = cloneString(row[1]);
ret->label = cloneString(row[2]);
ret->description = cloneString(row[3]);
ret->childrenNames = cloneString(row[4]);
ret->metaDivTags = cloneString(row[5]);
return ret;
}

struct cdwJointDataset *cdwJointDatasetLoadAll(char *fileName) 
/* Load all cdwJointDataset from a whitespace-separated file.
 * Dispose of this with cdwJointDatasetFreeList(). */
{
struct cdwJointDataset *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileRow(lf, row))
    {
    el = cdwJointDatasetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwJointDataset *cdwJointDatasetLoadAllByChar(char *fileName, char chopper) 
/* Load all cdwJointDataset from a chopper separated file.
 * Dispose of this with cdwJointDatasetFreeList(). */
{
struct cdwJointDataset *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[6];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cdwJointDatasetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cdwJointDataset *cdwJointDatasetCommaIn(char **pS, struct cdwJointDataset *ret)
/* Create a cdwJointDataset out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwJointDataset */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->id = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->label = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->childrenNames = sqlStringComma(&s);
ret->metaDivTags = sqlStringComma(&s);
*pS = s;
return ret;
}

void cdwJointDatasetFree(struct cdwJointDataset **pEl)
/* Free a single dynamically allocated cdwJointDataset such as created
 * with cdwJointDatasetLoad(). */
{
struct cdwJointDataset *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->label);
freeMem(el->description);
freeMem(el->childrenNames);
freeMem(el->metaDivTags);
freez(pEl);
}

void cdwJointDatasetFreeList(struct cdwJointDataset **pList)
/* Free a list of dynamically allocated cdwJointDataset's */
{
struct cdwJointDataset *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cdwJointDatasetFree(&el);
    }
*pList = NULL;
}

void cdwJointDatasetOutput(struct cdwJointDataset *el, FILE *f, char sep, char lastSep) 
/* Print out cdwJointDataset.  Separate fields with sep. Follow last field with lastSep. */
{
fprintf(f, "%u", el->id);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->label);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->childrenNames);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->metaDivTags);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

