# cdwStep.sql was originally generated by the autoSql program, which also 
# generated cdwStep.c and cdwStep.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#A step in an analysis pipeline - produces new files from old. See also cdwStepRun
CREATE TABLE cdwStepDef (
    id int unsigned auto_increment,	# Pipeline id
    name varchar(255) default '',	# Name of this analysis step
    description varchar(255) default '',	# Description of step, about a sentence.
              #Indices
    PRIMARY KEY(id),
    UNIQUE(name)
);

#A particular run of a step.
CREATE TABLE cdwStepRun (
    id int unsigned auto_increment,	# Analysis run ID
    stepDef int unsigned default 0,	# Associated step definition
    stepVersion varchar(255) default '',	# Version number of step
              #Indices
    PRIMARY KEY(id)
);

#Inputs to an cdwStepRun
CREATE TABLE cdwStepIn (
    id int unsigned auto_increment,	# Input table ID
    stepRunId int unsigned default 0,	# Which cdwStepRun this is associated with
    name varchar(255) default '',	# Input name within step
    ix int unsigned default 0,	# Inputs always potentially vectors.  Have single one with zero ix for scalar input
    fileId int unsigned default 0,	# Associated file.
              #Indices
    PRIMARY KEY(id),
    INDEX(stepRunId)
);

#Outputs to an cdwAnalysis
CREATE TABLE cdwStepOut (
    id int unsigned auto_increment,	# Output table ID
    stepRunId int unsigned default 0,	# Which cdwStepRun this is associated with
    name varchar(255) default '',	# Output name within step
    ix int unsigned default 0,	# Outputs always potentially vectors. Have single one with zero ix for scalar output
    fileId int unsigned default 0,	# Associated file.
              #Indices
    PRIMARY KEY(id),
    INDEX(stepRunId)
);
