/* pslGenoJobs - Make up condor jobs to align genome against itself. */
#include "common.h"
#include "portable.h"


void usage()
/* Explain usage and exit. */
{
errAbort(
  "pslGenoJobs - Make up condor jobs to align genome against itself.\n"
  "usage\n"
  "   pslGenoJobs runDir start end genoDir(s)\n"
  "This will make runDir if it doesn't exist, and place inside runDir\n"
  "g2g.con, g2g.in, g2g.out, g2g.log, g2g.err.");
}

struct fileInfo *readDirs(int dirCount, char *dirs[])
/* Return extended listing of all dirs. */
{
struct fileInfo *allFiles = NULL, *oneDir, *oneFile;
int i;
double totalSize = 0;

for (i=0; i<dirCount; ++i)
    {
    printf("Listing %s...", dirs[i]);
    fflush(stdout);
    oneDir = listDirX(dirs[i], "*.fa", TRUE);
    printf("got %d files\n", slCount(oneDir));
    allFiles = slCat(allFiles, oneDir);
    }
for (oneFile = allFiles; oneFile != NULL; oneFile = oneFile->next)
    totalSize += oneFile->size;
printf("Total %d files %e bytes\n", slCount(allFiles), totalSize);
return allFiles;
}

void pslGenoJobs(char *runDir, int start, int end, int genoDirCount, char *genoDirs[])
/* Read geno input dirs and build files to help align
 * genome vs. genome. */
{
struct fileInfo *allFiles = NULL, *oneFile;
int bundleSize = 160;
int bundleCount = 0;
int i, j;
char inDir[512];
char outDir[512];
char logDir[512];
char errDir[512];
char pslDir[512];
char fileName[512];
FILE *f;

/* Make output directory tree. */
makeDir(runDir);
sprintf(inDir, "%s/in", runDir);
makeDir(inDir);
sprintf(outDir, "%s/out", runDir);
makeDir(outDir);
sprintf(errDir, "%s/err", runDir);
makeDir(errDir);
sprintf(logDir, "%s/log", runDir);
makeDir(logDir);
sprintf(pslDir, "%s/psl", runDir);
makeDir(pslDir);

/* Read input. */
oneFile = allFiles = readDirs(genoDirCount, genoDirs);

/* Make output file lists. */
while (oneFile != NULL)
    {
    sprintf(fileName, "%s/%d", inDir, bundleCount);
    f = mustOpen(fileName, "w");
    for (i=0; i<bundleSize && oneFile != NULL; ++i, oneFile = oneFile->next)
	fprintf(f, "%s\n", oneFile->name);
    fclose(f);
    ++bundleCount;
    }
printf("Wrote %d bundles of %d files each\n", bundleCount, bundleSize);

if (end > bundleCount) end = bundleCount;
sprintf(fileName, "%s/%d_to_%d.con", runDir, start, end);
f = mustOpen(fileName, "w");
fprintf(f, 
"# Condor submit file to create self alignments to /projects/cc/hg/gs.2/oo.13\n"
"# Generated by  pslGenoJobs\n"
"\n"
"universe        = vanilla\n"
"notification    = error\n"
"requirements    = memory > 250\n"
"executable      = /cse/guests/kent/bin/i386/psLayout\n"
"initialdir      = %s\n"
"\n"
 , runDir);

for (i=start; i<end; ++i)
    {
    for (j = i; j<bundleCount; ++j)
	{
	fprintf(f, "log = %s/%d_%d\n", logDir, i, j);
	fprintf(f, "error = %s/%d_%d\n", errDir, i, j);
	fprintf(f, "output = %s/%d_%d\n", outDir, i, j);
	fprintf(f, "arguments = in/%d in/%d g2g /var/tmp/hg/h/11.ooc %s/%d_%d.psl\n",
	    i, j, pslDir, i, j);
	fprintf(f, "queue 1\n");
	fprintf(f, "\n");
	}
    }
}

int main(int argc, char *argv[])
/* Process command line. */
{
char *s,*e;
if (argc < 5)
    usage();
s = argv[2];
e = argv[3];
if (!isdigit(s[0]) || !isdigit(e[0]))
    usage();
pslGenoJobs(argv[1], atoi(s), atoi(e), argc-4, argv+4);
}
