/* blastTab.c was originally generated by the autoSql program, which also 
 * generated blastTab.h and blastTab.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "blastTab.h"


void blastTabStaticLoad(char **row, struct blastTab *ret)
/* Load a row from blastTab table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->query = row[0];
ret->target = row[1];
ret->identity = atof(row[2]);
ret->aliLength = sqlUnsigned(row[3]);
ret->mismatch = sqlUnsigned(row[4]);
ret->gapOpen = sqlUnsigned(row[5]);
ret->qStart = sqlUnsigned(row[6]);
ret->qEnd = sqlUnsigned(row[7]);
ret->tStart = sqlUnsigned(row[8]);
ret->tEnd = sqlUnsigned(row[9]);
ret->eValue = atof(row[10]);
ret->bitScore = atof(row[11]);
}

struct blastTab *blastTabLoad(char **row)
/* Load a blastTab from row fetched with select * from blastTab
 * from database.  Dispose of this with blastTabFree(). */
{
struct blastTab *ret;

AllocVar(ret);
ret->query = cloneString(row[0]);
ret->target = cloneString(row[1]);
ret->identity = atof(row[2]);
ret->aliLength = sqlUnsigned(row[3]);
ret->mismatch = sqlUnsigned(row[4]);
ret->gapOpen = sqlUnsigned(row[5]);
ret->qStart = sqlUnsigned(row[6]);
ret->qEnd = sqlUnsigned(row[7]);
ret->tStart = sqlUnsigned(row[8]);
ret->tEnd = sqlUnsigned(row[9]);
ret->eValue = atof(row[10]);
ret->bitScore = atof(row[11]);
return ret;
}

struct blastTab *blastTabNext(struct lineFile *lf) 
{
char *row[12];
struct blastTab *el;

if (!lineFileRow(lf, row))
    return NULL;

el = blastTabLoad(row);
return el;
}

struct blastTab *blastTabLoadAll(char *fileName) 
/* Load all blastTab from a whitespace-separated file.
 * Dispose of this with blastTabFreeList(). */
{
struct blastTab *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = blastTabLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct blastTab *blastTabCommaIn(char **pS, struct blastTab *ret)
/* Create a blastTab out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new blastTab */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->query = sqlStringComma(&s);
ret->target = sqlStringComma(&s);
ret->identity = sqlFloatComma(&s);
ret->aliLength = sqlUnsignedComma(&s);
ret->mismatch = sqlUnsignedComma(&s);
ret->gapOpen = sqlUnsignedComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->qEnd = sqlUnsignedComma(&s);
ret->tStart = sqlUnsignedComma(&s);
ret->tEnd = sqlUnsignedComma(&s);
ret->eValue = sqlDoubleComma(&s);
ret->bitScore = sqlDoubleComma(&s);
*pS = s;
return ret;
}

void blastTabFree(struct blastTab **pEl)
/* Free a single dynamically allocated blastTab such as created
 * with blastTabLoad(). */
{
struct blastTab *el;

if ((el = *pEl) == NULL) return;
freeMem(el->query);
freeMem(el->target);
freez(pEl);
}

void blastTabFreeList(struct blastTab **pList)
/* Free a list of dynamically allocated blastTab's */
{
struct blastTab *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    blastTabFree(&el);
    }
*pList = NULL;
}

void blastTabOutput(struct blastTab *el, FILE *f, char sep, char lastSep) 
/* Print out blastTab.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->query);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->target);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->identity);
fputc(sep,f);
fprintf(f, "%u", el->aliLength);
fputc(sep,f);
fprintf(f, "%u", el->mismatch);
fputc(sep,f);
fprintf(f, "%u", el->gapOpen);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->qEnd);
fputc(sep,f);
fprintf(f, "%u", el->tStart);
fputc(sep,f);
fprintf(f, "%u", el->tEnd);
fputc(sep,f);
fprintf(f, "%e", el->eValue);
fputc(sep,f);
fprintf(f, "%f", el->bitScore);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

