/* gbWarn.c was originally generated by the autoSql program, which also 
 * generated gbWarn.h and gbWarn.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "gbWarn.h"


/* definitions for reason column */
static char *values_reason[] = {"invitroNorm", "athRage", "orestes", NULL};
static struct hash *valhash_reason = NULL;

void gbWarnStaticLoad(char **row, struct gbWarn *ret)
/* Load a row from gbWarn table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

safecpy(ret->acc, sizeof(ret->acc), row[0]);
ret->reason = sqlEnumParse(row[1], values_reason, &valhash_reason);
}

struct gbWarn *gbWarnLoad(char **row)
/* Load a gbWarn from row fetched with select * from gbWarn
 * from database.  Dispose of this with gbWarnFree(). */
{
struct gbWarn *ret;

AllocVar(ret);
safecpy(ret->acc, sizeof(ret->acc), row[0]);
ret->reason = sqlEnumParse(row[1], values_reason, &valhash_reason);
return ret;
}

struct gbWarn *gbWarnLoadAll(char *fileName) 
/* Load all gbWarn from a whitespace-separated file.
 * Dispose of this with gbWarnFreeList(). */
{
struct gbWarn *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = gbWarnLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbWarn *gbWarnLoadAllByChar(char *fileName, char chopper) 
/* Load all gbWarn from a chopper separated file.
 * Dispose of this with gbWarnFreeList(). */
{
struct gbWarn *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = gbWarnLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct gbWarn *gbWarnCommaIn(char **pS, struct gbWarn *ret)
/* Create a gbWarn out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gbWarn */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
sqlFixedStringComma(&s, ret->acc, sizeof(ret->acc));
ret->reason = sqlEnumComma(&s, values_reason, &valhash_reason);
*pS = s;
return ret;
}

void gbWarnFree(struct gbWarn **pEl)
/* Free a single dynamically allocated gbWarn such as created
 * with gbWarnLoad(). */
{
struct gbWarn *el;

if ((el = *pEl) == NULL) return;
freez(pEl);
}

void gbWarnFreeList(struct gbWarn **pList)
/* Free a list of dynamically allocated gbWarn's */
{
struct gbWarn *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gbWarnFree(&el);
    }
*pList = NULL;
}

void gbWarnOutput(struct gbWarn *el, FILE *f, char sep, char lastSep) 
/* Print out gbWarn.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
sqlEnumPrint(f, el->reason, values_reason);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

