/* cdw.h was originally generated by the autoSql program, which also 
 * generated cdw.c and cdw.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef CDW_H
#define CDW_H

#include "jksql.h"
#define CDWSETTINGS_NUM_COLS 3

extern char *cdwSettingsCommaSepFieldNames;

struct cdwSettings
/* Settings used to configure warehouse */
    {
    struct cdwSettings *next;  /* Next in singly linked list. */
    unsigned id;	/* Settings ID */
    char *name;	/* Settings name, can't be reused */
    char *val;	/* Settings value, some undefined but not huge thing */
    };

void cdwSettingsStaticLoad(char **row, struct cdwSettings *ret);
/* Load a row from cdwSettings table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwSettings *cdwSettingsLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwSettings from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSettingsFreeList(). */

void cdwSettingsSaveToDb(struct sqlConnection *conn, struct cdwSettings *el, char *tableName, int updateSize);
/* Save cdwSettings as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwSettings *cdwSettingsLoad(char **row);
/* Load a cdwSettings from row fetched with select * from cdwSettings
 * from database.  Dispose of this with cdwSettingsFree(). */

struct cdwSettings *cdwSettingsLoadAll(char *fileName);
/* Load all cdwSettings from whitespace-separated file.
 * Dispose of this with cdwSettingsFreeList(). */

struct cdwSettings *cdwSettingsLoadAllByChar(char *fileName, char chopper);
/* Load all cdwSettings from chopper separated file.
 * Dispose of this with cdwSettingsFreeList(). */

#define cdwSettingsLoadAllByTab(a) cdwSettingsLoadAllByChar(a, '\t');
/* Load all cdwSettings from tab separated file.
 * Dispose of this with cdwSettingsFreeList(). */

struct cdwSettings *cdwSettingsCommaIn(char **pS, struct cdwSettings *ret);
/* Create a cdwSettings out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSettings */

void cdwSettingsFree(struct cdwSettings **pEl);
/* Free a single dynamically allocated cdwSettings such as created
 * with cdwSettingsLoad(). */

void cdwSettingsFreeList(struct cdwSettings **pList);
/* Free a list of dynamically allocated cdwSettings's */

void cdwSettingsOutput(struct cdwSettings *el, FILE *f, char sep, char lastSep);
/* Print out cdwSettings.  Separate fields with sep. Follow last field with lastSep. */

#define cdwSettingsTabOut(el,f) cdwSettingsOutput(el,f,'\t','\n');
/* Print out cdwSettings as a line in a tab-separated file. */

#define cdwSettingsCommaOut(el,f) cdwSettingsOutput(el,f,',',',');
/* Print out cdwSettings as a comma separated list including final comma. */

#define CDWUSER_NUM_COLS 5

extern char *cdwUserCommaSepFieldNames;

struct cdwUser
/* Someone who submits files to or otherwise interacts with big data warehouse */
    {
    struct cdwUser *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented user ID */
    char *email;	/* Email address - required */
    char uuid[38];	/* Help to synchronize us with Stanford. */
    signed char isAdmin;	/* If true the use can modify other people's files too. */
    unsigned primaryGroup;	/* If this is non-zero then we'll make files with this group association. */
    };

void cdwUserStaticLoad(char **row, struct cdwUser *ret);
/* Load a row from cdwUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwUser *cdwUserLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwUserFreeList(). */

void cdwUserSaveToDb(struct sqlConnection *conn, struct cdwUser *el, char *tableName, int updateSize);
/* Save cdwUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwUser *cdwUserLoad(char **row);
/* Load a cdwUser from row fetched with select * from cdwUser
 * from database.  Dispose of this with cdwUserFree(). */

struct cdwUser *cdwUserLoadAll(char *fileName);
/* Load all cdwUser from whitespace-separated file.
 * Dispose of this with cdwUserFreeList(). */

struct cdwUser *cdwUserLoadAllByChar(char *fileName, char chopper);
/* Load all cdwUser from chopper separated file.
 * Dispose of this with cdwUserFreeList(). */

#define cdwUserLoadAllByTab(a) cdwUserLoadAllByChar(a, '\t');
/* Load all cdwUser from tab separated file.
 * Dispose of this with cdwUserFreeList(). */

struct cdwUser *cdwUserCommaIn(char **pS, struct cdwUser *ret);
/* Create a cdwUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwUser */

void cdwUserFree(struct cdwUser **pEl);
/* Free a single dynamically allocated cdwUser such as created
 * with cdwUserLoad(). */

void cdwUserFreeList(struct cdwUser **pList);
/* Free a list of dynamically allocated cdwUser's */

void cdwUserOutput(struct cdwUser *el, FILE *f, char sep, char lastSep);
/* Print out cdwUser.  Separate fields with sep. Follow last field with lastSep. */

#define cdwUserTabOut(el,f) cdwUserOutput(el,f,'\t','\n');
/* Print out cdwUser as a line in a tab-separated file. */

#define cdwUserCommaOut(el,f) cdwUserOutput(el,f,',',',');
/* Print out cdwUser as a comma separated list including final comma. */

#define CDWGROUP_NUM_COLS 3

extern char *cdwGroupCommaSepFieldNames;

struct cdwGroup
/* A group in the access control sense */
    {
    struct cdwGroup *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented user ID */
    char *name;	/* Symbolic name for group, should follow rules of a lowercase C symbol. */
    char *description;	/* Description of group */
    };

void cdwGroupStaticLoad(char **row, struct cdwGroup *ret);
/* Load a row from cdwGroup table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwGroup *cdwGroupLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwGroup from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupFreeList(). */

void cdwGroupSaveToDb(struct sqlConnection *conn, struct cdwGroup *el, char *tableName, int updateSize);
/* Save cdwGroup as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwGroup *cdwGroupLoad(char **row);
/* Load a cdwGroup from row fetched with select * from cdwGroup
 * from database.  Dispose of this with cdwGroupFree(). */

struct cdwGroup *cdwGroupLoadAll(char *fileName);
/* Load all cdwGroup from whitespace-separated file.
 * Dispose of this with cdwGroupFreeList(). */

struct cdwGroup *cdwGroupLoadAllByChar(char *fileName, char chopper);
/* Load all cdwGroup from chopper separated file.
 * Dispose of this with cdwGroupFreeList(). */

#define cdwGroupLoadAllByTab(a) cdwGroupLoadAllByChar(a, '\t');
/* Load all cdwGroup from tab separated file.
 * Dispose of this with cdwGroupFreeList(). */

struct cdwGroup *cdwGroupCommaIn(char **pS, struct cdwGroup *ret);
/* Create a cdwGroup out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroup */

void cdwGroupFree(struct cdwGroup **pEl);
/* Free a single dynamically allocated cdwGroup such as created
 * with cdwGroupLoad(). */

void cdwGroupFreeList(struct cdwGroup **pList);
/* Free a list of dynamically allocated cdwGroup's */

void cdwGroupOutput(struct cdwGroup *el, FILE *f, char sep, char lastSep);
/* Print out cdwGroup.  Separate fields with sep. Follow last field with lastSep. */

#define cdwGroupTabOut(el,f) cdwGroupOutput(el,f,'\t','\n');
/* Print out cdwGroup as a line in a tab-separated file. */

#define cdwGroupCommaOut(el,f) cdwGroupOutput(el,f,',',',');
/* Print out cdwGroup as a comma separated list including final comma. */

#define CDWGROUPFILE_NUM_COLS 2

extern char *cdwGroupFileCommaSepFieldNames;

struct cdwGroupFile
/* Association table between cdwFile and cdwGroup */
    {
    struct cdwGroupFile *next;  /* Next in singly linked list. */
    unsigned fileId;	/* What is the file */
    unsigned groupId;	/* What is the group */
    };

void cdwGroupFileStaticLoad(char **row, struct cdwGroupFile *ret);
/* Load a row from cdwGroupFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwGroupFile *cdwGroupFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwGroupFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupFileFreeList(). */

void cdwGroupFileSaveToDb(struct sqlConnection *conn, struct cdwGroupFile *el, char *tableName, int updateSize);
/* Save cdwGroupFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwGroupFile *cdwGroupFileLoad(char **row);
/* Load a cdwGroupFile from row fetched with select * from cdwGroupFile
 * from database.  Dispose of this with cdwGroupFileFree(). */

struct cdwGroupFile *cdwGroupFileLoadAll(char *fileName);
/* Load all cdwGroupFile from whitespace-separated file.
 * Dispose of this with cdwGroupFileFreeList(). */

struct cdwGroupFile *cdwGroupFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwGroupFile from chopper separated file.
 * Dispose of this with cdwGroupFileFreeList(). */

#define cdwGroupFileLoadAllByTab(a) cdwGroupFileLoadAllByChar(a, '\t');
/* Load all cdwGroupFile from tab separated file.
 * Dispose of this with cdwGroupFileFreeList(). */

struct cdwGroupFile *cdwGroupFileCommaIn(char **pS, struct cdwGroupFile *ret);
/* Create a cdwGroupFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroupFile */

void cdwGroupFileFree(struct cdwGroupFile **pEl);
/* Free a single dynamically allocated cdwGroupFile such as created
 * with cdwGroupFileLoad(). */

void cdwGroupFileFreeList(struct cdwGroupFile **pList);
/* Free a list of dynamically allocated cdwGroupFile's */

void cdwGroupFileOutput(struct cdwGroupFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwGroupFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwGroupFileTabOut(el,f) cdwGroupFileOutput(el,f,'\t','\n');
/* Print out cdwGroupFile as a line in a tab-separated file. */

#define cdwGroupFileCommaOut(el,f) cdwGroupFileOutput(el,f,',',',');
/* Print out cdwGroupFile as a comma separated list including final comma. */

#define CDWGROUPUSER_NUM_COLS 2

extern char *cdwGroupUserCommaSepFieldNames;

struct cdwGroupUser
/* Association table between cdwGroup and cdwUser */
    {
    struct cdwGroupUser *next;  /* Next in singly linked list. */
    unsigned userId;	/* What is the user */
    unsigned groupId;	/* What is the group */
    };

void cdwGroupUserStaticLoad(char **row, struct cdwGroupUser *ret);
/* Load a row from cdwGroupUser table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwGroupUser *cdwGroupUserLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwGroupUser from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwGroupUserFreeList(). */

void cdwGroupUserSaveToDb(struct sqlConnection *conn, struct cdwGroupUser *el, char *tableName, int updateSize);
/* Save cdwGroupUser as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwGroupUser *cdwGroupUserLoad(char **row);
/* Load a cdwGroupUser from row fetched with select * from cdwGroupUser
 * from database.  Dispose of this with cdwGroupUserFree(). */

struct cdwGroupUser *cdwGroupUserLoadAll(char *fileName);
/* Load all cdwGroupUser from whitespace-separated file.
 * Dispose of this with cdwGroupUserFreeList(). */

struct cdwGroupUser *cdwGroupUserLoadAllByChar(char *fileName, char chopper);
/* Load all cdwGroupUser from chopper separated file.
 * Dispose of this with cdwGroupUserFreeList(). */

#define cdwGroupUserLoadAllByTab(a) cdwGroupUserLoadAllByChar(a, '\t');
/* Load all cdwGroupUser from tab separated file.
 * Dispose of this with cdwGroupUserFreeList(). */

struct cdwGroupUser *cdwGroupUserCommaIn(char **pS, struct cdwGroupUser *ret);
/* Create a cdwGroupUser out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwGroupUser */

void cdwGroupUserFree(struct cdwGroupUser **pEl);
/* Free a single dynamically allocated cdwGroupUser such as created
 * with cdwGroupUserLoad(). */

void cdwGroupUserFreeList(struct cdwGroupUser **pList);
/* Free a list of dynamically allocated cdwGroupUser's */

void cdwGroupUserOutput(struct cdwGroupUser *el, FILE *f, char sep, char lastSep);
/* Print out cdwGroupUser.  Separate fields with sep. Follow last field with lastSep. */

#define cdwGroupUserTabOut(el,f) cdwGroupUserOutput(el,f,'\t','\n');
/* Print out cdwGroupUser as a line in a tab-separated file. */

#define cdwGroupUserCommaOut(el,f) cdwGroupUserOutput(el,f,',',',');
/* Print out cdwGroupUser as a comma separated list including final comma. */

#define CDWLAB_NUM_COLS 5

extern char *cdwLabCommaSepFieldNames;

struct cdwLab
/* A contributing lab */
    {
    struct cdwLab *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented user ID */
    char *name;	/* Shorthand name for lab, all lower case */
    char *pi;	/* Principle investigator responsible for lab */
    char *institution;	/* University or other institution hosting lab */
    char *url;	/* URL of lab page */
    };

void cdwLabStaticLoad(char **row, struct cdwLab *ret);
/* Load a row from cdwLab table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwLab *cdwLabLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwLab from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwLabFreeList(). */

void cdwLabSaveToDb(struct sqlConnection *conn, struct cdwLab *el, char *tableName, int updateSize);
/* Save cdwLab as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwLab *cdwLabLoad(char **row);
/* Load a cdwLab from row fetched with select * from cdwLab
 * from database.  Dispose of this with cdwLabFree(). */

struct cdwLab *cdwLabLoadAll(char *fileName);
/* Load all cdwLab from whitespace-separated file.
 * Dispose of this with cdwLabFreeList(). */

struct cdwLab *cdwLabLoadAllByChar(char *fileName, char chopper);
/* Load all cdwLab from chopper separated file.
 * Dispose of this with cdwLabFreeList(). */

#define cdwLabLoadAllByTab(a) cdwLabLoadAllByChar(a, '\t');
/* Load all cdwLab from tab separated file.
 * Dispose of this with cdwLabFreeList(). */

struct cdwLab *cdwLabCommaIn(char **pS, struct cdwLab *ret);
/* Create a cdwLab out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwLab */

void cdwLabFree(struct cdwLab **pEl);
/* Free a single dynamically allocated cdwLab such as created
 * with cdwLabLoad(). */

void cdwLabFreeList(struct cdwLab **pList);
/* Free a list of dynamically allocated cdwLab's */

void cdwLabOutput(struct cdwLab *el, FILE *f, char sep, char lastSep);
/* Print out cdwLab.  Separate fields with sep. Follow last field with lastSep. */

#define cdwLabTabOut(el,f) cdwLabOutput(el,f,'\t','\n');
/* Print out cdwLab as a line in a tab-separated file. */

#define cdwLabCommaOut(el,f) cdwLabOutput(el,f,',',',');
/* Print out cdwLab as a comma separated list including final comma. */

#define CDWSCRIPTREGISTRY_NUM_COLS 6

extern char *cdwScriptRegistryCommaSepFieldNames;

struct cdwScriptRegistry
/* A script that is authorized to submit on behalf of a user */
    {
    struct cdwScriptRegistry *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented script ID */
    unsigned userId;	/* Associated user */
    char *name;	/* Script name - unique in system and autogenerated */
    char *description;	/* Script description */
    char *secretHash;	/* Hashed script password */
    int submitCount;	/* Number of submissions attempted */
    };

void cdwScriptRegistryStaticLoad(char **row, struct cdwScriptRegistry *ret);
/* Load a row from cdwScriptRegistry table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwScriptRegistry *cdwScriptRegistryLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwScriptRegistry from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwScriptRegistryFreeList(). */

void cdwScriptRegistrySaveToDb(struct sqlConnection *conn, struct cdwScriptRegistry *el, char *tableName, int updateSize);
/* Save cdwScriptRegistry as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwScriptRegistry *cdwScriptRegistryLoad(char **row);
/* Load a cdwScriptRegistry from row fetched with select * from cdwScriptRegistry
 * from database.  Dispose of this with cdwScriptRegistryFree(). */

struct cdwScriptRegistry *cdwScriptRegistryLoadAll(char *fileName);
/* Load all cdwScriptRegistry from whitespace-separated file.
 * Dispose of this with cdwScriptRegistryFreeList(). */

struct cdwScriptRegistry *cdwScriptRegistryLoadAllByChar(char *fileName, char chopper);
/* Load all cdwScriptRegistry from chopper separated file.
 * Dispose of this with cdwScriptRegistryFreeList(). */

#define cdwScriptRegistryLoadAllByTab(a) cdwScriptRegistryLoadAllByChar(a, '\t');
/* Load all cdwScriptRegistry from tab separated file.
 * Dispose of this with cdwScriptRegistryFreeList(). */

struct cdwScriptRegistry *cdwScriptRegistryCommaIn(char **pS, struct cdwScriptRegistry *ret);
/* Create a cdwScriptRegistry out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwScriptRegistry */

void cdwScriptRegistryFree(struct cdwScriptRegistry **pEl);
/* Free a single dynamically allocated cdwScriptRegistry such as created
 * with cdwScriptRegistryLoad(). */

void cdwScriptRegistryFreeList(struct cdwScriptRegistry **pList);
/* Free a list of dynamically allocated cdwScriptRegistry's */

void cdwScriptRegistryOutput(struct cdwScriptRegistry *el, FILE *f, char sep, char lastSep);
/* Print out cdwScriptRegistry.  Separate fields with sep. Follow last field with lastSep. */

#define cdwScriptRegistryTabOut(el,f) cdwScriptRegistryOutput(el,f,'\t','\n');
/* Print out cdwScriptRegistry as a line in a tab-separated file. */

#define cdwScriptRegistryCommaOut(el,f) cdwScriptRegistryOutput(el,f,',',',');
/* Print out cdwScriptRegistry as a comma separated list including final comma. */

#define CDWHOST_NUM_COLS 10

extern char *cdwHostCommaSepFieldNames;

struct cdwHost
/* A web host we have collected files from - something like www.ncbi.nlm.gov or google.com */
    {
    struct cdwHost *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented host id */
    char *name;	/* Name (before DNS lookup) */
    long long lastOkTime;	/* Last time host was ok in seconds since 1970 */
    long long lastNotOkTime;	/* Last time host was not ok in seconds since 1970 */
    long long firstAdded;	/* Time host was first seen */
    char *errorMessage;	/* If non-empty contains last error message from host. If empty host is ok */
    long long openSuccesses;	/* Number of times files have been opened ok from this host */
    long long openFails;	/* Number of times files have failed to open from this host */
    long long historyBits;	/* Open history with most recent in least significant bit. 0 for connection failed, 1 for success */
    int paraFetchStreams;	/* Number of open streams for paraFetch command.  10 for most places, 30 for Barcelona */
    };

void cdwHostStaticLoad(char **row, struct cdwHost *ret);
/* Load a row from cdwHost table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwHost *cdwHostLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwHost from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwHostFreeList(). */

void cdwHostSaveToDb(struct sqlConnection *conn, struct cdwHost *el, char *tableName, int updateSize);
/* Save cdwHost as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwHost *cdwHostLoad(char **row);
/* Load a cdwHost from row fetched with select * from cdwHost
 * from database.  Dispose of this with cdwHostFree(). */

struct cdwHost *cdwHostLoadAll(char *fileName);
/* Load all cdwHost from whitespace-separated file.
 * Dispose of this with cdwHostFreeList(). */

struct cdwHost *cdwHostLoadAllByChar(char *fileName, char chopper);
/* Load all cdwHost from chopper separated file.
 * Dispose of this with cdwHostFreeList(). */

#define cdwHostLoadAllByTab(a) cdwHostLoadAllByChar(a, '\t');
/* Load all cdwHost from tab separated file.
 * Dispose of this with cdwHostFreeList(). */

struct cdwHost *cdwHostCommaIn(char **pS, struct cdwHost *ret);
/* Create a cdwHost out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwHost */

void cdwHostFree(struct cdwHost **pEl);
/* Free a single dynamically allocated cdwHost such as created
 * with cdwHostLoad(). */

void cdwHostFreeList(struct cdwHost **pList);
/* Free a list of dynamically allocated cdwHost's */

void cdwHostOutput(struct cdwHost *el, FILE *f, char sep, char lastSep);
/* Print out cdwHost.  Separate fields with sep. Follow last field with lastSep. */

#define cdwHostTabOut(el,f) cdwHostOutput(el,f,'\t','\n');
/* Print out cdwHost as a line in a tab-separated file. */

#define cdwHostCommaOut(el,f) cdwHostOutput(el,f,',',',');
/* Print out cdwHost as a comma separated list including final comma. */

#define CDWSUBMITDIR_NUM_COLS 10

extern char *cdwSubmitDirCommaSepFieldNames;

struct cdwSubmitDir
/* An external data directory we have collected a submit from */
    {
    struct cdwSubmitDir *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented id */
    char *url;	/* Web-mounted directory. Includes protocol, host, and final '/' */
    unsigned hostId;	/* Id of host it's on */
    long long lastOkTime;	/* Last time submit dir was ok in seconds since 1970 */
    long long lastNotOkTime;	/* Last time submit dir was not ok in seconds since 1970 */
    long long firstAdded;	/* Time submit dir was first seen */
    char *errorMessage;	/* If non-empty contains last error message from dir. If empty dir is ok */
    long long openSuccesses;	/* Number of times files have been opened ok from this dir */
    long long openFails;	/* Number of times files have failed to open from this dir */
    long long historyBits;	/* Open history with most recent in least significant bit. 0 for upload failed, 1 for success */
    };

void cdwSubmitDirStaticLoad(char **row, struct cdwSubmitDir *ret);
/* Load a row from cdwSubmitDir table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwSubmitDir *cdwSubmitDirLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwSubmitDir from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubmitDirFreeList(). */

void cdwSubmitDirSaveToDb(struct sqlConnection *conn, struct cdwSubmitDir *el, char *tableName, int updateSize);
/* Save cdwSubmitDir as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwSubmitDir *cdwSubmitDirLoad(char **row);
/* Load a cdwSubmitDir from row fetched with select * from cdwSubmitDir
 * from database.  Dispose of this with cdwSubmitDirFree(). */

struct cdwSubmitDir *cdwSubmitDirLoadAll(char *fileName);
/* Load all cdwSubmitDir from whitespace-separated file.
 * Dispose of this with cdwSubmitDirFreeList(). */

struct cdwSubmitDir *cdwSubmitDirLoadAllByChar(char *fileName, char chopper);
/* Load all cdwSubmitDir from chopper separated file.
 * Dispose of this with cdwSubmitDirFreeList(). */

#define cdwSubmitDirLoadAllByTab(a) cdwSubmitDirLoadAllByChar(a, '\t');
/* Load all cdwSubmitDir from tab separated file.
 * Dispose of this with cdwSubmitDirFreeList(). */

struct cdwSubmitDir *cdwSubmitDirCommaIn(char **pS, struct cdwSubmitDir *ret);
/* Create a cdwSubmitDir out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubmitDir */

void cdwSubmitDirFree(struct cdwSubmitDir **pEl);
/* Free a single dynamically allocated cdwSubmitDir such as created
 * with cdwSubmitDirLoad(). */

void cdwSubmitDirFreeList(struct cdwSubmitDir **pList);
/* Free a list of dynamically allocated cdwSubmitDir's */

void cdwSubmitDirOutput(struct cdwSubmitDir *el, FILE *f, char sep, char lastSep);
/* Print out cdwSubmitDir.  Separate fields with sep. Follow last field with lastSep. */

#define cdwSubmitDirTabOut(el,f) cdwSubmitDirOutput(el,f,'\t','\n');
/* Print out cdwSubmitDir as a line in a tab-separated file. */

#define cdwSubmitDirCommaOut(el,f) cdwSubmitDirOutput(el,f,',',',');
/* Print out cdwSubmitDir as a comma separated list including final comma. */

#define CDWMETATAGS_NUM_COLS 3

extern char *cdwMetaTagsCommaSepFieldNames;

struct cdwMetaTags
/* Where we keep expanded metadata tags for each file, though many share. */
    {
    struct cdwMetaTags *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincrementing table id */
    char md5[33];	/* md5 sum of tags string */
    char *tags;	/* CGI encoded name=val pairs from manifest */
    };

void cdwMetaTagsStaticLoad(char **row, struct cdwMetaTags *ret);
/* Load a row from cdwMetaTags table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwMetaTags *cdwMetaTagsLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwMetaTags from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwMetaTagsFreeList(). */

void cdwMetaTagsSaveToDb(struct sqlConnection *conn, struct cdwMetaTags *el, char *tableName, int updateSize);
/* Save cdwMetaTags as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwMetaTags *cdwMetaTagsLoad(char **row);
/* Load a cdwMetaTags from row fetched with select * from cdwMetaTags
 * from database.  Dispose of this with cdwMetaTagsFree(). */

struct cdwMetaTags *cdwMetaTagsLoadAll(char *fileName);
/* Load all cdwMetaTags from whitespace-separated file.
 * Dispose of this with cdwMetaTagsFreeList(). */

struct cdwMetaTags *cdwMetaTagsLoadAllByChar(char *fileName, char chopper);
/* Load all cdwMetaTags from chopper separated file.
 * Dispose of this with cdwMetaTagsFreeList(). */

#define cdwMetaTagsLoadAllByTab(a) cdwMetaTagsLoadAllByChar(a, '\t');
/* Load all cdwMetaTags from tab separated file.
 * Dispose of this with cdwMetaTagsFreeList(). */

struct cdwMetaTags *cdwMetaTagsCommaIn(char **pS, struct cdwMetaTags *ret);
/* Create a cdwMetaTags out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwMetaTags */

void cdwMetaTagsFree(struct cdwMetaTags **pEl);
/* Free a single dynamically allocated cdwMetaTags such as created
 * with cdwMetaTagsLoad(). */

void cdwMetaTagsFreeList(struct cdwMetaTags **pList);
/* Free a list of dynamically allocated cdwMetaTags's */

void cdwMetaTagsOutput(struct cdwMetaTags *el, FILE *f, char sep, char lastSep);
/* Print out cdwMetaTags.  Separate fields with sep. Follow last field with lastSep. */

#define cdwMetaTagsTabOut(el,f) cdwMetaTagsOutput(el,f,'\t','\n');
/* Print out cdwMetaTags as a line in a tab-separated file. */

#define cdwMetaTagsCommaOut(el,f) cdwMetaTagsOutput(el,f,',',',');
/* Print out cdwMetaTags as a comma separated list including final comma. */

#define CDWFILE_NUM_COLS 19

extern char *cdwFileCommaSepFieldNames;

struct cdwFile
/* A file we are tracking that we intend to and maybe have uploaded */
    {
    struct cdwFile *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincrementing file id */
    unsigned submitId;	/* Links to id in submit table */
    unsigned submitDirId;	/* Links to id in submitDir table */
    unsigned userId;	/* Id in user table of file owner */
    char *submitFileName;	/* File name in submit relative to submit dir */
    char *cdwFileName;	/* File name in big data warehouse relative to cdw root dir */
    long long startUploadTime;	/* Time when upload started - 0 if not started */
    long long endUploadTime;	/* Time when upload finished - 0 if not finished */
    long long updateTime;	/* Update time (on system it was uploaded from) */
    long long size;	/* File size in manifest */
    char md5[33];	/* md5 sum of file contents */
    char *tags;	/* CGI encoded name=val pairs from manifest */
    unsigned metaTagsId;	/* ID of associated metadata tags */
    char *errorMessage;	/* If non-empty contains last error message from upload. If empty upload is ok */
    char *deprecated;	/* If non-empty why you shouldn't use this file any more. */
    unsigned replacedBy;	/* If non-zero id of file that replaces this one. */
    signed char userAccess;	/* 0 - no, 1 - read, 2 - read/write */
    signed char groupAccess;	/* 0 - no, 1 - read, 2 - read/write */
    signed char allAccess;	/* 0 - no, 1 - read, 2 - read/write */
    };

void cdwFileStaticLoad(char **row, struct cdwFile *ret);
/* Load a row from cdwFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwFile *cdwFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwFileFreeList(). */

void cdwFileSaveToDb(struct sqlConnection *conn, struct cdwFile *el, char *tableName, int updateSize);
/* Save cdwFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwFile *cdwFileLoad(char **row);
/* Load a cdwFile from row fetched with select * from cdwFile
 * from database.  Dispose of this with cdwFileFree(). */

struct cdwFile *cdwFileLoadAll(char *fileName);
/* Load all cdwFile from whitespace-separated file.
 * Dispose of this with cdwFileFreeList(). */

struct cdwFile *cdwFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwFile from chopper separated file.
 * Dispose of this with cdwFileFreeList(). */

#define cdwFileLoadAllByTab(a) cdwFileLoadAllByChar(a, '\t');
/* Load all cdwFile from tab separated file.
 * Dispose of this with cdwFileFreeList(). */

struct cdwFile *cdwFileCommaIn(char **pS, struct cdwFile *ret);
/* Create a cdwFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwFile */

void cdwFileFree(struct cdwFile **pEl);
/* Free a single dynamically allocated cdwFile such as created
 * with cdwFileLoad(). */

void cdwFileFreeList(struct cdwFile **pList);
/* Free a list of dynamically allocated cdwFile's */

void cdwFileOutput(struct cdwFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwFileTabOut(el,f) cdwFileOutput(el,f,'\t','\n');
/* Print out cdwFile as a line in a tab-separated file. */

#define cdwFileCommaOut(el,f) cdwFileOutput(el,f,',',',');
/* Print out cdwFile as a comma separated list including final comma. */

#define CDWSUBMIT_NUM_COLS 18

extern char *cdwSubmitCommaSepFieldNames;

struct cdwSubmit
/* A data submit, typically containing many files.  Always associated with a submit dir. */
    {
    struct cdwSubmit *next;  /* Next in singly linked list. */
    unsigned id;	/* Autoincremented submit id */
    char *url;	/* Url to validated.txt format file. We copy this file over and give it a fileId if we can. */
    long long startUploadTime;	/* Time at start of submit */
    long long endUploadTime;	/* Time at end of upload - 0 if not finished */
    unsigned userId;	/* Connects to user table id field */
    unsigned manifestFileId;	/* Points to metadata.txt file for submit. */
    unsigned metaFileId;	/* Points to meta.txt file for submit */
    unsigned submitDirId;	/* Points to the submitDir */
    unsigned fileCount;	/* Number of files that will be in submit if it were complete. */
    unsigned oldFiles;	/* Number of files in submission that were already in warehouse. */
    unsigned newFiles;	/* Number of files in submission that are newly uploaded. */
    long long byteCount;	/* Total bytes in submission including old and new */
    long long oldBytes;	/* Bytes in old files. */
    long long newBytes;	/* Bytes in new files (so far). */
    char *errorMessage;	/* If non-empty contains last error message. If empty submit is ok */
    unsigned fileIdInTransit;	/* cdwFile.id of file currently being transferred or zero */
    unsigned metaChangeCount;	/* Number of files where metadata changed by submission */
    char *wrangler;	/* The UNIX ID of the person who ran cdwSubmit. */
    };

void cdwSubmitStaticLoad(char **row, struct cdwSubmit *ret);
/* Load a row from cdwSubmit table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwSubmit *cdwSubmitLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwSubmit from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubmitFreeList(). */

void cdwSubmitSaveToDb(struct sqlConnection *conn, struct cdwSubmit *el, char *tableName, int updateSize);
/* Save cdwSubmit as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwSubmit *cdwSubmitLoad(char **row);
/* Load a cdwSubmit from row fetched with select * from cdwSubmit
 * from database.  Dispose of this with cdwSubmitFree(). */

struct cdwSubmit *cdwSubmitLoadAll(char *fileName);
/* Load all cdwSubmit from whitespace-separated file.
 * Dispose of this with cdwSubmitFreeList(). */

struct cdwSubmit *cdwSubmitLoadAllByChar(char *fileName, char chopper);
/* Load all cdwSubmit from chopper separated file.
 * Dispose of this with cdwSubmitFreeList(). */

#define cdwSubmitLoadAllByTab(a) cdwSubmitLoadAllByChar(a, '\t');
/* Load all cdwSubmit from tab separated file.
 * Dispose of this with cdwSubmitFreeList(). */

struct cdwSubmit *cdwSubmitCommaIn(char **pS, struct cdwSubmit *ret);
/* Create a cdwSubmit out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubmit */

void cdwSubmitFree(struct cdwSubmit **pEl);
/* Free a single dynamically allocated cdwSubmit such as created
 * with cdwSubmitLoad(). */

void cdwSubmitFreeList(struct cdwSubmit **pList);
/* Free a list of dynamically allocated cdwSubmit's */

void cdwSubmitOutput(struct cdwSubmit *el, FILE *f, char sep, char lastSep);
/* Print out cdwSubmit.  Separate fields with sep. Follow last field with lastSep. */

#define cdwSubmitTabOut(el,f) cdwSubmitOutput(el,f,'\t','\n');
/* Print out cdwSubmit as a line in a tab-separated file. */

#define cdwSubmitCommaOut(el,f) cdwSubmitOutput(el,f,',',',');
/* Print out cdwSubmit as a comma separated list including final comma. */

#define CDWSUBSCRIBER_NUM_COLS 7

extern char *cdwSubscriberCommaSepFieldNames;

struct cdwSubscriber
/* Subscribers can have programs that are called at various points during data submission */
    {
    struct cdwSubscriber *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of subscriber */
    char *name;	/* Name of subscriber */
    double runOrder;	/* Determines order subscribers run in. In case of tie lowest id wins. */
    char *filePattern;	/* A string with * and ? wildcards to match files we care about */
    char *dirPattern;	/* A string with * and ? wildcards to match hub dir URLs we care about */
    char *tagPattern;	/* A cgi-encoded string of tag=wildcard pairs. */
    char *onFileEndUpload;	/* A unix command string to run with a %u where file id goes */
    };

void cdwSubscriberStaticLoad(char **row, struct cdwSubscriber *ret);
/* Load a row from cdwSubscriber table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwSubscriber *cdwSubscriberLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwSubscriber from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwSubscriberFreeList(). */

void cdwSubscriberSaveToDb(struct sqlConnection *conn, struct cdwSubscriber *el, char *tableName, int updateSize);
/* Save cdwSubscriber as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwSubscriber *cdwSubscriberLoad(char **row);
/* Load a cdwSubscriber from row fetched with select * from cdwSubscriber
 * from database.  Dispose of this with cdwSubscriberFree(). */

struct cdwSubscriber *cdwSubscriberLoadAll(char *fileName);
/* Load all cdwSubscriber from whitespace-separated file.
 * Dispose of this with cdwSubscriberFreeList(). */

struct cdwSubscriber *cdwSubscriberLoadAllByChar(char *fileName, char chopper);
/* Load all cdwSubscriber from chopper separated file.
 * Dispose of this with cdwSubscriberFreeList(). */

#define cdwSubscriberLoadAllByTab(a) cdwSubscriberLoadAllByChar(a, '\t');
/* Load all cdwSubscriber from tab separated file.
 * Dispose of this with cdwSubscriberFreeList(). */

struct cdwSubscriber *cdwSubscriberCommaIn(char **pS, struct cdwSubscriber *ret);
/* Create a cdwSubscriber out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwSubscriber */

void cdwSubscriberFree(struct cdwSubscriber **pEl);
/* Free a single dynamically allocated cdwSubscriber such as created
 * with cdwSubscriberLoad(). */

void cdwSubscriberFreeList(struct cdwSubscriber **pList);
/* Free a list of dynamically allocated cdwSubscriber's */

void cdwSubscriberOutput(struct cdwSubscriber *el, FILE *f, char sep, char lastSep);
/* Print out cdwSubscriber.  Separate fields with sep. Follow last field with lastSep. */

#define cdwSubscriberTabOut(el,f) cdwSubscriberOutput(el,f,'\t','\n');
/* Print out cdwSubscriber as a line in a tab-separated file. */

#define cdwSubscriberCommaOut(el,f) cdwSubscriberOutput(el,f,',',',');
/* Print out cdwSubscriber as a comma separated list including final comma. */

#define CDWASSEMBLY_NUM_COLS 8

extern char *cdwAssemblyCommaSepFieldNames;

struct cdwAssembly
/* An assembly - includes reference to a two bit file, and a little name and summary info. */
    {
    struct cdwAssembly *next;  /* Next in singly linked list. */
    unsigned id;	/* Assembly ID */
    unsigned taxon;	/* NCBI taxon number */
    char *name;	/* Some human readable name to distinguish this from other collections of DNA */
    char *ucscDb;	/* Which UCSC database (mm9?  hg19?) associated with it. */
    unsigned twoBitId;	/* File ID of associated twoBit file */
    long long baseCount;	/* Count of bases including N's */
    long long realBaseCount;	/* Count of non-N bases in assembly */
    unsigned seqCount;	/* Number of chromosomes or other distinct sequences in assembly */
    };

void cdwAssemblyStaticLoad(char **row, struct cdwAssembly *ret);
/* Load a row from cdwAssembly table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwAssembly *cdwAssemblyLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwAssembly from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwAssemblyFreeList(). */

void cdwAssemblySaveToDb(struct sqlConnection *conn, struct cdwAssembly *el, char *tableName, int updateSize);
/* Save cdwAssembly as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwAssembly *cdwAssemblyLoad(char **row);
/* Load a cdwAssembly from row fetched with select * from cdwAssembly
 * from database.  Dispose of this with cdwAssemblyFree(). */

struct cdwAssembly *cdwAssemblyLoadAll(char *fileName);
/* Load all cdwAssembly from whitespace-separated file.
 * Dispose of this with cdwAssemblyFreeList(). */

struct cdwAssembly *cdwAssemblyLoadAllByChar(char *fileName, char chopper);
/* Load all cdwAssembly from chopper separated file.
 * Dispose of this with cdwAssemblyFreeList(). */

#define cdwAssemblyLoadAllByTab(a) cdwAssemblyLoadAllByChar(a, '\t');
/* Load all cdwAssembly from tab separated file.
 * Dispose of this with cdwAssemblyFreeList(). */

struct cdwAssembly *cdwAssemblyCommaIn(char **pS, struct cdwAssembly *ret);
/* Create a cdwAssembly out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwAssembly */

void cdwAssemblyFree(struct cdwAssembly **pEl);
/* Free a single dynamically allocated cdwAssembly such as created
 * with cdwAssemblyLoad(). */

void cdwAssemblyFreeList(struct cdwAssembly **pList);
/* Free a list of dynamically allocated cdwAssembly's */

void cdwAssemblyOutput(struct cdwAssembly *el, FILE *f, char sep, char lastSep);
/* Print out cdwAssembly.  Separate fields with sep. Follow last field with lastSep. */

#define cdwAssemblyTabOut(el,f) cdwAssemblyOutput(el,f,'\t','\n');
/* Print out cdwAssembly as a line in a tab-separated file. */

#define cdwAssemblyCommaOut(el,f) cdwAssemblyOutput(el,f,',',',');
/* Print out cdwAssembly as a comma separated list including final comma. */

#define CDWBIOSAMPLE_NUM_COLS 4

extern char *cdwBiosampleCommaSepFieldNames;

struct cdwBiosample
/* A biosample - not much info here, just enough to drive analysis pipeline */
    {
    struct cdwBiosample *next;  /* Next in singly linked list. */
    unsigned id;	/* Biosample id */
    char *term;	/* Human readable.. */
    unsigned taxon;	/* NCBI taxon number - 9606 for human. */
    char *sex;	/* One letter code: M male, F female, B both, U unknown */
    };

void cdwBiosampleStaticLoad(char **row, struct cdwBiosample *ret);
/* Load a row from cdwBiosample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwBiosample *cdwBiosampleLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwBiosample from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwBiosampleFreeList(). */

void cdwBiosampleSaveToDb(struct sqlConnection *conn, struct cdwBiosample *el, char *tableName, int updateSize);
/* Save cdwBiosample as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwBiosample *cdwBiosampleLoad(char **row);
/* Load a cdwBiosample from row fetched with select * from cdwBiosample
 * from database.  Dispose of this with cdwBiosampleFree(). */

struct cdwBiosample *cdwBiosampleLoadAll(char *fileName);
/* Load all cdwBiosample from whitespace-separated file.
 * Dispose of this with cdwBiosampleFreeList(). */

struct cdwBiosample *cdwBiosampleLoadAllByChar(char *fileName, char chopper);
/* Load all cdwBiosample from chopper separated file.
 * Dispose of this with cdwBiosampleFreeList(). */

#define cdwBiosampleLoadAllByTab(a) cdwBiosampleLoadAllByChar(a, '\t');
/* Load all cdwBiosample from tab separated file.
 * Dispose of this with cdwBiosampleFreeList(). */

struct cdwBiosample *cdwBiosampleCommaIn(char **pS, struct cdwBiosample *ret);
/* Create a cdwBiosample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwBiosample */

void cdwBiosampleFree(struct cdwBiosample **pEl);
/* Free a single dynamically allocated cdwBiosample such as created
 * with cdwBiosampleLoad(). */

void cdwBiosampleFreeList(struct cdwBiosample **pList);
/* Free a list of dynamically allocated cdwBiosample's */

void cdwBiosampleOutput(struct cdwBiosample *el, FILE *f, char sep, char lastSep);
/* Print out cdwBiosample.  Separate fields with sep. Follow last field with lastSep. */

#define cdwBiosampleTabOut(el,f) cdwBiosampleOutput(el,f,'\t','\n');
/* Print out cdwBiosample as a line in a tab-separated file. */

#define cdwBiosampleCommaOut(el,f) cdwBiosampleOutput(el,f,',',',');
/* Print out cdwBiosample as a comma separated list including final comma. */

#define CDWEXPERIMENT_NUM_COLS 8

extern char *cdwExperimentCommaSepFieldNames;

struct cdwExperiment
/* An experiment - ideally will include a couple of biological replicates. Downloaded from Stanford. */
    {
    struct cdwExperiment *next;  /* Next in singly linked list. */
    char accession[17];	/* ID shared with metadata system. */
    char *dataType;	/* Something liek RNA-seq, DNase-seq, ChIP-seq. Computed at UCSC. */
    char *lab;	/* Lab PI name and institution. Is lab.title at Stanford. */
    char *biosample;	/* Cell line name, tissue source, etc. Is biosample_term_name at Stanford. */
    char *rfa;	/* Something like 'ENCODE2' or 'ENCODE3'.  Is award.rfa at Stanford. */
    char *assayType;	/* Similar to dataType. Is assay_term_name at Stanford. */
    char *ipTarget;	/* The target for the immunoprecipitation in ChIP & RIP. */
    char *control;	/* Primary control for experiment.  Usually another experiment accession. */
    };

void cdwExperimentStaticLoad(char **row, struct cdwExperiment *ret);
/* Load a row from cdwExperiment table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwExperiment *cdwExperimentLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwExperiment from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwExperimentFreeList(). */

void cdwExperimentSaveToDb(struct sqlConnection *conn, struct cdwExperiment *el, char *tableName, int updateSize);
/* Save cdwExperiment as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwExperiment *cdwExperimentLoad(char **row);
/* Load a cdwExperiment from row fetched with select * from cdwExperiment
 * from database.  Dispose of this with cdwExperimentFree(). */

struct cdwExperiment *cdwExperimentLoadAll(char *fileName);
/* Load all cdwExperiment from whitespace-separated file.
 * Dispose of this with cdwExperimentFreeList(). */

struct cdwExperiment *cdwExperimentLoadAllByChar(char *fileName, char chopper);
/* Load all cdwExperiment from chopper separated file.
 * Dispose of this with cdwExperimentFreeList(). */

#define cdwExperimentLoadAllByTab(a) cdwExperimentLoadAllByChar(a, '\t');
/* Load all cdwExperiment from tab separated file.
 * Dispose of this with cdwExperimentFreeList(). */

struct cdwExperiment *cdwExperimentCommaIn(char **pS, struct cdwExperiment *ret);
/* Create a cdwExperiment out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwExperiment */

void cdwExperimentFree(struct cdwExperiment **pEl);
/* Free a single dynamically allocated cdwExperiment such as created
 * with cdwExperimentLoad(). */

void cdwExperimentFreeList(struct cdwExperiment **pList);
/* Free a list of dynamically allocated cdwExperiment's */

void cdwExperimentOutput(struct cdwExperiment *el, FILE *f, char sep, char lastSep);
/* Print out cdwExperiment.  Separate fields with sep. Follow last field with lastSep. */

#define cdwExperimentTabOut(el,f) cdwExperimentOutput(el,f,'\t','\n');
/* Print out cdwExperiment as a line in a tab-separated file. */

#define cdwExperimentCommaOut(el,f) cdwExperimentOutput(el,f,',',',');
/* Print out cdwExperiment as a comma separated list including final comma. */

#define CDWVALIDFILE_NUM_COLS 24

extern char *cdwValidFileCommaSepFieldNames;

struct cdwValidFile
/* A file that has been uploaded, the format checked, and for which at least minimal metadata exists */
    {
    struct cdwValidFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of validated file */
    char licensePlate[17];	/* A abc123 looking license-platish thing. */
    unsigned fileId;	/* Pointer to file in main file table */
    char *format;	/* What format it's in from manifest */
    char *outputType;	/* What output_type it is from manifest */
    char *experiment;	/* What experiment it's in from manifest */
    char *replicate;	/* What replicate it is from manifest.  Values 1,2,3... pooled, or '' */
    char *enrichedIn;	/* The enriched_in tag from manifest */
    char *ucscDb;	/* Something like hg19 or mm9 */
    long long itemCount;	/* # of items in file: reads for fastqs, lines for beds, bases w/data for wig. */
    long long basesInItems;	/* # of bases in items */
    long long sampleCount;	/* # of items in sample if we are just subsampling as we do for reads. */
    long long basesInSample;	/* # of bases in our sample */
    char *sampleBed;	/* Path to a temporary bed file holding sample items */
    double mapRatio;	/* Proportion of items that map to genome */
    double sampleCoverage;	/* Proportion of assembly covered by at least one item in sample */
    double depth;	/* Estimated genome-equivalents covered by possibly overlapping data */
    signed char singleQaStatus;	/* 0 = untested, 1 =  pass, -1 = fail, 2 = forced pass, -2 = forced fail */
    signed char replicateQaStatus;	/* 0 = untested, 1 = pass, -1 = fail, 2 = forced pass, -2 = forced fail */
    char *part;	/* Manifest's file_part. Values 1,2,3... Used for fastqs split for analysis */
    char *pairedEnd;	/* The paired_end tag from the manifest.  Values 1,2 or '' */
    signed char qaVersion;	/* Version of QA pipeline making status decisions */
    double uniqueMapRatio;	/* Fraction of reads that map uniquely to genome for bams and fastqs */
    char *lane;	/* What sequencing lane if any associated with this file. */
    };

void cdwValidFileStaticLoad(char **row, struct cdwValidFile *ret);
/* Load a row from cdwValidFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwValidFile *cdwValidFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwValidFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwValidFileFreeList(). */

void cdwValidFileSaveToDb(struct sqlConnection *conn, struct cdwValidFile *el, char *tableName, int updateSize);
/* Save cdwValidFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwValidFile *cdwValidFileLoad(char **row);
/* Load a cdwValidFile from row fetched with select * from cdwValidFile
 * from database.  Dispose of this with cdwValidFileFree(). */

struct cdwValidFile *cdwValidFileLoadAll(char *fileName);
/* Load all cdwValidFile from whitespace-separated file.
 * Dispose of this with cdwValidFileFreeList(). */

struct cdwValidFile *cdwValidFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwValidFile from chopper separated file.
 * Dispose of this with cdwValidFileFreeList(). */

#define cdwValidFileLoadAllByTab(a) cdwValidFileLoadAllByChar(a, '\t');
/* Load all cdwValidFile from tab separated file.
 * Dispose of this with cdwValidFileFreeList(). */

struct cdwValidFile *cdwValidFileCommaIn(char **pS, struct cdwValidFile *ret);
/* Create a cdwValidFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwValidFile */

void cdwValidFileFree(struct cdwValidFile **pEl);
/* Free a single dynamically allocated cdwValidFile such as created
 * with cdwValidFileLoad(). */

void cdwValidFileFreeList(struct cdwValidFile **pList);
/* Free a list of dynamically allocated cdwValidFile's */

void cdwValidFileOutput(struct cdwValidFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwValidFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwValidFileTabOut(el,f) cdwValidFileOutput(el,f,'\t','\n');
/* Print out cdwValidFile as a line in a tab-separated file. */

#define cdwValidFileCommaOut(el,f) cdwValidFileOutput(el,f,',',',');
/* Print out cdwValidFile as a comma separated list including final comma. */

#define CDWFASTQFILE_NUM_COLS 29

extern char *cdwFastqFileCommaSepFieldNames;

struct cdwFastqFile
/* info on a file in fastq short read format beyond what's in cdwValidFile */
    {
    struct cdwFastqFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID in this table */
    unsigned fileId;	/* ID in cdwFile table */
    long long sampleCount;	/* # of reads in sample. */
    long long basesInSample;	/* # of bases in sample. */
    char *sampleFileName;	/* Name of file containing sampleCount randomly selected items from file. */
    long long readCount;	/* # of reads in file */
    long long baseCount;	/* # of bases in all reads added up */
    double readSizeMean;	/* Average read size */
    double readSizeStd;	/* Standard deviation of read size */
    int readSizeMin;	/* Minimum read size */
    int readSizeMax;	/* Maximum read size */
    double qualMean;	/* Mean quality scored as 10*-log10(errorProbability) or close to it.  >25 is good */
    double qualStd;	/* Standard deviation of quality */
    double qualMin;	/* Minimum observed quality */
    double qualMax;	/* Maximum observed quality */
    char *qualType;	/* For fastq files either 'sanger' or 'illumina' */
    int qualZero;	/* For fastq files offset to get to zero value in ascii encoding */
    double atRatio;	/* Ratio of A+T to total sequence (not including Ns) */
    double aRatio;	/* Ratio of A to total sequence (including Ns) */
    double cRatio;	/* Ratio of C to total sequence (including Ns) */
    double gRatio;	/* Ratio of G to total sequence (including Ns) */
    double tRatio;	/* Ratio of T to total sequence (including Ns) */
    double nRatio;	/* Ratio of N or . to total sequence */
    double *qualPos;	/* Mean value for each position in a read up to some max. */
    double *aAtPos;	/* % of As at each pos */
    double *cAtPos;	/* % of Cs at each pos */
    double *gAtPos;	/* % of Gs at each pos */
    double *tAtPos;	/* % of Ts at each pos */
    double *nAtPos;	/* % of '.' or 'N' at each pos */
    };

struct cdwFastqFile *cdwFastqFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwFastqFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwFastqFileFreeList(). */

void cdwFastqFileSaveToDb(struct sqlConnection *conn, struct cdwFastqFile *el, char *tableName, int updateSize);
/* Save cdwFastqFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwFastqFile *cdwFastqFileLoad(char **row);
/* Load a cdwFastqFile from row fetched with select * from cdwFastqFile
 * from database.  Dispose of this with cdwFastqFileFree(). */

struct cdwFastqFile *cdwFastqFileLoadAll(char *fileName);
/* Load all cdwFastqFile from whitespace-separated file.
 * Dispose of this with cdwFastqFileFreeList(). */

struct cdwFastqFile *cdwFastqFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwFastqFile from chopper separated file.
 * Dispose of this with cdwFastqFileFreeList(). */

#define cdwFastqFileLoadAllByTab(a) cdwFastqFileLoadAllByChar(a, '\t');
/* Load all cdwFastqFile from tab separated file.
 * Dispose of this with cdwFastqFileFreeList(). */

struct cdwFastqFile *cdwFastqFileCommaIn(char **pS, struct cdwFastqFile *ret);
/* Create a cdwFastqFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwFastqFile */

void cdwFastqFileFree(struct cdwFastqFile **pEl);
/* Free a single dynamically allocated cdwFastqFile such as created
 * with cdwFastqFileLoad(). */

void cdwFastqFileFreeList(struct cdwFastqFile **pList);
/* Free a list of dynamically allocated cdwFastqFile's */

void cdwFastqFileOutput(struct cdwFastqFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwFastqFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwFastqFileTabOut(el,f) cdwFastqFileOutput(el,f,'\t','\n');
/* Print out cdwFastqFile as a line in a tab-separated file. */

#define cdwFastqFileCommaOut(el,f) cdwFastqFileOutput(el,f,',',',');
/* Print out cdwFastqFile as a comma separated list including final comma. */

#define CDWBAMFILE_NUM_COLS 17

extern char *cdwBamFileCommaSepFieldNames;

struct cdwBamFile
/* Info on what is in a bam file beyond whet's in cdwValidFile */
    {
    struct cdwBamFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID in this table */
    unsigned fileId;	/* ID in cdwFile table. */
    signed char isPaired;	/* Set to 1 if paired reads, 0 if single */
    signed char isSortedByTarget;	/* Set to 1 if sorted by target,pos */
    long long readCount;	/* # of reads in file */
    long long readBaseCount;	/* # of bases in all reads added up */
    long long mappedCount;	/* # of reads that map */
    long long uniqueMappedCount;	/* # of reads that map to a unique position */
    double readSizeMean;	/* Average read size */
    double readSizeStd;	/* Standard deviation of read size */
    int readSizeMin;	/* Minimum read size */
    int readSizeMax;	/* Maximum read size */
    int u4mReadCount;	/* Uniquely-mapped 4 million read actual read # (usually 4M) */
    int u4mUniquePos;	/* Unique positions in target of the 4M reads that map to single pos */
    double u4mUniqueRatio;	/* u4mUniqPos/u4mReadCount - measures library diversity */
    long long targetBaseCount;	/* Count of bases in mapping target */
    unsigned targetSeqCount;	/* Number of chromosomes or other distinct sequences in mapping target */
    };

void cdwBamFileStaticLoad(char **row, struct cdwBamFile *ret);
/* Load a row from cdwBamFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwBamFile *cdwBamFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwBamFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwBamFileFreeList(). */

void cdwBamFileSaveToDb(struct sqlConnection *conn, struct cdwBamFile *el, char *tableName, int updateSize);
/* Save cdwBamFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwBamFile *cdwBamFileLoad(char **row);
/* Load a cdwBamFile from row fetched with select * from cdwBamFile
 * from database.  Dispose of this with cdwBamFileFree(). */

struct cdwBamFile *cdwBamFileLoadAll(char *fileName);
/* Load all cdwBamFile from whitespace-separated file.
 * Dispose of this with cdwBamFileFreeList(). */

struct cdwBamFile *cdwBamFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwBamFile from chopper separated file.
 * Dispose of this with cdwBamFileFreeList(). */

#define cdwBamFileLoadAllByTab(a) cdwBamFileLoadAllByChar(a, '\t');
/* Load all cdwBamFile from tab separated file.
 * Dispose of this with cdwBamFileFreeList(). */

struct cdwBamFile *cdwBamFileCommaIn(char **pS, struct cdwBamFile *ret);
/* Create a cdwBamFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwBamFile */

void cdwBamFileFree(struct cdwBamFile **pEl);
/* Free a single dynamically allocated cdwBamFile such as created
 * with cdwBamFileLoad(). */

void cdwBamFileFreeList(struct cdwBamFile **pList);
/* Free a list of dynamically allocated cdwBamFile's */

void cdwBamFileOutput(struct cdwBamFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwBamFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwBamFileTabOut(el,f) cdwBamFileOutput(el,f,'\t','\n');
/* Print out cdwBamFile as a line in a tab-separated file. */

#define cdwBamFileCommaOut(el,f) cdwBamFileOutput(el,f,',',',');
/* Print out cdwBamFile as a comma separated list including final comma. */

#define CDWVCFFILE_NUM_COLS 25

extern char *cdwVcfFileCommaSepFieldNames;

struct cdwVcfFile
/* Info on what is in a vcf file beyond whet's in cdwValidFile */
    {
    struct cdwVcfFile *next;  /* Next in singly linked list. */
    unsigned id;	/* ID in this table */
    unsigned fileId;	/* ID in cdwFile table. */
    int vcfMajorVersion;	/* VCF file major version */
    int vcfMinorVersion;	/* VCF file minor version */
    int genotypeCount;	/* How many genotypes of data */
    long long itemCount;	/* Number of records in VCF file */
    int chromsHit;	/* Number of chromosomes (or contigs) with data */
    long long passItemCount;	/* Number of records that PASS listed filter */
    double passRatio;	/* passItemCount/itemCount */
    long long snpItemCount;	/* Number of records that are just single base substitution, no indels */
    double snpRatio;	/* snpItemCount/itemCount */
    long long sumOfSizes;	/* The sum of sizes of all records */
    long long basesCovered;	/* Bases with data. Equals sumOfSizes if no overlap of records. */
    int xBasesCovered;	/* Number of bases of chrX covered */
    int yBasesCovered;	/* Number of bases of chrY covered */
    int mBasesCovered;	/* Number of bases of chrM covered */
    long long haploidCount;	/* Number of genotype calls that are haploid */
    double haploidRatio;	/* Ratio of hapload to total calls */
    long long phasedCount;	/* Number of genotype calls that are phased */
    double phasedRatio;	/* Ration of phased calls to total calls */
    signed char gotDepth;	/* If true then have DP value in file and in depth stats below */
    double depthMin;	/* Min DP reported depth */
    double depthMean;	/* Mean DP value */
    double depthMax;	/* Max DP value */
    double depthStd;	/* Standard DP deviation */
    };

void cdwVcfFileStaticLoad(char **row, struct cdwVcfFile *ret);
/* Load a row from cdwVcfFile table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwVcfFile *cdwVcfFileLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwVcfFile from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwVcfFileFreeList(). */

void cdwVcfFileSaveToDb(struct sqlConnection *conn, struct cdwVcfFile *el, char *tableName, int updateSize);
/* Save cdwVcfFile as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwVcfFile *cdwVcfFileLoad(char **row);
/* Load a cdwVcfFile from row fetched with select * from cdwVcfFile
 * from database.  Dispose of this with cdwVcfFileFree(). */

struct cdwVcfFile *cdwVcfFileLoadAll(char *fileName);
/* Load all cdwVcfFile from whitespace-separated file.
 * Dispose of this with cdwVcfFileFreeList(). */

struct cdwVcfFile *cdwVcfFileLoadAllByChar(char *fileName, char chopper);
/* Load all cdwVcfFile from chopper separated file.
 * Dispose of this with cdwVcfFileFreeList(). */

#define cdwVcfFileLoadAllByTab(a) cdwVcfFileLoadAllByChar(a, '\t');
/* Load all cdwVcfFile from tab separated file.
 * Dispose of this with cdwVcfFileFreeList(). */

struct cdwVcfFile *cdwVcfFileCommaIn(char **pS, struct cdwVcfFile *ret);
/* Create a cdwVcfFile out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwVcfFile */

void cdwVcfFileFree(struct cdwVcfFile **pEl);
/* Free a single dynamically allocated cdwVcfFile such as created
 * with cdwVcfFileLoad(). */

void cdwVcfFileFreeList(struct cdwVcfFile **pList);
/* Free a list of dynamically allocated cdwVcfFile's */

void cdwVcfFileOutput(struct cdwVcfFile *el, FILE *f, char sep, char lastSep);
/* Print out cdwVcfFile.  Separate fields with sep. Follow last field with lastSep. */

#define cdwVcfFileTabOut(el,f) cdwVcfFileOutput(el,f,'\t','\n');
/* Print out cdwVcfFile as a line in a tab-separated file. */

#define cdwVcfFileCommaOut(el,f) cdwVcfFileOutput(el,f,',',',');
/* Print out cdwVcfFile as a comma separated list including final comma. */

#define CDWQAFAIL_NUM_COLS 4

extern char *cdwQaFailCommaSepFieldNames;

struct cdwQaFail
/* Record of a QA failure. */
    {
    struct cdwQaFail *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of failure */
    unsigned fileId;	/* File that failed */
    unsigned qaVersion;	/* QA pipeline version */
    char *reason;	/* reason for failure */
    };

void cdwQaFailStaticLoad(char **row, struct cdwQaFail *ret);
/* Load a row from cdwQaFail table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaFail *cdwQaFailLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaFail from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaFailFreeList(). */

void cdwQaFailSaveToDb(struct sqlConnection *conn, struct cdwQaFail *el, char *tableName, int updateSize);
/* Save cdwQaFail as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaFail *cdwQaFailLoad(char **row);
/* Load a cdwQaFail from row fetched with select * from cdwQaFail
 * from database.  Dispose of this with cdwQaFailFree(). */

struct cdwQaFail *cdwQaFailLoadAll(char *fileName);
/* Load all cdwQaFail from whitespace-separated file.
 * Dispose of this with cdwQaFailFreeList(). */

struct cdwQaFail *cdwQaFailLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaFail from chopper separated file.
 * Dispose of this with cdwQaFailFreeList(). */

#define cdwQaFailLoadAllByTab(a) cdwQaFailLoadAllByChar(a, '\t');
/* Load all cdwQaFail from tab separated file.
 * Dispose of this with cdwQaFailFreeList(). */

struct cdwQaFail *cdwQaFailCommaIn(char **pS, struct cdwQaFail *ret);
/* Create a cdwQaFail out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaFail */

void cdwQaFailFree(struct cdwQaFail **pEl);
/* Free a single dynamically allocated cdwQaFail such as created
 * with cdwQaFailLoad(). */

void cdwQaFailFreeList(struct cdwQaFail **pList);
/* Free a list of dynamically allocated cdwQaFail's */

void cdwQaFailOutput(struct cdwQaFail *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaFail.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaFailTabOut(el,f) cdwQaFailOutput(el,f,'\t','\n');
/* Print out cdwQaFail as a line in a tab-separated file. */

#define cdwQaFailCommaOut(el,f) cdwQaFailOutput(el,f,',',',');
/* Print out cdwQaFail as a comma separated list including final comma. */

#define CDWQAENRICHTARGET_NUM_COLS 5

extern char *cdwQaEnrichTargetCommaSepFieldNames;

struct cdwQaEnrichTarget
/* A target for our enrichment analysis. */
    {
    struct cdwQaEnrichTarget *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this enrichment target */
    unsigned assemblyId;	/* Which assembly this goes to */
    char *name;	/* Something like 'exon' or 'promoter' */
    unsigned fileId;	/* A simple BED 3 format file that defines target. Bases covered are unique */
    long long targetSize;	/* Total number of bases covered by target */
    };

void cdwQaEnrichTargetStaticLoad(char **row, struct cdwQaEnrichTarget *ret);
/* Load a row from cdwQaEnrichTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaEnrichTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */

void cdwQaEnrichTargetSaveToDb(struct sqlConnection *conn, struct cdwQaEnrichTarget *el, char *tableName, int updateSize);
/* Save cdwQaEnrichTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoad(char **row);
/* Load a cdwQaEnrichTarget from row fetched with select * from cdwQaEnrichTarget
 * from database.  Dispose of this with cdwQaEnrichTargetFree(). */

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadAll(char *fileName);
/* Load all cdwQaEnrichTarget from whitespace-separated file.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */

struct cdwQaEnrichTarget *cdwQaEnrichTargetLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaEnrichTarget from chopper separated file.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */

#define cdwQaEnrichTargetLoadAllByTab(a) cdwQaEnrichTargetLoadAllByChar(a, '\t');
/* Load all cdwQaEnrichTarget from tab separated file.
 * Dispose of this with cdwQaEnrichTargetFreeList(). */

struct cdwQaEnrichTarget *cdwQaEnrichTargetCommaIn(char **pS, struct cdwQaEnrichTarget *ret);
/* Create a cdwQaEnrichTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaEnrichTarget */

void cdwQaEnrichTargetFree(struct cdwQaEnrichTarget **pEl);
/* Free a single dynamically allocated cdwQaEnrichTarget such as created
 * with cdwQaEnrichTargetLoad(). */

void cdwQaEnrichTargetFreeList(struct cdwQaEnrichTarget **pList);
/* Free a list of dynamically allocated cdwQaEnrichTarget's */

void cdwQaEnrichTargetOutput(struct cdwQaEnrichTarget *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaEnrichTarget.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaEnrichTargetTabOut(el,f) cdwQaEnrichTargetOutput(el,f,'\t','\n');
/* Print out cdwQaEnrichTarget as a line in a tab-separated file. */

#define cdwQaEnrichTargetCommaOut(el,f) cdwQaEnrichTargetOutput(el,f,',',',');
/* Print out cdwQaEnrichTarget as a comma separated list including final comma. */

#define CDWQAENRICH_NUM_COLS 8

extern char *cdwQaEnrichCommaSepFieldNames;

struct cdwQaEnrich
/* An enrichment analysis applied to file. */
    {
    struct cdwQaEnrich *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this enrichment analysis */
    unsigned fileId;	/* File we are looking at skeptically */
    unsigned qaEnrichTargetId;	/* Information about a target for this analysis */
    long long targetBaseHits;	/* Number of hits to bases in target */
    long long targetUniqHits;	/* Number of unique bases hit in target */
    double coverage;	/* Coverage of target - just targetUniqHits/targetSize */
    double enrichment;	/* Amount we hit target/amount we hit genome */
    double uniqEnrich;	/* coverage/sampleCoverage */
    };

void cdwQaEnrichStaticLoad(char **row, struct cdwQaEnrich *ret);
/* Load a row from cdwQaEnrich table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaEnrich *cdwQaEnrichLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaEnrich from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaEnrichFreeList(). */

void cdwQaEnrichSaveToDb(struct sqlConnection *conn, struct cdwQaEnrich *el, char *tableName, int updateSize);
/* Save cdwQaEnrich as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaEnrich *cdwQaEnrichLoad(char **row);
/* Load a cdwQaEnrich from row fetched with select * from cdwQaEnrich
 * from database.  Dispose of this with cdwQaEnrichFree(). */

struct cdwQaEnrich *cdwQaEnrichLoadAll(char *fileName);
/* Load all cdwQaEnrich from whitespace-separated file.
 * Dispose of this with cdwQaEnrichFreeList(). */

struct cdwQaEnrich *cdwQaEnrichLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaEnrich from chopper separated file.
 * Dispose of this with cdwQaEnrichFreeList(). */

#define cdwQaEnrichLoadAllByTab(a) cdwQaEnrichLoadAllByChar(a, '\t');
/* Load all cdwQaEnrich from tab separated file.
 * Dispose of this with cdwQaEnrichFreeList(). */

struct cdwQaEnrich *cdwQaEnrichCommaIn(char **pS, struct cdwQaEnrich *ret);
/* Create a cdwQaEnrich out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaEnrich */

void cdwQaEnrichFree(struct cdwQaEnrich **pEl);
/* Free a single dynamically allocated cdwQaEnrich such as created
 * with cdwQaEnrichLoad(). */

void cdwQaEnrichFreeList(struct cdwQaEnrich **pList);
/* Free a list of dynamically allocated cdwQaEnrich's */

void cdwQaEnrichOutput(struct cdwQaEnrich *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaEnrich.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaEnrichTabOut(el,f) cdwQaEnrichOutput(el,f,'\t','\n');
/* Print out cdwQaEnrich as a line in a tab-separated file. */

#define cdwQaEnrichCommaOut(el,f) cdwQaEnrichOutput(el,f,',',',');
/* Print out cdwQaEnrich as a comma separated list including final comma. */

#define CDWQACONTAMTARGET_NUM_COLS 2

extern char *cdwQaContamTargetCommaSepFieldNames;

struct cdwQaContamTarget
/* A target for our contamination analysis. */
    {
    struct cdwQaContamTarget *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this contamination target */
    unsigned assemblyId;	/* Assembly we're aligning against to check  for contamination. */
    };

void cdwQaContamTargetStaticLoad(char **row, struct cdwQaContamTarget *ret);
/* Load a row from cdwQaContamTarget table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaContamTarget *cdwQaContamTargetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaContamTarget from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaContamTargetFreeList(). */

void cdwQaContamTargetSaveToDb(struct sqlConnection *conn, struct cdwQaContamTarget *el, char *tableName, int updateSize);
/* Save cdwQaContamTarget as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaContamTarget *cdwQaContamTargetLoad(char **row);
/* Load a cdwQaContamTarget from row fetched with select * from cdwQaContamTarget
 * from database.  Dispose of this with cdwQaContamTargetFree(). */

struct cdwQaContamTarget *cdwQaContamTargetLoadAll(char *fileName);
/* Load all cdwQaContamTarget from whitespace-separated file.
 * Dispose of this with cdwQaContamTargetFreeList(). */

struct cdwQaContamTarget *cdwQaContamTargetLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaContamTarget from chopper separated file.
 * Dispose of this with cdwQaContamTargetFreeList(). */

#define cdwQaContamTargetLoadAllByTab(a) cdwQaContamTargetLoadAllByChar(a, '\t');
/* Load all cdwQaContamTarget from tab separated file.
 * Dispose of this with cdwQaContamTargetFreeList(). */

struct cdwQaContamTarget *cdwQaContamTargetCommaIn(char **pS, struct cdwQaContamTarget *ret);
/* Create a cdwQaContamTarget out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaContamTarget */

void cdwQaContamTargetFree(struct cdwQaContamTarget **pEl);
/* Free a single dynamically allocated cdwQaContamTarget such as created
 * with cdwQaContamTargetLoad(). */

void cdwQaContamTargetFreeList(struct cdwQaContamTarget **pList);
/* Free a list of dynamically allocated cdwQaContamTarget's */

void cdwQaContamTargetOutput(struct cdwQaContamTarget *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaContamTarget.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaContamTargetTabOut(el,f) cdwQaContamTargetOutput(el,f,'\t','\n');
/* Print out cdwQaContamTarget as a line in a tab-separated file. */

#define cdwQaContamTargetCommaOut(el,f) cdwQaContamTargetOutput(el,f,',',',');
/* Print out cdwQaContamTarget as a comma separated list including final comma. */

#define CDWQACONTAM_NUM_COLS 4

extern char *cdwQaContamCommaSepFieldNames;

struct cdwQaContam
/* Results of contamination analysis of one file against one target */
    {
    struct cdwQaContam *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this contamination analysis */
    unsigned fileId;	/* File we are looking at skeptically */
    unsigned qaContamTargetId;	/* Information about a target for this analysis */
    double mapRatio;	/* Proportion of items that map to target */
    };

void cdwQaContamStaticLoad(char **row, struct cdwQaContam *ret);
/* Load a row from cdwQaContam table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaContam *cdwQaContamLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaContam from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaContamFreeList(). */

void cdwQaContamSaveToDb(struct sqlConnection *conn, struct cdwQaContam *el, char *tableName, int updateSize);
/* Save cdwQaContam as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaContam *cdwQaContamLoad(char **row);
/* Load a cdwQaContam from row fetched with select * from cdwQaContam
 * from database.  Dispose of this with cdwQaContamFree(). */

struct cdwQaContam *cdwQaContamLoadAll(char *fileName);
/* Load all cdwQaContam from whitespace-separated file.
 * Dispose of this with cdwQaContamFreeList(). */

struct cdwQaContam *cdwQaContamLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaContam from chopper separated file.
 * Dispose of this with cdwQaContamFreeList(). */

#define cdwQaContamLoadAllByTab(a) cdwQaContamLoadAllByChar(a, '\t');
/* Load all cdwQaContam from tab separated file.
 * Dispose of this with cdwQaContamFreeList(). */

struct cdwQaContam *cdwQaContamCommaIn(char **pS, struct cdwQaContam *ret);
/* Create a cdwQaContam out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaContam */

void cdwQaContamFree(struct cdwQaContam **pEl);
/* Free a single dynamically allocated cdwQaContam such as created
 * with cdwQaContamLoad(). */

void cdwQaContamFreeList(struct cdwQaContam **pList);
/* Free a list of dynamically allocated cdwQaContam's */

void cdwQaContamOutput(struct cdwQaContam *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaContam.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaContamTabOut(el,f) cdwQaContamOutput(el,f,'\t','\n');
/* Print out cdwQaContam as a line in a tab-separated file. */

#define cdwQaContamCommaOut(el,f) cdwQaContamOutput(el,f,',',',');
/* Print out cdwQaContam as a comma separated list including final comma. */

#define CDWQAREPEAT_NUM_COLS 4

extern char *cdwQaRepeatCommaSepFieldNames;

struct cdwQaRepeat
/* What percentage of data set aligns to various repeat classes. */
    {
    struct cdwQaRepeat *next;  /* Next in singly linked list. */
    unsigned id;	/* ID of this repeat analysis. */
    unsigned fileId;	/* File we are analysing. */
    char *repeatClass;	/* RepeatMasker high end classification,  or 'total' for all repeats. */
    double mapRatio;	/* Proportion that map to this repeat. */
    };

void cdwQaRepeatStaticLoad(char **row, struct cdwQaRepeat *ret);
/* Load a row from cdwQaRepeat table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaRepeat *cdwQaRepeatLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaRepeat from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaRepeatFreeList(). */

void cdwQaRepeatSaveToDb(struct sqlConnection *conn, struct cdwQaRepeat *el, char *tableName, int updateSize);
/* Save cdwQaRepeat as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaRepeat *cdwQaRepeatLoad(char **row);
/* Load a cdwQaRepeat from row fetched with select * from cdwQaRepeat
 * from database.  Dispose of this with cdwQaRepeatFree(). */

struct cdwQaRepeat *cdwQaRepeatLoadAll(char *fileName);
/* Load all cdwQaRepeat from whitespace-separated file.
 * Dispose of this with cdwQaRepeatFreeList(). */

struct cdwQaRepeat *cdwQaRepeatLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaRepeat from chopper separated file.
 * Dispose of this with cdwQaRepeatFreeList(). */

#define cdwQaRepeatLoadAllByTab(a) cdwQaRepeatLoadAllByChar(a, '\t');
/* Load all cdwQaRepeat from tab separated file.
 * Dispose of this with cdwQaRepeatFreeList(). */

struct cdwQaRepeat *cdwQaRepeatCommaIn(char **pS, struct cdwQaRepeat *ret);
/* Create a cdwQaRepeat out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaRepeat */

void cdwQaRepeatFree(struct cdwQaRepeat **pEl);
/* Free a single dynamically allocated cdwQaRepeat such as created
 * with cdwQaRepeatLoad(). */

void cdwQaRepeatFreeList(struct cdwQaRepeat **pList);
/* Free a list of dynamically allocated cdwQaRepeat's */

void cdwQaRepeatOutput(struct cdwQaRepeat *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaRepeat.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaRepeatTabOut(el,f) cdwQaRepeatOutput(el,f,'\t','\n');
/* Print out cdwQaRepeat as a line in a tab-separated file. */

#define cdwQaRepeatCommaOut(el,f) cdwQaRepeatOutput(el,f,',',',');
/* Print out cdwQaRepeat as a comma separated list including final comma. */

#define CDWQAPAIRSAMPLEOVERLAP_NUM_COLS 7

extern char *cdwQaPairSampleOverlapCommaSepFieldNames;

struct cdwQaPairSampleOverlap
/* A comparison of the amount of overlap between two samples that cover ~0.1% to 10% of target. */
    {
    struct cdwQaPairSampleOverlap *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this qa pair */
    unsigned elderFileId;	/* Id of elder (smaller fileId) in correlated pair */
    unsigned youngerFileId;	/* Id of younger (larger fileId) in correlated pair */
    long long elderSampleBases;	/* Number of bases in elder sample */
    long long youngerSampleBases;	/* Number of bases in younger sample */
    long long sampleOverlapBases;	/* Number of bases that overlap between younger and elder sample */
    double sampleSampleEnrichment;	/* Amount samples overlap more than expected. */
    };

void cdwQaPairSampleOverlapStaticLoad(char **row, struct cdwQaPairSampleOverlap *ret);
/* Load a row from cdwQaPairSampleOverlap table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaPairSampleOverlap from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */

void cdwQaPairSampleOverlapSaveToDb(struct sqlConnection *conn, struct cdwQaPairSampleOverlap *el, char *tableName, int updateSize);
/* Save cdwQaPairSampleOverlap as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoad(char **row);
/* Load a cdwQaPairSampleOverlap from row fetched with select * from cdwQaPairSampleOverlap
 * from database.  Dispose of this with cdwQaPairSampleOverlapFree(). */

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadAll(char *fileName);
/* Load all cdwQaPairSampleOverlap from whitespace-separated file.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaPairSampleOverlap from chopper separated file.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */

#define cdwQaPairSampleOverlapLoadAllByTab(a) cdwQaPairSampleOverlapLoadAllByChar(a, '\t');
/* Load all cdwQaPairSampleOverlap from tab separated file.
 * Dispose of this with cdwQaPairSampleOverlapFreeList(). */

struct cdwQaPairSampleOverlap *cdwQaPairSampleOverlapCommaIn(char **pS, struct cdwQaPairSampleOverlap *ret);
/* Create a cdwQaPairSampleOverlap out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairSampleOverlap */

void cdwQaPairSampleOverlapFree(struct cdwQaPairSampleOverlap **pEl);
/* Free a single dynamically allocated cdwQaPairSampleOverlap such as created
 * with cdwQaPairSampleOverlapLoad(). */

void cdwQaPairSampleOverlapFreeList(struct cdwQaPairSampleOverlap **pList);
/* Free a list of dynamically allocated cdwQaPairSampleOverlap's */

void cdwQaPairSampleOverlapOutput(struct cdwQaPairSampleOverlap *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaPairSampleOverlap.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaPairSampleOverlapTabOut(el,f) cdwQaPairSampleOverlapOutput(el,f,'\t','\n');
/* Print out cdwQaPairSampleOverlap as a line in a tab-separated file. */

#define cdwQaPairSampleOverlapCommaOut(el,f) cdwQaPairSampleOverlapOutput(el,f,',',',');
/* Print out cdwQaPairSampleOverlap as a comma separated list including final comma. */

#define CDWQAPAIRCORRELATION_NUM_COLS 6

extern char *cdwQaPairCorrelationCommaSepFieldNames;

struct cdwQaPairCorrelation
/* A correlation between two files of the same type. */
    {
    struct cdwQaPairCorrelation *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this correlation pair */
    unsigned elderFileId;	/* Id of elder (smaller fileId) in correlated pair */
    unsigned youngerFileId;	/* Id of younger (larger fileId) in correlated pair */
    double pearsonInEnriched;	/* Pearson's R inside enriched areas where there is overlap */
    double pearsonOverall;	/* Pearson's R over all places where both have data */
    double pearsonClipped;	/* Pearson's R clipped at two standard deviations up from the mean */
    };

void cdwQaPairCorrelationStaticLoad(char **row, struct cdwQaPairCorrelation *ret);
/* Load a row from cdwQaPairCorrelation table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaPairCorrelation from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */

void cdwQaPairCorrelationSaveToDb(struct sqlConnection *conn, struct cdwQaPairCorrelation *el, char *tableName, int updateSize);
/* Save cdwQaPairCorrelation as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoad(char **row);
/* Load a cdwQaPairCorrelation from row fetched with select * from cdwQaPairCorrelation
 * from database.  Dispose of this with cdwQaPairCorrelationFree(). */

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadAll(char *fileName);
/* Load all cdwQaPairCorrelation from whitespace-separated file.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */

struct cdwQaPairCorrelation *cdwQaPairCorrelationLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaPairCorrelation from chopper separated file.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */

#define cdwQaPairCorrelationLoadAllByTab(a) cdwQaPairCorrelationLoadAllByChar(a, '\t');
/* Load all cdwQaPairCorrelation from tab separated file.
 * Dispose of this with cdwQaPairCorrelationFreeList(). */

struct cdwQaPairCorrelation *cdwQaPairCorrelationCommaIn(char **pS, struct cdwQaPairCorrelation *ret);
/* Create a cdwQaPairCorrelation out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairCorrelation */

void cdwQaPairCorrelationFree(struct cdwQaPairCorrelation **pEl);
/* Free a single dynamically allocated cdwQaPairCorrelation such as created
 * with cdwQaPairCorrelationLoad(). */

void cdwQaPairCorrelationFreeList(struct cdwQaPairCorrelation **pList);
/* Free a list of dynamically allocated cdwQaPairCorrelation's */

void cdwQaPairCorrelationOutput(struct cdwQaPairCorrelation *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaPairCorrelation.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaPairCorrelationTabOut(el,f) cdwQaPairCorrelationOutput(el,f,'\t','\n');
/* Print out cdwQaPairCorrelation as a line in a tab-separated file. */

#define cdwQaPairCorrelationCommaOut(el,f) cdwQaPairCorrelationOutput(el,f,',',',');
/* Print out cdwQaPairCorrelation as a comma separated list including final comma. */

#define CDWQAPAIREDENDFASTQ_NUM_COLS 9

extern char *cdwQaPairedEndFastqCommaSepFieldNames;

struct cdwQaPairedEndFastq
/* Information about two paired-end fastqs */
    {
    struct cdwQaPairedEndFastq *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this set of paired end files */
    unsigned fileId1;	/* Id of first in pair */
    unsigned fileId2;	/* Id of second in pair */
    double concordance;	/* % of uniquely aligning reads where pairs nearby and point right way */
    double distanceMean;	/* Average distance between reads */
    double distanceStd;	/* Standard deviation of distance */
    double distanceMin;	/* Minimum distance */
    double distanceMax;	/* Maximum distatnce */
    signed char recordComplete;	/* Flag to avoid a race condition. Ignore record if this is 0 */
    };

void cdwQaPairedEndFastqStaticLoad(char **row, struct cdwQaPairedEndFastq *ret);
/* Load a row from cdwQaPairedEndFastq table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaPairedEndFastq from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */

void cdwQaPairedEndFastqSaveToDb(struct sqlConnection *conn, struct cdwQaPairedEndFastq *el, char *tableName, int updateSize);
/* Save cdwQaPairedEndFastq as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoad(char **row);
/* Load a cdwQaPairedEndFastq from row fetched with select * from cdwQaPairedEndFastq
 * from database.  Dispose of this with cdwQaPairedEndFastqFree(). */

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadAll(char *fileName);
/* Load all cdwQaPairedEndFastq from whitespace-separated file.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaPairedEndFastq from chopper separated file.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */

#define cdwQaPairedEndFastqLoadAllByTab(a) cdwQaPairedEndFastqLoadAllByChar(a, '\t');
/* Load all cdwQaPairedEndFastq from tab separated file.
 * Dispose of this with cdwQaPairedEndFastqFreeList(). */

struct cdwQaPairedEndFastq *cdwQaPairedEndFastqCommaIn(char **pS, struct cdwQaPairedEndFastq *ret);
/* Create a cdwQaPairedEndFastq out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaPairedEndFastq */

void cdwQaPairedEndFastqFree(struct cdwQaPairedEndFastq **pEl);
/* Free a single dynamically allocated cdwQaPairedEndFastq such as created
 * with cdwQaPairedEndFastqLoad(). */

void cdwQaPairedEndFastqFreeList(struct cdwQaPairedEndFastq **pList);
/* Free a list of dynamically allocated cdwQaPairedEndFastq's */

void cdwQaPairedEndFastqOutput(struct cdwQaPairedEndFastq *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaPairedEndFastq.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaPairedEndFastqTabOut(el,f) cdwQaPairedEndFastqOutput(el,f,'\t','\n');
/* Print out cdwQaPairedEndFastq as a line in a tab-separated file. */

#define cdwQaPairedEndFastqCommaOut(el,f) cdwQaPairedEndFastqOutput(el,f,',',',');
/* Print out cdwQaPairedEndFastq as a comma separated list including final comma. */

#define CDWQAWIGSPOT_NUM_COLS 9

extern char *cdwQaWigSpotCommaSepFieldNames;

struct cdwQaWigSpot
/* Information about proportion of signal in a wig that lands under spots in a peak or bed file */
    {
    struct cdwQaWigSpot *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this wig/spot intersection */
    unsigned wigId;	/* Id of bigWig file */
    unsigned spotId;	/* Id of a bigBed file probably broadPeak or narrowPeak */
    double spotRatio;	/* Ratio of signal in spots to total signal,  between 0 and 1 */
    double enrichment;	/* Enrichment in spots compared to genome overall */
    long long basesInGenome;	/* Number of bases in genome */
    long long basesInSpots;	/* Number of bases in spots */
    double sumSignal;	/* Total signal */
    double spotSumSignal;	/* Total signal in spots */
    };

void cdwQaWigSpotStaticLoad(char **row, struct cdwQaWigSpot *ret);
/* Load a row from cdwQaWigSpot table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaWigSpot *cdwQaWigSpotLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaWigSpot from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaWigSpotFreeList(). */

void cdwQaWigSpotSaveToDb(struct sqlConnection *conn, struct cdwQaWigSpot *el, char *tableName, int updateSize);
/* Save cdwQaWigSpot as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaWigSpot *cdwQaWigSpotLoad(char **row);
/* Load a cdwQaWigSpot from row fetched with select * from cdwQaWigSpot
 * from database.  Dispose of this with cdwQaWigSpotFree(). */

struct cdwQaWigSpot *cdwQaWigSpotLoadAll(char *fileName);
/* Load all cdwQaWigSpot from whitespace-separated file.
 * Dispose of this with cdwQaWigSpotFreeList(). */

struct cdwQaWigSpot *cdwQaWigSpotLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaWigSpot from chopper separated file.
 * Dispose of this with cdwQaWigSpotFreeList(). */

#define cdwQaWigSpotLoadAllByTab(a) cdwQaWigSpotLoadAllByChar(a, '\t');
/* Load all cdwQaWigSpot from tab separated file.
 * Dispose of this with cdwQaWigSpotFreeList(). */

struct cdwQaWigSpot *cdwQaWigSpotCommaIn(char **pS, struct cdwQaWigSpot *ret);
/* Create a cdwQaWigSpot out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaWigSpot */

void cdwQaWigSpotFree(struct cdwQaWigSpot **pEl);
/* Free a single dynamically allocated cdwQaWigSpot such as created
 * with cdwQaWigSpotLoad(). */

void cdwQaWigSpotFreeList(struct cdwQaWigSpot **pList);
/* Free a list of dynamically allocated cdwQaWigSpot's */

void cdwQaWigSpotOutput(struct cdwQaWigSpot *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaWigSpot.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaWigSpotTabOut(el,f) cdwQaWigSpotOutput(el,f,'\t','\n');
/* Print out cdwQaWigSpot as a line in a tab-separated file. */

#define cdwQaWigSpotCommaOut(el,f) cdwQaWigSpotOutput(el,f,',',',');
/* Print out cdwQaWigSpot as a comma separated list including final comma. */

#define CDWQADNASESINGLESTATS5M_NUM_COLS 18

extern char *cdwQaDnaseSingleStats5mCommaSepFieldNames;

struct cdwQaDnaseSingleStats5m
/* Statistics calculated based on a 5M sample of DNAse aligned reads from a bam file. */
    {
    struct cdwQaDnaseSingleStats5m *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this row in table. */
    unsigned fileId;	/* Id of bam file this is calculated from */
    unsigned sampleReads;	/* Number of mapped reads  */
    double spotRatio;	/* Ratio of signal in spots to total signal,  between 0 and 1 */
    double enrichment;	/* Enrichment in spots compared to genome overall */
    long long basesInGenome;	/* Number of bases in genome */
    long long basesInSpots;	/* Number of bases in spots */
    double sumSignal;	/* Total signal */
    double spotSumSignal;	/* Total signal in spots */
    char *estFragLength;	/* Up to three comma separated strand cross-correlation peaks */
    char *corrEstFragLen;	/* Up to three cross strand correlations at the given peaks */
    int phantomPeak;	/* Read length/phantom peak strand shift */
    double corrPhantomPeak;	/* Correlation value at phantom peak */
    int argMinCorr;	/* strand shift at which cross-correlation is lowest */
    double minCorr;	/* minimum value of cross-correlation */
    double nsc;	/* Normalized strand cross-correlation coefficient (NSC) = corrEstFragLen/minCorr */
    double rsc;	/* Relative strand cross-correlation coefficient (RSC) */
    int rscQualityTag;	/* based on thresholded RSC (codes: -2:veryLow,-1:Low,0:Medium,1:High,2:veryHigh) */
    };

void cdwQaDnaseSingleStats5mStaticLoad(char **row, struct cdwQaDnaseSingleStats5m *ret);
/* Load a row from cdwQaDnaseSingleStats5m table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwQaDnaseSingleStats5m from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */

void cdwQaDnaseSingleStats5mSaveToDb(struct sqlConnection *conn, struct cdwQaDnaseSingleStats5m *el, char *tableName, int updateSize);
/* Save cdwQaDnaseSingleStats5m as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoad(char **row);
/* Load a cdwQaDnaseSingleStats5m from row fetched with select * from cdwQaDnaseSingleStats5m
 * from database.  Dispose of this with cdwQaDnaseSingleStats5mFree(). */

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadAll(char *fileName);
/* Load all cdwQaDnaseSingleStats5m from whitespace-separated file.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mLoadAllByChar(char *fileName, char chopper);
/* Load all cdwQaDnaseSingleStats5m from chopper separated file.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */

#define cdwQaDnaseSingleStats5mLoadAllByTab(a) cdwQaDnaseSingleStats5mLoadAllByChar(a, '\t');
/* Load all cdwQaDnaseSingleStats5m from tab separated file.
 * Dispose of this with cdwQaDnaseSingleStats5mFreeList(). */

struct cdwQaDnaseSingleStats5m *cdwQaDnaseSingleStats5mCommaIn(char **pS, struct cdwQaDnaseSingleStats5m *ret);
/* Create a cdwQaDnaseSingleStats5m out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwQaDnaseSingleStats5m */

void cdwQaDnaseSingleStats5mFree(struct cdwQaDnaseSingleStats5m **pEl);
/* Free a single dynamically allocated cdwQaDnaseSingleStats5m such as created
 * with cdwQaDnaseSingleStats5mLoad(). */

void cdwQaDnaseSingleStats5mFreeList(struct cdwQaDnaseSingleStats5m **pList);
/* Free a list of dynamically allocated cdwQaDnaseSingleStats5m's */

void cdwQaDnaseSingleStats5mOutput(struct cdwQaDnaseSingleStats5m *el, FILE *f, char sep, char lastSep);
/* Print out cdwQaDnaseSingleStats5m.  Separate fields with sep. Follow last field with lastSep. */

#define cdwQaDnaseSingleStats5mTabOut(el,f) cdwQaDnaseSingleStats5mOutput(el,f,'\t','\n');
/* Print out cdwQaDnaseSingleStats5m as a line in a tab-separated file. */

#define cdwQaDnaseSingleStats5mCommaOut(el,f) cdwQaDnaseSingleStats5mOutput(el,f,',',',');
/* Print out cdwQaDnaseSingleStats5m as a comma separated list including final comma. */

#define CDWJOB_NUM_COLS 8

extern char *cdwJobCommaSepFieldNames;

struct cdwJob
/* A job to be run asynchronously and not too many all at once. */
    {
    struct cdwJob *next;  /* Next in singly linked list. */
    unsigned id;	/* Job id */
    char *commandLine;	/* Command line of job */
    long long startTime;	/* Start time in seconds since 1970 */
    long long endTime;	/* End time in seconds since 1970 */
    char *stderr;	/* The output to stderr of the run - may be nonempty even with success */
    int returnCode;	/* The return code from system command - 0 for success */
    int pid;	/* Process ID for running processes */
    int submitId;	/* Associated submission ID if any */
    };

void cdwJobStaticLoad(char **row, struct cdwJob *ret);
/* Load a row from cdwJob table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwJob *cdwJobLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwJob from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwJobFreeList(). */

void cdwJobSaveToDb(struct sqlConnection *conn, struct cdwJob *el, char *tableName, int updateSize);
/* Save cdwJob as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwJob *cdwJobLoad(char **row);
/* Load a cdwJob from row fetched with select * from cdwJob
 * from database.  Dispose of this with cdwJobFree(). */

struct cdwJob *cdwJobLoadAll(char *fileName);
/* Load all cdwJob from whitespace-separated file.
 * Dispose of this with cdwJobFreeList(). */

struct cdwJob *cdwJobLoadAllByChar(char *fileName, char chopper);
/* Load all cdwJob from chopper separated file.
 * Dispose of this with cdwJobFreeList(). */

#define cdwJobLoadAllByTab(a) cdwJobLoadAllByChar(a, '\t');
/* Load all cdwJob from tab separated file.
 * Dispose of this with cdwJobFreeList(). */

struct cdwJob *cdwJobCommaIn(char **pS, struct cdwJob *ret);
/* Create a cdwJob out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwJob */

void cdwJobFree(struct cdwJob **pEl);
/* Free a single dynamically allocated cdwJob such as created
 * with cdwJobLoad(). */

void cdwJobFreeList(struct cdwJob **pList);
/* Free a list of dynamically allocated cdwJob's */

void cdwJobOutput(struct cdwJob *el, FILE *f, char sep, char lastSep);
/* Print out cdwJob.  Separate fields with sep. Follow last field with lastSep. */

#define cdwJobTabOut(el,f) cdwJobOutput(el,f,'\t','\n');
/* Print out cdwJob as a line in a tab-separated file. */

#define cdwJobCommaOut(el,f) cdwJobOutput(el,f,',',',');
/* Print out cdwJob as a comma separated list including final comma. */

#define CDWTRACKVIZ_NUM_COLS 6

extern char *cdwTrackVizCommaSepFieldNames;

struct cdwTrackViz
/* Some files can be visualized as a track. Stuff to help define that track goes here. */
    {
    struct cdwTrackViz *next;  /* Next in singly linked list. */
    unsigned id;	/* Id of this row in the table */
    unsigned fileId;	/* File this is a viz of */
    char *shortLabel;	/* Up to 17 char label for track */
    char *longLabel;	/* Up to 100 char label for track */
    char *type;	/* One of the customTrack types such as bam,vcfTabix,bigWig,bigBed */
    char *bigDataFile;	/* Where big data file lives relative to cdwRootDir */
    };

void cdwTrackVizStaticLoad(char **row, struct cdwTrackViz *ret);
/* Load a row from cdwTrackViz table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwTrackViz *cdwTrackVizLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwTrackViz from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwTrackVizFreeList(). */

void cdwTrackVizSaveToDb(struct sqlConnection *conn, struct cdwTrackViz *el, char *tableName, int updateSize);
/* Save cdwTrackViz as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwTrackViz *cdwTrackVizLoad(char **row);
/* Load a cdwTrackViz from row fetched with select * from cdwTrackViz
 * from database.  Dispose of this with cdwTrackVizFree(). */

struct cdwTrackViz *cdwTrackVizLoadAll(char *fileName);
/* Load all cdwTrackViz from whitespace-separated file.
 * Dispose of this with cdwTrackVizFreeList(). */

struct cdwTrackViz *cdwTrackVizLoadAllByChar(char *fileName, char chopper);
/* Load all cdwTrackViz from chopper separated file.
 * Dispose of this with cdwTrackVizFreeList(). */

#define cdwTrackVizLoadAllByTab(a) cdwTrackVizLoadAllByChar(a, '\t');
/* Load all cdwTrackViz from tab separated file.
 * Dispose of this with cdwTrackVizFreeList(). */

struct cdwTrackViz *cdwTrackVizCommaIn(char **pS, struct cdwTrackViz *ret);
/* Create a cdwTrackViz out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwTrackViz */

void cdwTrackVizFree(struct cdwTrackViz **pEl);
/* Free a single dynamically allocated cdwTrackViz such as created
 * with cdwTrackVizLoad(). */

void cdwTrackVizFreeList(struct cdwTrackViz **pList);
/* Free a list of dynamically allocated cdwTrackViz's */

void cdwTrackVizOutput(struct cdwTrackViz *el, FILE *f, char sep, char lastSep);
/* Print out cdwTrackViz.  Separate fields with sep. Follow last field with lastSep. */

#define cdwTrackVizTabOut(el,f) cdwTrackVizOutput(el,f,'\t','\n');
/* Print out cdwTrackViz as a line in a tab-separated file. */

#define cdwTrackVizCommaOut(el,f) cdwTrackVizOutput(el,f,',',',');
/* Print out cdwTrackViz as a comma separated list including final comma. */

#define CDWDATASET_NUM_COLS 8

extern char *cdwDatasetCommaSepFieldNames;

struct cdwDataset
/* A dataset is a collection of files, usually associated with a paper */
    {
    struct cdwDataset *next;  /* Next in singly linked list. */
    unsigned id;	/* Dataset ID */
    char *name;	/* Short name of this dataset, one word, no spaces */
    char *label;	/* short title of the dataset, a few words */
    char *description;	/* Description of dataset, can be a complete html paragraph. */
    char *pmid;	/* Pubmed ID of abstract */
    char *pmcid;	/* PubmedCentral ID of paper full text */
    char *metaDivTags;	/* Comma separated list of fields used to make tree out of metadata */
    char *metaLabelTags;	/* Comma separated list of fields good to use in labels for graphs etc. */
    };

void cdwDatasetStaticLoad(char **row, struct cdwDataset *ret);
/* Load a row from cdwDataset table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwDataset *cdwDatasetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwDataset from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwDatasetFreeList(). */

void cdwDatasetSaveToDb(struct sqlConnection *conn, struct cdwDataset *el, char *tableName, int updateSize);
/* Save cdwDataset as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwDataset *cdwDatasetLoad(char **row);
/* Load a cdwDataset from row fetched with select * from cdwDataset
 * from database.  Dispose of this with cdwDatasetFree(). */

struct cdwDataset *cdwDatasetLoadAll(char *fileName);
/* Load all cdwDataset from whitespace-separated file.
 * Dispose of this with cdwDatasetFreeList(). */

struct cdwDataset *cdwDatasetLoadAllByChar(char *fileName, char chopper);
/* Load all cdwDataset from chopper separated file.
 * Dispose of this with cdwDatasetFreeList(). */

#define cdwDatasetLoadAllByTab(a) cdwDatasetLoadAllByChar(a, '\t');
/* Load all cdwDataset from tab separated file.
 * Dispose of this with cdwDatasetFreeList(). */

struct cdwDataset *cdwDatasetCommaIn(char **pS, struct cdwDataset *ret);
/* Create a cdwDataset out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwDataset */

void cdwDatasetFree(struct cdwDataset **pEl);
/* Free a single dynamically allocated cdwDataset such as created
 * with cdwDatasetLoad(). */

void cdwDatasetFreeList(struct cdwDataset **pList);
/* Free a list of dynamically allocated cdwDataset's */

void cdwDatasetOutput(struct cdwDataset *el, FILE *f, char sep, char lastSep);
/* Print out cdwDataset.  Separate fields with sep. Follow last field with lastSep. */

#define cdwDatasetTabOut(el,f) cdwDatasetOutput(el,f,'\t','\n');
/* Print out cdwDataset as a line in a tab-separated file. */

#define cdwDatasetCommaOut(el,f) cdwDatasetOutput(el,f,',',',');
/* Print out cdwDataset as a comma separated list including final comma. */

#define CDWJOINTDATASET_NUM_COLS 6

extern char *cdwJointDatasetCommaSepFieldNames;

struct cdwJointDataset
/* A joint dataset is a collection of datasets, usually associated with a common trait. */
    {
    struct cdwJointDataset *next;  /* Next in singly linked list. */
    unsigned id;	/* Dataset ID */
    char *name;	/* Short name of this dataset, one word, no spaces */
    char *label;	/* short title of the dataset, a few words */
    char *description;	/* Description of dataset, can be a complete html paragraph. */
    char *childrenNames;	/* Comma separated list of children data set names. */
    char *metaDivTags;	/* Comma separated list of fields used to make tree out of metadata */
    };

void cdwJointDatasetStaticLoad(char **row, struct cdwJointDataset *ret);
/* Load a row from cdwJointDataset table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdwJointDataset *cdwJointDatasetLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdwJointDataset from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdwJointDatasetFreeList(). */

void cdwJointDatasetSaveToDb(struct sqlConnection *conn, struct cdwJointDataset *el, char *tableName, int updateSize);
/* Save cdwJointDataset as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct cdwJointDataset *cdwJointDatasetLoad(char **row);
/* Load a cdwJointDataset from row fetched with select * from cdwJointDataset
 * from database.  Dispose of this with cdwJointDatasetFree(). */

struct cdwJointDataset *cdwJointDatasetLoadAll(char *fileName);
/* Load all cdwJointDataset from whitespace-separated file.
 * Dispose of this with cdwJointDatasetFreeList(). */

struct cdwJointDataset *cdwJointDatasetLoadAllByChar(char *fileName, char chopper);
/* Load all cdwJointDataset from chopper separated file.
 * Dispose of this with cdwJointDatasetFreeList(). */

#define cdwJointDatasetLoadAllByTab(a) cdwJointDatasetLoadAllByChar(a, '\t');
/* Load all cdwJointDataset from tab separated file.
 * Dispose of this with cdwJointDatasetFreeList(). */

struct cdwJointDataset *cdwJointDatasetCommaIn(char **pS, struct cdwJointDataset *ret);
/* Create a cdwJointDataset out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdwJointDataset */

void cdwJointDatasetFree(struct cdwJointDataset **pEl);
/* Free a single dynamically allocated cdwJointDataset such as created
 * with cdwJointDatasetLoad(). */

void cdwJointDatasetFreeList(struct cdwJointDataset **pList);
/* Free a list of dynamically allocated cdwJointDataset's */

void cdwJointDatasetOutput(struct cdwJointDataset *el, FILE *f, char sep, char lastSep);
/* Print out cdwJointDataset.  Separate fields with sep. Follow last field with lastSep. */

#define cdwJointDatasetTabOut(el,f) cdwJointDatasetOutput(el,f,'\t','\n');
/* Print out cdwJointDataset as a line in a tab-separated file. */

#define cdwJointDatasetCommaOut(el,f) cdwJointDatasetOutput(el,f,',',',');
/* Print out cdwJointDataset as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* CDW_H */

