/* Parser to read in a cdwVcfFile from a ra file where tags in ra file correspond to fields in a
 * struct. This program was generated by raToStructGen. */

#include "common.h"
#include "linefile.h"
#include "hash.h"
#include "obscure.h"
#include "sqlNum.h"
#include "sqlList.h"
#include "ra.h"
#include "raToStruct.h"
#include "cdw.h"

struct raToStructReader *cdwVcfFileRaReader()
/* Make a raToStructReader for cdwVcfFile */
{
static char *fields[] = {
    "vcfMajorVersion",
    "vcfMinorVersion",
    "genotypeCount",
    "itemCount",
    "chromsHit",
    "passItemCount",
    "passRatio",
    "snpItemCount",
    "snpRatio",
    "sumOfSizes",
    "basesCovered",
    "xBasesCovered",
    "yBasesCovered",
    "mBasesCovered",
    "haploidCount",
    "haploidRatio",
    "phasedCount",
    "phasedRatio",
    "gotDepth",
    "depthMin",
    "depthMean",
    "depthMax",
    "depthStd",
    };
static char *required[] = {
    "vcfMajorVersion",
    "vcfMinorVersion",
    "genotypeCount",
    "itemCount",
    "chromsHit",
    "passItemCount",
    "snpItemCount",
    "sumOfSizes",
    "basesCovered",
    "xBasesCovered",
    "yBasesCovered",
    "mBasesCovered",
    "gotDepth",
    };
return raToStructReaderNew("cdwVcfFile", ArraySize(fields), fields, ArraySize(required), 
    required);
}


struct cdwVcfFile *cdwVcfFileFromNextRa(struct lineFile *lf, struct raToStructReader *reader)
/* Return next stanza put into an cdwVcfFile. */
{
enum fields
    {
    vcfMajorVersionField,
    vcfMinorVersionField,
    genotypeCountField,
    itemCountField,
    chromsHitField,
    passItemCountField,
    passRatioField,
    snpItemCountField,
    snpRatioField,
    sumOfSizesField,
    basesCoveredField,
    xBasesCoveredField,
    yBasesCoveredField,
    mBasesCoveredField,
    haploidCountField,
    haploidRatioField,
    phasedCountField,
    phasedRatioField,
    gotDepthField,
    depthMinField,
    depthMeanField,
    depthMaxField,
    depthStdField,
    };
if (!raSkipLeadingEmptyLines(lf, NULL))
    return NULL;

struct cdwVcfFile *el;
AllocVar(el);

bool *fieldsObserved = reader->fieldsObserved;
bzero(fieldsObserved, reader->fieldCount);

char *tag, *val;
while (raNextTagVal(lf, &tag, &val, NULL))
    {
    struct hashEl *hel = hashLookup(reader->fieldIds, tag);
    if (hel != NULL)
        {
	int id = ptToInt(hel->val);
	if (fieldsObserved[id])
	     errAbort("Duplicate tag %s line %d of %s\n", tag, lf->lineIx, lf->fileName);
	fieldsObserved[id] = TRUE;
	switch (id)
	    {
	    case vcfMajorVersionField:
	        {
	        el->vcfMajorVersion = sqlSigned(val);
		break;
	        }
	    case vcfMinorVersionField:
	        {
	        el->vcfMinorVersion = sqlSigned(val);
		break;
	        }
	    case genotypeCountField:
	        {
	        el->genotypeCount = sqlSigned(val);
		break;
	        }
	    case itemCountField:
	        {
	        el->itemCount = sqlLongLong(val);
		break;
	        }
	    case chromsHitField:
	        {
	        el->chromsHit = sqlSigned(val);
		break;
	        }
	    case passItemCountField:
	        {
	        el->passItemCount = sqlLongLong(val);
		break;
	        }
	    case passRatioField:
	        {
	        el->passRatio = sqlDouble(val);
		break;
	        }
	    case snpItemCountField:
	        {
	        el->snpItemCount = sqlLongLong(val);
		break;
	        }
	    case snpRatioField:
	        {
	        el->snpRatio = sqlDouble(val);
		break;
	        }
	    case sumOfSizesField:
	        {
	        el->sumOfSizes = sqlLongLong(val);
		break;
	        }
	    case basesCoveredField:
	        {
	        el->basesCovered = sqlLongLong(val);
		break;
	        }
	    case xBasesCoveredField:
	        {
	        el->xBasesCovered = sqlSigned(val);
		break;
	        }
	    case yBasesCoveredField:
	        {
	        el->yBasesCovered = sqlSigned(val);
		break;
	        }
	    case mBasesCoveredField:
	        {
	        el->mBasesCovered = sqlSigned(val);
		break;
	        }
	    case haploidCountField:
	        {
	        el->haploidCount = sqlLongLong(val);
		break;
	        }
	    case haploidRatioField:
	        {
	        el->haploidRatio = sqlDouble(val);
		break;
	        }
	    case phasedCountField:
	        {
	        el->phasedCount = sqlLongLong(val);
		break;
	        }
	    case phasedRatioField:
	        {
	        el->phasedRatio = sqlDouble(val);
		break;
	        }
	    case gotDepthField:
	        {
	        el->gotDepth = sqlSigned(val);
		break;
	        }
	    case depthMinField:
	        {
	        el->depthMin = sqlDouble(val);
		break;
	        }
	    case depthMeanField:
	        {
	        el->depthMean = sqlDouble(val);
		break;
	        }
	    case depthMaxField:
	        {
	        el->depthMax = sqlDouble(val);
		break;
	        }
	    case depthStdField:
	        {
	        el->depthStd = sqlDouble(val);
		break;
	        }
	    default:
	        internalErr();
		break;
	    }
	}
    }

return el;
}

struct cdwVcfFile *cdwVcfFileLoadRa(char *fileName)
/* Return list of all cdwVcfFile in ra file. */
{
struct raToStructReader *reader = cdwVcfFileRaReader();
struct lineFile *lf = lineFileOpen(fileName, TRUE);
struct cdwVcfFile *el, *list = NULL;
while ((el = cdwVcfFileFromNextRa(lf, reader)) != NULL)
    slAddHead(&list, el);
slReverse(&list);
lineFileClose(&lf);
raToStructReaderFree(&reader);
return list;
}

struct cdwVcfFile *cdwVcfFileOneFromRa(char *fileName)
/* Return cdwVcfFile in file and insist there be exactly one record. */
{
struct cdwVcfFile *one = cdwVcfFileLoadRa(fileName);
if (one == NULL)
    errAbort("No data in %s", fileName);
if (one->next != NULL)
    errAbort("Multiple records in %s", fileName);
return one;
}

