/* models.c was originally generated by the autoSql program, which also 
 * generated models.h and models.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "models.h"



char *quakeSampleCommaSepFieldNames = "date,subdir,fluidPlateAcc,unknown1,seqFormat,sequencer,sample,user,lab,ilAcc,captureArrayBarcode,cellPos";

void quakeSampleStaticLoad(char **row, struct quakeSample *ret)
/* Load a row from quakeSample table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->date = row[0];
ret->subdir = row[1];
ret->fluidPlateAcc = row[2];
ret->unknown1 = sqlUnsigned(row[3]);
ret->seqFormat = row[4];
ret->sequencer = row[5];
ret->sample = row[6];
ret->user = row[7];
ret->lab = row[8];
ret->ilAcc = row[9];
ret->captureArrayBarcode = row[10];
ret->cellPos = row[11];
}

struct quakeSample *quakeSampleLoad(char **row)
/* Load a quakeSample from row fetched with select * from quakeSample
 * from database.  Dispose of this with quakeSampleFree(). */
{
struct quakeSample *ret;

AllocVar(ret);
ret->date = cloneString(row[0]);
ret->subdir = cloneString(row[1]);
ret->fluidPlateAcc = cloneString(row[2]);
ret->unknown1 = sqlUnsigned(row[3]);
ret->seqFormat = cloneString(row[4]);
ret->sequencer = cloneString(row[5]);
ret->sample = cloneString(row[6]);
ret->user = cloneString(row[7]);
ret->lab = cloneString(row[8]);
ret->ilAcc = cloneString(row[9]);
ret->captureArrayBarcode = cloneString(row[10]);
ret->cellPos = cloneString(row[11]);
return ret;
}

struct quakeSample *quakeSampleLoadAll(char *fileName) 
/* Load all quakeSample from a whitespace-separated file.
 * Dispose of this with quakeSampleFreeList(). */
{
struct quakeSample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = quakeSampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeSample *quakeSampleLoadAllByChar(char *fileName, char chopper) 
/* Load all quakeSample from a chopper separated file.
 * Dispose of this with quakeSampleFreeList(). */
{
struct quakeSample *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = quakeSampleLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeSample *quakeSampleCommaIn(char **pS, struct quakeSample *ret)
/* Create a quakeSample out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeSample */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->date = sqlStringComma(&s);
ret->subdir = sqlStringComma(&s);
ret->fluidPlateAcc = sqlStringComma(&s);
ret->unknown1 = sqlUnsignedComma(&s);
ret->seqFormat = sqlStringComma(&s);
ret->sequencer = sqlStringComma(&s);
ret->sample = sqlStringComma(&s);
ret->user = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
ret->ilAcc = sqlStringComma(&s);
ret->captureArrayBarcode = sqlStringComma(&s);
ret->cellPos = sqlStringComma(&s);
*pS = s;
return ret;
}

void quakeSampleFree(struct quakeSample **pEl)
/* Free a single dynamically allocated quakeSample such as created
 * with quakeSampleLoad(). */
{
struct quakeSample *el;

if ((el = *pEl) == NULL) return;
freeMem(el->date);
freeMem(el->subdir);
freeMem(el->fluidPlateAcc);
freeMem(el->seqFormat);
freeMem(el->sequencer);
freeMem(el->sample);
freeMem(el->user);
freeMem(el->lab);
freeMem(el->ilAcc);
freeMem(el->captureArrayBarcode);
freeMem(el->cellPos);
freez(pEl);
}

void quakeSampleFreeList(struct quakeSample **pList)
/* Free a list of dynamically allocated quakeSample's */
{
struct quakeSample *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    quakeSampleFree(&el);
    }
*pList = NULL;
}

void quakeSampleOutput(struct quakeSample *el, FILE *f, char sep, char lastSep) 
/* Print out quakeSample.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->date);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->subdir);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fluidPlateAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->unknown1);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seqFormat);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sequencer);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->user);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ilAcc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->captureArrayBarcode);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cellPos);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *quakeChipCommaSepFieldNames = "captureArrayBarcode,date,machineName,user,lab,sampleType,tissue,species,strain,age,targetCell,sortMethod,markers,attiRun,description";

void quakeChipStaticLoad(char **row, struct quakeChip *ret)
/* Load a row from quakeChip table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->captureArrayBarcode = row[0];
ret->date = row[1];
ret->machineName = row[2];
ret->user = row[3];
ret->lab = row[4];
ret->sampleType = row[5];
ret->tissue = row[6];
ret->species = row[7];
ret->strain = row[8];
ret->age = row[9];
ret->targetCell = row[10];
ret->sortMethod = row[11];
ret->markers = row[12];
ret->attiRun = row[13];
ret->description = row[14];
}

struct quakeChip *quakeChipLoad(char **row)
/* Load a quakeChip from row fetched with select * from quakeChip
 * from database.  Dispose of this with quakeChipFree(). */
{
struct quakeChip *ret;

AllocVar(ret);
ret->captureArrayBarcode = cloneString(row[0]);
ret->date = cloneString(row[1]);
ret->machineName = cloneString(row[2]);
ret->user = cloneString(row[3]);
ret->lab = cloneString(row[4]);
ret->sampleType = cloneString(row[5]);
ret->tissue = cloneString(row[6]);
ret->species = cloneString(row[7]);
ret->strain = cloneString(row[8]);
ret->age = cloneString(row[9]);
ret->targetCell = cloneString(row[10]);
ret->sortMethod = cloneString(row[11]);
ret->markers = cloneString(row[12]);
ret->attiRun = cloneString(row[13]);
ret->description = cloneString(row[14]);
return ret;
}

struct quakeChip *quakeChipLoadAll(char *fileName) 
/* Load all quakeChip from a whitespace-separated file.
 * Dispose of this with quakeChipFreeList(). */
{
struct quakeChip *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[15];

while (lineFileRow(lf, row))
    {
    el = quakeChipLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeChip *quakeChipLoadAllByChar(char *fileName, char chopper) 
/* Load all quakeChip from a chopper separated file.
 * Dispose of this with quakeChipFreeList(). */
{
struct quakeChip *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[15];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = quakeChipLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeChip *quakeChipCommaIn(char **pS, struct quakeChip *ret)
/* Create a quakeChip out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeChip */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->captureArrayBarcode = sqlStringComma(&s);
ret->date = sqlStringComma(&s);
ret->machineName = sqlStringComma(&s);
ret->user = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
ret->sampleType = sqlStringComma(&s);
ret->tissue = sqlStringComma(&s);
ret->species = sqlStringComma(&s);
ret->strain = sqlStringComma(&s);
ret->age = sqlStringComma(&s);
ret->targetCell = sqlStringComma(&s);
ret->sortMethod = sqlStringComma(&s);
ret->markers = sqlStringComma(&s);
ret->attiRun = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
*pS = s;
return ret;
}

void quakeChipFree(struct quakeChip **pEl)
/* Free a single dynamically allocated quakeChip such as created
 * with quakeChipLoad(). */
{
struct quakeChip *el;

if ((el = *pEl) == NULL) return;
freeMem(el->captureArrayBarcode);
freeMem(el->date);
freeMem(el->machineName);
freeMem(el->user);
freeMem(el->lab);
freeMem(el->sampleType);
freeMem(el->tissue);
freeMem(el->species);
freeMem(el->strain);
freeMem(el->age);
freeMem(el->targetCell);
freeMem(el->sortMethod);
freeMem(el->markers);
freeMem(el->attiRun);
freeMem(el->description);
freez(pEl);
}

void quakeChipFreeList(struct quakeChip **pList)
/* Free a list of dynamically allocated quakeChip's */
{
struct quakeChip *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    quakeChipFree(&el);
    }
*pList = NULL;
}

void quakeChipOutput(struct quakeChip *el, FILE *f, char sep, char lastSep) 
/* Print out quakeChip.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->captureArrayBarcode);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->date);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->machineName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->user);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tissue);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->species);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strain);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->age);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->targetCell);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sortMethod);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->markers);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->attiRun);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}


char *quakeSheetCommaSepFieldNames = "fcid,lane,sampleId,sampleRef,seqIndex,description,control,recipe,operator,SampleProject";

void quakeSheetStaticLoad(char **row, struct quakeSheet *ret)
/* Load a row from quakeSheet table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->fcid = row[0];
ret->lane = sqlSigned(row[1]);
ret->sampleId = row[2];
ret->sampleRef = row[3];
ret->seqIndex = row[4];
ret->description = row[5];
ret->control = row[6];
ret->recipe = row[7];
ret->operator = row[8];
ret->SampleProject = row[9];
}

struct quakeSheet *quakeSheetLoad(char **row)
/* Load a quakeSheet from row fetched with select * from quakeSheet
 * from database.  Dispose of this with quakeSheetFree(). */
{
struct quakeSheet *ret;

AllocVar(ret);
ret->fcid = cloneString(row[0]);
ret->lane = sqlSigned(row[1]);
ret->sampleId = cloneString(row[2]);
ret->sampleRef = cloneString(row[3]);
ret->seqIndex = cloneString(row[4]);
ret->description = cloneString(row[5]);
ret->control = cloneString(row[6]);
ret->recipe = cloneString(row[7]);
ret->operator = cloneString(row[8]);
ret->SampleProject = cloneString(row[9]);
return ret;
}

struct quakeSheet *quakeSheetLoadAll(char *fileName) 
/* Load all quakeSheet from a whitespace-separated file.
 * Dispose of this with quakeSheetFreeList(). */
{
struct quakeSheet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileRow(lf, row))
    {
    el = quakeSheetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeSheet *quakeSheetLoadAllByChar(char *fileName, char chopper) 
/* Load all quakeSheet from a chopper separated file.
 * Dispose of this with quakeSheetFreeList(). */
{
struct quakeSheet *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[10];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = quakeSheetLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct quakeSheet *quakeSheetCommaIn(char **pS, struct quakeSheet *ret)
/* Create a quakeSheet out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new quakeSheet */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->fcid = sqlStringComma(&s);
ret->lane = sqlSignedComma(&s);
ret->sampleId = sqlStringComma(&s);
ret->sampleRef = sqlStringComma(&s);
ret->seqIndex = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->control = sqlStringComma(&s);
ret->recipe = sqlStringComma(&s);
ret->operator = sqlStringComma(&s);
ret->SampleProject = sqlStringComma(&s);
*pS = s;
return ret;
}

void quakeSheetFree(struct quakeSheet **pEl)
/* Free a single dynamically allocated quakeSheet such as created
 * with quakeSheetLoad(). */
{
struct quakeSheet *el;

if ((el = *pEl) == NULL) return;
freeMem(el->fcid);
freeMem(el->sampleId);
freeMem(el->sampleRef);
freeMem(el->seqIndex);
freeMem(el->description);
freeMem(el->control);
freeMem(el->recipe);
freeMem(el->operator);
freeMem(el->SampleProject);
freez(pEl);
}

void quakeSheetFreeList(struct quakeSheet **pList)
/* Free a list of dynamically allocated quakeSheet's */
{
struct quakeSheet *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    quakeSheetFree(&el);
    }
*pList = NULL;
}

void quakeSheetOutput(struct quakeSheet *el, FILE *f, char sep, char lastSep) 
/* Print out quakeSheet.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->fcid);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->lane);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->sampleRef);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seqIndex);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->control);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->recipe);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->operator);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->SampleProject);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

