# eapDb.sql was originally generated by the autoSql program, which also 
# generated eapDb.c and eapDb.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#An analysis pipeline job to be run asynchronously and not too many all at once.
CREATE TABLE eapJob (
    id int unsigned auto_increment,	# Job id
    commandLine longblob,	# Command line of job
    startTime bigint default 0,	# Start time in seconds since 1970
    endTime bigint default 0,	# End time in seconds since 1970
    stderr longblob,	# The output to stderr of the run - may be nonempty even with success
    returnCode int default 0,	# The return code from system command - 0 for success
    cpusRequested int default 0,	# Number of CPUs to request from job control system
    parasolId varchar(255) default '',	# Parasol job id for process.
              #Indices
    PRIMARY KEY(id),
    INDEX(startTime),
    INDEX(endTime),
    INDEX(parasolId(12))
);

#Software that is tracked by the analysis pipeline.
CREATE TABLE eapSoftware (
    id int unsigned auto_increment,	# Software id
    name varchar(255) default '',	# Command line name
    url varchar(255) default '',	# Suggested reference URL
    email varchar(255) default '',	# Suggested contact email
    metaUuid char(36) default '',	# UUID into Stanford metadata system if synced
              #Indices
    PRIMARY KEY(id),
    UNIQUE(name),
    INDEX(metaUuid(16))
);

#A version of a particular piece of software
CREATE TABLE eapSwVersion (
    id int unsigned auto_increment,	# Version id
    software varchar(255) default '',	# Name field of software this is associated with
    version longblob,	# Version as carved out of program run with --version or the like
    md5 char(32) default '',	# md5 sum of executable file
    redoPriority tinyint default 0,	# -1 for routine recompile, 0 for unknown, 1 for recommended, 2 for required.
    notes longblob,	# Any notes on the version
    metaUuid char(36) default '',	# UUID into Stanford metadata system if synced
              #Indices
    PRIMARY KEY(id),
    INDEX(software),
    INDEX(md5),
    INDEX(metaUuid(16))
);

#A step in an analysis pipeline - something that takes one set of files to another
CREATE TABLE eapStep (
    id int unsigned auto_increment,	# Step id
    name varchar(255) default '',	# Name of this analysis step
    cpusRequested int default 0,	# Number of CPUs to request from job control system
    description varchar(255) default '',	# Description of step, about a sentence.
    inCount int unsigned default 0,	# Total number of inputs
    inputTypes longblob,	# List of types to go with input files
    inputFormats longblob,	# List of formats of input files
    inputDescriptions longblob,	# List of descriptions of input files
    outCount int unsigned default 0,	# Total number of outputs
    outputNamesInTempDir longblob,	# list of all output file names in output dir
    outputFormats longblob,	# list of formats of output files
    outputTypes longblob,	# list of outputType of output files
    outputDescriptions longblob,	# list of descriptions of outputs
    metaUuid char(36) default '',	# UUID into Stanford metadata system if synced
              #Indices
    PRIMARY KEY(id),
    UNIQUE(name),
    INDEX(metaUuid(16))
);

#Relates steps to the software they use
CREATE TABLE eapStepSoftware (
    id int unsigned auto_increment,	# Link id - helps give order to software within step among other things
    step varchar(255) default '',	# name of associated step
    software varchar(255) default '',	# name of associated software
              #Indices
    PRIMARY KEY(id),
    INDEX(step(24)),
    INDEX(software(24))
);

#All the versions of a step - a new row if any subcomponent is versioned too.
CREATE TABLE eapStepVersion (
    id int unsigned auto_increment,	# ID of step version -used to tie together rows in edwAnalysisStepVector
    step varchar(255) default '',	# name of associated step
    version int unsigned default 0,	# Version of given step - just increases by 1 with each change
              #Indices
    PRIMARY KEY(id)
);

#A table that is queried for list of all software versions used in a step
CREATE TABLE eapStepSwVersion (
    id int unsigned auto_increment,	# Link id - helps give order to steps in a given version
    stepVersionId int unsigned default 0,	# Key in edwAnalysisStepVersion table
    swVersionId int unsigned default 0,	# Key in edwAnalysisSwVersion table
              #Indices
    PRIMARY KEY(id)
);

#Information on an compute job that produces files by running a step.
CREATE TABLE eapRun (
    id int unsigned auto_increment,	# Analysis run ID
    jobId int unsigned default 0,	# ID in edwAnalysisJob table
    experiment char(16) default '',	# Something like ENCSR000CFA.
    analysisStep varchar(255) default '',	# Name of analysis step.  Different data can be analysed with same step
    stepVersionId int unsigned default 0,	# Keep track of versions of everything
    tempDir longblob,	# Where analysis is to be computed
    assemblyId int unsigned default 0,	# Id of assembly we are working with if analysis is all on one assembly
    jsonResult longblob,	# JSON formatted object with result for Stanford metaDatabase
    createStatus tinyint default 0,	# 1 if output files made 0 if not made, -1 if make tried and failed
    metaUuid char(36) default '',	# UUID into Stanford metadata system if synced
              #Indices
    PRIMARY KEY(id),
    INDEX(experiment),
    INDEX(metaUuid(16))
);

#Inputs to an eapAnalysis
CREATE TABLE eapInput (
    id int unsigned auto_increment,	# Input table ID
    runId int unsigned default 0,	# Which eapAnalysis this is associated with
    name varchar(255) default '',	# Input name within step
    ix int unsigned default 0,	# Inputs always potentially vectors.  Have single one with zero ix for scalar input
    fileId int unsigned default 0,	# Associated file - 0 for no file, look perhaps to val below instead.
    val longblob,	# Non-file data
              #Indices
    PRIMARY KEY(id),
    INDEX(runId)
);

#Outputs to an eapAnalysis
CREATE TABLE eapOutput (
    id int unsigned auto_increment,	# Output table ID
    runId int unsigned default 0,	# Which eapAnalysis this is associated with
    name varchar(255) default '',	# Output name within step
    ix int unsigned default 0,	# Outputs always potentially vectors. Have single one with zero ix for scalar output
    fileId int unsigned default 0,	# Associated file - 0 for no file, look perhaps to val below instead.
    val longblob,	# Non-file data
              #Indices
    PRIMARY KEY(id),
    INDEX(runId)
);

#Statistics on a BAM file that contains reads that will align in a peaky fashion - deprecated
CREATE TABLE eapPhantomPeakStats (
    fileId int unsigned default 0,	# ID of BAM file this is taken from
    numReads int unsigned default 0,	# Number of mapped reads in that file
    estFragLength varchar(255) default '',	# Up to three comma separated strand cross-correlation peaks
    corrEstFragLen varchar(255) default '',	# Up to three cross strand correlations at the given peaks
    phantomPeak int default 0,	# Read length/phantom peak strand shift
    corrPhantomPeak double default 0,	# Correlation value at phantom peak
    argMinCorr int default 0,	# strand shift at which cross-correlation is lowest
    minCorr double default 0,	# minimum value of cross-correlation
    nsc double default 0,	# Normalized strand cross-correlation coefficient (NSC) = COL4 / COL8
    rsc double default 0,	# Relative strand cross-correlation coefficient (RSC) = (COL4 - COL8) / (COL6 - COL8)A
    qualityTag int default 0,	# based on thresholded RSC (codes: -2:veryLow,-1:Low,0:Medium,1:High,2:veryHigh)
              #Indices
    PRIMARY KEY(fileId)
);
