/* barChartData.h was originally generated by the autoSql program, which also 
 * generated barChartData.c and barChartData.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef BARCHARTDATA_H
#define BARCHARTDATA_H

#include "jksql.h"
#define BARCHARTDATA_NUM_COLS 3

extern char *barChartDataCommaSepFieldNames;

struct barChartData
/* Measured value for a sample at a locus, used for barChart track details (boxplot) */
    {
    struct barChartData *next;  /* Next in singly linked list. */
    char *locus;	/* Locus identifier (e.g. gene name) */
    char *sample;	/* Sample identifier (as in barChartSample table) */
    double value;	/* Measured value (e.g. expression level) */
    };

void barChartDataStaticLoad(char **row, struct barChartData *ret);
/* Load a row from barChartData table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct barChartData *barChartDataLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all barChartData from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with barChartDataFreeList(). */

void barChartDataSaveToDb(struct sqlConnection *conn, struct barChartData *el, char *tableName, int updateSize);
/* Save barChartData as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */

struct barChartData *barChartDataLoad(char **row);
/* Load a barChartData from row fetched with select * from barChartData
 * from database.  Dispose of this with barChartDataFree(). */

struct barChartData *barChartDataLoadAll(char *fileName);
/* Load all barChartData from whitespace-separated file.
 * Dispose of this with barChartDataFreeList(). */

struct barChartData *barChartDataLoadAllByChar(char *fileName, char chopper);
/* Load all barChartData from chopper separated file.
 * Dispose of this with barChartDataFreeList(). */

#define barChartDataLoadAllByTab(a) barChartDataLoadAllByChar(a, '\t');
/* Load all barChartData from tab separated file.
 * Dispose of this with barChartDataFreeList(). */

struct barChartData *barChartDataCommaIn(char **pS, struct barChartData *ret);
/* Create a barChartData out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new barChartData */

void barChartDataFree(struct barChartData **pEl);
/* Free a single dynamically allocated barChartData such as created
 * with barChartDataLoad(). */

void barChartDataFreeList(struct barChartData **pList);
/* Free a list of dynamically allocated barChartData's */

void barChartDataOutput(struct barChartData *el, FILE *f, char sep, char lastSep);
/* Print out barChartData.  Separate fields with sep. Follow last field with lastSep. */

#define barChartDataTabOut(el,f) barChartDataOutput(el,f,'\t','\n');
/* Print out barChartData as a line in a tab-separated file. */

#define barChartDataCommaOut(el,f) barChartDataOutput(el,f,',',',');
/* Print out barChartData as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct barChartData *barChartDataLoadForLocus(struct sqlConnection *conn, char *table, char *locus);
/* Load all data for a locus */

#endif /* BARCHARTDATA_H */

