/* cogsxra.h was originally generated by the autoSql program, which also 
 * generated cogsxra.c and cogsxra.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2004 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef COGSXRA_H
#define COGSXRA_H

#define COGXRA_NUM_COLS 2

struct COGXra
/* Clusters of Orthologous Genes information */
    {
    struct COGXra *next;  /* Next in singly linked list. */
    char *name;	/* Name of COG */
    char *info;	/* COG info */
    };

void COGXraStaticLoad(char **row, struct COGXra *ret);
/* Load a row from COGXra table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct COGXra *COGXraLoad(char **row);
/* Load a COGXra from row fetched with select * from COGXra
 * from database.  Dispose of this with COGXraFree(). */

struct COGXra *COGXraLoadAll(char *fileName);
/* Load all COGXra from whitespace-separated file.
 * Dispose of this with COGXraFreeList(). */

struct COGXra *COGXraLoadAllByChar(char *fileName, char chopper);
/* Load all COGXra from chopper separated file.
 * Dispose of this with COGXraFreeList(). */

#define COGXraLoadAllByTab(a) COGXraLoadAllByChar(a, '\t');
/* Load all COGXra from tab separated file.
 * Dispose of this with COGXraFreeList(). */

struct COGXra *COGXraCommaIn(char **pS, struct COGXra *ret);
/* Create a COGXra out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new COGXra */

void COGXraFree(struct COGXra **pEl);
/* Free a single dynamically allocated COGXra such as created
 * with COGXraLoad(). */

void COGXraFreeList(struct COGXra **pList);
/* Free a list of dynamically allocated COGXra's */

void COGXraOutput(struct COGXra *el, FILE *f, char sep, char lastSep);
/* Print out COGXra.  Separate fields with sep. Follow last field with lastSep. */

#define COGXraTabOut(el,f) COGXraOutput(el,f,'\t','\n');
/* Print out COGXra as a line in a tab-separated file. */

#define COGXraCommaOut(el,f) COGXraOutput(el,f,',',',');
/* Print out COGXra as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* COGSXRA_H */

