/* dless.h was originally generated by the autoSql program, which also 
 * generated dless.c and dless.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef DLESS_H
#define DLESS_H

#define DLESS_NUM_COLS 24

struct dless
/* data for DLESS predictions */
    {
    struct dless *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome or FPC contig */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item (id) */
    float score;	/* Log-odds score (bits) */
    char type[11];	/* Type of prediction.  enum('conserved', 'gain', 'loss') */
    char *branch;	/* Branch on which element was gained or lost */
    float pConsSub;	/* P-value of conservation in subtree beneath event */
    float pConsSup;	/* P-value of conservation in rest of tree */
    float pConsSubCond;	/* Conditional P-value of conservation in subtree given total */
    float pConsSupCond;	/* Conditional P-value of conservation in rest of tree given total */
    char condApprox[8];	/* Whether approximation was used for conditional P-values.  enum('approx', 'exact') */
    float priorMeanSub;	/* Mean of prior distribution, subtree */
    float priorVarSub;	/* Variance of prior distribution, subtree */
    unsigned priorMinSub;	/* Min of 95% c.i., subtree */
    unsigned priorMaxSub;	/* Max of 95% c.i., subtree */
    float postMeanSub;	/* Mean of posterior distribution, subtree */
    float postVarSub;	/* Variance of posterior distribution, subtree */
    float priorMeanSup;	/* Mean of prior distribution, rest of tree */
    float priorVarSup;	/* Variance of prior distribution, rest of tree */
    unsigned priorMinSup;	/* Min of 95% c.i., rest of tree */
    unsigned priorMaxSup;	/* Max of 95% c.i., rest of tree */
    float postMeanSup;	/* Mean of posterior distribution, rest of tree */
    float postVarSup;	/* Variance of posterior distribution, rest of tree */
    };

void dlessStaticLoad(char **row, struct dless *ret);
/* Load a row from dless table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct dless *dlessLoad(char **row);
/* Load a dless from row fetched with select * from dless
 * from database.  Dispose of this with dlessFree(). */

struct dless *dlessLoadAll(char *fileName);
/* Load all dless from whitespace-separated file.
 * Dispose of this with dlessFreeList(). */

struct dless *dlessLoadAllByChar(char *fileName, char chopper);
/* Load all dless from chopper separated file.
 * Dispose of this with dlessFreeList(). */

#define dlessLoadAllByTab(a) dlessLoadAllByChar(a, '\t');
/* Load all dless from tab separated file.
 * Dispose of this with dlessFreeList(). */

struct dless *dlessCommaIn(char **pS, struct dless *ret);
/* Create a dless out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dless */

void dlessFree(struct dless **pEl);
/* Free a single dynamically allocated dless such as created
 * with dlessLoad(). */

void dlessFreeList(struct dless **pList);
/* Free a list of dynamically allocated dless's */

void dlessOutput(struct dless *el, FILE *f, char sep, char lastSep);
/* Print out dless.  Separate fields with sep. Follow last field with lastSep. */

#define dlessTabOut(el,f) dlessOutput(el,f,'\t','\n');
/* Print out dless as a line in a tab-separated file. */

#define dlessCommaOut(el,f) dlessOutput(el,f,',',',');
/* Print out dless as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* DLESS_H */

