/* ecAttribute.h was originally generated by the autoSql program, which also 
 * generated ecAttribute.c and ecAttribute.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2005 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef ECATTRIBUTE_H
#define ECATTRIBUTE_H

#define ECATTRIBUTE_NUM_COLS 8

struct ecAttribute
/* Enzyme Commission (EC) Attributes */
    {
    struct ecAttribute *next;  /* Next in singly linked list. */
    unsigned id;	/* unique id - autoincrement  */
    unsigned level1;	/* level 1 EC code */
    unsigned level2;	/* level 2 EC code */
    unsigned level3;	/* level 3 EC code */
    unsigned level4;	/* level 4 EC code */
    char *ec;	/* ec number (1.1.1.1) */
    char type[3];	/* attribute type (see ecAttributeCodes) */
    char *description;	/* EC attribute description */
    };

void ecAttributeStaticLoad(char **row, struct ecAttribute *ret);
/* Load a row from ecAttribute table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ecAttribute *ecAttributeLoad(char **row);
/* Load a ecAttribute from row fetched with select * from ecAttribute
 * from database.  Dispose of this with ecAttributeFree(). */

struct ecAttribute *ecAttributeLoadAll(char *fileName);
/* Load all ecAttribute from whitespace-separated file.
 * Dispose of this with ecAttributeFreeList(). */

struct ecAttribute *ecAttributeLoadAllByChar(char *fileName, char chopper);
/* Load all ecAttribute from chopper separated file.
 * Dispose of this with ecAttributeFreeList(). */

#define ecAttributeLoadAllByTab(a) ecAttributeLoadAllByChar(a, '\t');
/* Load all ecAttribute from tab separated file.
 * Dispose of this with ecAttributeFreeList(). */

struct ecAttribute *ecAttributeCommaIn(char **pS, struct ecAttribute *ret);
/* Create a ecAttribute out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ecAttribute */

void ecAttributeFree(struct ecAttribute **pEl);
/* Free a single dynamically allocated ecAttribute such as created
 * with ecAttributeLoad(). */

void ecAttributeFreeList(struct ecAttribute **pList);
/* Free a list of dynamically allocated ecAttribute's */

void ecAttributeOutput(struct ecAttribute *el, FILE *f, char sep, char lastSep);
/* Print out ecAttribute.  Separate fields with sep. Follow last field with lastSep. */

#define ecAttributeTabOut(el,f) ecAttributeOutput(el,f,'\t','\n');
/* Print out ecAttribute as a line in a tab-separated file. */

#define ecAttributeCommaOut(el,f) ecAttributeOutput(el,f,',',',');
/* Print out ecAttribute as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ECATTRIBUTE_H */

