/* hapmapAllelesOrtho.h was originally generated by the autoSql program, which also 
 * generated hapmapAllelesOrtho.c and hapmapAllelesOrtho.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2007 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef HAPMAPALLELESORTHO_H
#define HAPMAPALLELESORTHO_H

#define HAPMAPALLELESORTHO_NUM_COLS 13

struct hapmapAllelesOrtho
/* Ortho alleles for HapMap SNPs */
    {
    struct hapmapAllelesOrtho *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom (0 based) */
    unsigned chromEnd;	/* End position in chrom (1 based) */
    char *name;	/* Reference SNP identifier from dbSnp */
    unsigned score;	/* Quality score */
    char strand[2];	/* Which genomic strand contains the observed alleles */
    char *refUCSC;	/* Reference genomic */
    char *observed;	/* dbSNP polymorphism */
    char *orthoChrom;	/* Chromosome in other org */
    unsigned orthoStart;	/* Start position in other org */
    unsigned orthoEnd;	/* End position in other org */
    char orthoStrand[2];	/* Strand in other org */
    char orthoAllele[2];	/* Allele in other org */
    };

void hapmapAllelesOrthoStaticLoad(char **row, struct hapmapAllelesOrtho *ret);
/* Load a row from hapmapAllelesOrtho table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct hapmapAllelesOrtho *hapmapAllelesOrthoLoad(char **row);
/* Load a hapmapAllelesOrtho from row fetched with select * from hapmapAllelesOrtho
 * from database.  Dispose of this with hapmapAllelesOrthoFree(). */

struct hapmapAllelesOrtho *hapmapAllelesOrthoLoadAll(char *fileName);
/* Load all hapmapAllelesOrtho from whitespace-separated file.
 * Dispose of this with hapmapAllelesOrthoFreeList(). */

struct hapmapAllelesOrtho *hapmapAllelesOrthoLoadAllByChar(char *fileName, char chopper);
/* Load all hapmapAllelesOrtho from chopper separated file.
 * Dispose of this with hapmapAllelesOrthoFreeList(). */

#define hapmapAllelesOrthoLoadAllByTab(a) hapmapAllelesOrthoLoadAllByChar(a, '\t');
/* Load all hapmapAllelesOrtho from tab separated file.
 * Dispose of this with hapmapAllelesOrthoFreeList(). */

struct hapmapAllelesOrtho *hapmapAllelesOrthoCommaIn(char **pS, struct hapmapAllelesOrtho *ret);
/* Create a hapmapAllelesOrtho out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapAllelesOrtho */

void hapmapAllelesOrthoFree(struct hapmapAllelesOrtho **pEl);
/* Free a single dynamically allocated hapmapAllelesOrtho such as created
 * with hapmapAllelesOrthoLoad(). */

void hapmapAllelesOrthoFreeList(struct hapmapAllelesOrtho **pList);
/* Free a list of dynamically allocated hapmapAllelesOrtho's */

void hapmapAllelesOrthoOutput(struct hapmapAllelesOrtho *el, FILE *f, char sep, char lastSep);
/* Print out hapmapAllelesOrtho.  Separate fields with sep. Follow last field with lastSep. */

#define hapmapAllelesOrthoTabOut(el,f) hapmapAllelesOrthoOutput(el,f,'\t','\n');
/* Print out hapmapAllelesOrtho as a line in a tab-separated file. */

#define hapmapAllelesOrthoCommaOut(el,f) hapmapAllelesOrthoOutput(el,f,',',',');
/* Print out hapmapAllelesOrtho as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HAPMAPALLELESORTHO_H */

