/* rnaFold.h was originally generated by the autoSql program, which also 
 * generated rnaFold.c and rnaFold.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2003 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef RNAFOLD_H
#define RNAFOLD_H

#define RNAFOLD_NUM_COLS 4

struct rnaFold
/* Info about folding of RNA into secondary structure */
    {
    struct rnaFold *next;  /* Next in singly linked list. */
    char *name;	/* mRNA accession */
    char *seq;	/* mRNA sequence (U's instead of T's) */
    char *fold;	/* Parenthesis and .'s that describe folding */
    float energy;	/* Estimated free energy of folding (negative) */
    };

void rnaFoldStaticLoad(char **row, struct rnaFold *ret);
/* Load a row from rnaFold table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct rnaFold *rnaFoldLoad(char **row);
/* Load a rnaFold from row fetched with select * from rnaFold
 * from database.  Dispose of this with rnaFoldFree(). */

struct rnaFold *rnaFoldLoadAll(char *fileName);
/* Load all rnaFold from whitespace-separated file.
 * Dispose of this with rnaFoldFreeList(). */

struct rnaFold *rnaFoldLoadAllByChar(char *fileName, char chopper);
/* Load all rnaFold from chopper separated file.
 * Dispose of this with rnaFoldFreeList(). */

#define rnaFoldLoadAllByTab(a) rnaFoldLoadAllByChar(a, '\t');
/* Load all rnaFold from tab separated file.
 * Dispose of this with rnaFoldFreeList(). */

struct rnaFold *rnaFoldCommaIn(char **pS, struct rnaFold *ret);
/* Create a rnaFold out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new rnaFold */

void rnaFoldFree(struct rnaFold **pEl);
/* Free a single dynamically allocated rnaFold such as created
 * with rnaFoldLoad(). */

void rnaFoldFreeList(struct rnaFold **pList);
/* Free a list of dynamically allocated rnaFold's */

void rnaFoldOutput(struct rnaFold *el, FILE *f, char sep, char lastSep);
/* Print out rnaFold.  Separate fields with sep. Follow last field with lastSep. */

#define rnaFoldTabOut(el,f) rnaFoldOutput(el,f,'\t','\n');
/* Print out rnaFold as a line in a tab-separated file. */

#define rnaFoldCommaOut(el,f) rnaFoldOutput(el,f,',',',');
/* Print out rnaFold as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* RNAFOLD_H */

