/* tigrCmrGene.h was originally generated by the autoSql program, which also 
 * generated tigrCmrGene.c and tigrCmrGene.sql.  This header links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2013 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#ifndef TIGRCMRGENE_H
#define TIGRCMRGENE_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define TIGRCMRGENE_NUM_COLS 21

struct tigrCmrGene
/* For TIGR CMR genes tracks */
    {
    struct tigrCmrGene *next;  /* Next in singly linked list. */
    short bin;	/* Bin number for browser speedup */
    char *chrom;	/* Human chromosome or FPC contig */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* TIGR locus */
    unsigned score;	/* Score from 900-1000.  1000 is best */
    char strand[2];	/* Value should be + or - */
    char *tigrCommon;	/* TIGR Common Name */
    char *tigrGene;	/* TIGR Gene Symbol */
    char *tigrECN;	/* TIGR Enzyme Commission Number */
    char *primLocus;	/* Primary Locus Name */
    unsigned tigrLength;	/* TIGR sequence length */
    unsigned tigrPepLength;	/* TIGR Protein length */
    char *tigrMainRole;	/* TIGR Main Role */
    char *tigrSubRole;	/* TIGR Sub Role */
    char *swissProt;	/* SwissProt TrEMBL Accession */
    char *genbank;	/* Genbank ID */
    float tigrMw;	/* Molecular Weight */
    float tigrPi;	/* Isoelectric point (I think) */
    float tigrGc;	/* GC content */
    char *goTerm;	/* GO term (gene ontology) */
    };

void tigrCmrGeneStaticLoad(char **row, struct tigrCmrGene *ret);
/* Load a row from tigrCmrGene table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct tigrCmrGene *tigrCmrGeneLoad(char **row);
/* Load a tigrCmrGene from row fetched with select * from tigrCmrGene
 * from database.  Dispose of this with tigrCmrGeneFree(). */

struct tigrCmrGene *tigrCmrGeneLoadAll(char *fileName);
/* Load all tigrCmrGene from whitespace-separated file.
 * Dispose of this with tigrCmrGeneFreeList(). */

struct tigrCmrGene *tigrCmrGeneLoadAllByChar(char *fileName, char chopper);
/* Load all tigrCmrGene from chopper separated file.
 * Dispose of this with tigrCmrGeneFreeList(). */

#define tigrCmrGeneLoadAllByTab(a) tigrCmrGeneLoadAllByChar(a, '\t');
/* Load all tigrCmrGene from tab separated file.
 * Dispose of this with tigrCmrGeneFreeList(). */

struct tigrCmrGene *tigrCmrGeneLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all tigrCmrGene from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with tigrCmrGeneFreeList(). */

void tigrCmrGeneSaveToDb(struct sqlConnection *conn, struct tigrCmrGene *el, char *tableName, int updateSize);
/* Save tigrCmrGene as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Strings are automatically escaped to allow insertion into the database. */

struct tigrCmrGene *tigrCmrGeneCommaIn(char **pS, struct tigrCmrGene *ret);
/* Create a tigrCmrGene out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new tigrCmrGene */

void tigrCmrGeneFree(struct tigrCmrGene **pEl);
/* Free a single dynamically allocated tigrCmrGene such as created
 * with tigrCmrGeneLoad(). */

void tigrCmrGeneFreeList(struct tigrCmrGene **pList);
/* Free a list of dynamically allocated tigrCmrGene's */

void tigrCmrGeneOutput(struct tigrCmrGene *el, FILE *f, char sep, char lastSep);
/* Print out tigrCmrGene.  Separate fields with sep. Follow last field with lastSep. */

#define tigrCmrGeneTabOut(el,f) tigrCmrGeneOutput(el,f,'\t','\n');
/* Print out tigrCmrGene as a line in a tab-separated file. */

#define tigrCmrGeneCommaOut(el,f) tigrCmrGeneOutput(el,f,',',',');
/* Print out tigrCmrGene as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TIGRCMRGENE_H */

