/* asmSummary.c was originally generated by the autoSql program, which also 
 * generated asmSummary.h and asmSummary.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "asmSummary.h"



char *asmSummaryCommaSepFieldNames = "assemblyAccession,bioproject,biosample,wgsMaster,refseqCategory,taxId,speciesTaxid,organismName,infraspecificName,isolate,versionStatus,assemblyLevel,releaseType,genomeRep,seqRelDate,asmName,asmSubmitter,gbrsPairedAsm,pairedAsmComp,ftpPath,excludedFromRefseq,relationToTypeMaterial,assemblyType,phyloGroup,genomeSize,genomeSizeUngapped,gcPercent,repliconCount,scaffoldCount,contigCount,annotationProvider,annotationName,annotationDate,totalGeneCount,proteinCodingGeneCount,nonCodingGeneCount,pubmedId";

void asmSummaryStaticLoadWithNull(char **row, struct asmSummary *ret)
/* Load a row from asmSummary table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->assemblyAccession = row[0];
ret->bioproject = row[1];
ret->biosample = row[2];
ret->wgsMaster = row[3];
ret->refseqCategory = row[4];
ret->taxId = 0;
ret->speciesTaxid = 0;
if (row[5] != NULL)
    {
    ret->taxId = sqlUnsigned(row[5]);
    }
if (row[6] != NULL)
    {
    ret->speciesTaxid = sqlUnsigned(row[6]);
    }
ret->organismName = row[7];
ret->infraspecificName = row[8];
ret->isolate = row[9];
ret->versionStatus = row[10];
ret->assemblyLevel = row[11];
ret->releaseType = row[12];
ret->genomeRep = row[13];
ret->seqRelDate = row[14];
ret->asmName = row[15];
ret->asmSubmitter = row[16];
ret->gbrsPairedAsm = row[17];
ret->pairedAsmComp = row[18];
ret->ftpPath = row[19];
ret->excludedFromRefseq = row[20];
ret->relationToTypeMaterial = row[21];
ret->assemblyType = row[22];
ret->phyloGroup = row[23];
ret->genomeSize = 0;
ret->genomeSizeUngapped = 0;
ret->gcPercent = 0.0;
ret->repliconCount = 0;
ret->scaffoldCount = 0;
ret->contigCount = 0;
ret->proteinCodingGeneCount = 0;
if (row[24] != NULL)
    {
    ret->genomeSize = sqlLongLong(row[24]);
    }
if (row[25] != NULL)
    {
    ret->genomeSizeUngapped = sqlLongLong(row[25]);
    }
if (row[26] != NULL)
    {
    ret->gcPercent = sqlFloat(row[26]);
    }
if (row[27] != NULL)
    {
    ret->repliconCount = sqlUnsigned(row[27]);
    }
if (row[28] != NULL)
    {
    ret->scaffoldCount = sqlUnsigned(row[28]);
    }
if (row[29] != NULL)
    {
    ret->contigCount = sqlUnsigned(row[29]);
    }
ret->annotationProvider = row[30];
ret->annotationName = row[31];
ret->annotationDate = row[32];
ret->totalGeneCount = row[33];
if (row[34] != NULL)
    {
    ret->proteinCodingGeneCount = sqlUnsigned(row[34]);
    }
ret->nonCodingGeneCount = row[35];
ret->pubmedId = row[36];
}

struct asmSummary *asmSummaryLoadByQuery(struct sqlConnection *conn, char *query)
/* Load all asmSummary from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with asmSummaryFreeList(). */
{
struct asmSummary *list = NULL, *el;
struct sqlResult *sr;
char **row;

sr = sqlGetResult(conn, query);
while ((row = sqlNextRow(sr)) != NULL)
    {
    el = asmSummaryLoadWithNull(row);
    slAddHead(&list, el);
    }
slReverse(&list);
sqlFreeResult(&sr);
return list;
}

void asmSummarySaveToDb(struct sqlConnection *conn, struct asmSummary *el, char *tableName, int updateSize)
/* Save asmSummary as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. This function automatically escapes quoted strings for mysql. */
{
struct dyString *update = dyStringNew(updateSize);
sqlDyStringPrintf(update, "insert into %s values ( '%s','%s','%s','%s','%s',%u,%u,'%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s','%s',%lld,%lld,%g,%u,%u,%u,'%s','%s','%s','%s',%u,'%s','%s')", 
	tableName,  el->assemblyAccession,  el->bioproject,  el->biosample,  el->wgsMaster,  el->refseqCategory,  el->taxId,  el->speciesTaxid,  el->organismName,  el->infraspecificName,  el->isolate,  el->versionStatus,  el->assemblyLevel,  el->releaseType,  el->genomeRep,  el->seqRelDate,  el->asmName,  el->asmSubmitter,  el->gbrsPairedAsm,  el->pairedAsmComp,  el->ftpPath,  el->excludedFromRefseq,  el->relationToTypeMaterial,  el->assemblyType,  el->phyloGroup,  el->genomeSize,  el->genomeSizeUngapped,  el->gcPercent,  el->repliconCount,  el->scaffoldCount,  el->contigCount,  el->annotationProvider,  el->annotationName,  el->annotationDate,  el->totalGeneCount,  el->proteinCodingGeneCount,  el->nonCodingGeneCount,  el->pubmedId);
sqlUpdate(conn, update->string);
dyStringFree(&update);
}

struct asmSummary *asmSummaryLoadWithNull(char **row)
/* Load a asmSummary from row fetched with select * from asmSummary
 * from database.  Dispose of this with asmSummaryFree(). */
{
struct asmSummary *ret;

AllocVar(ret);
ret->assemblyAccession = cloneString(row[0]);
ret->bioproject = cloneString(row[1]);
ret->biosample = cloneString(row[2]);
ret->wgsMaster = cloneString(row[3]);
ret->refseqCategory = cloneString(row[4]);
ret->taxId = 0;
ret->speciesTaxid = 0;
if (row[5] != NULL)
    {
    ret->taxId = sqlUnsigned(row[5]);
    }
if (row[6] != NULL)
    {
    ret->speciesTaxid = sqlUnsigned(row[6]);
    }
ret->organismName = cloneString(row[7]);
ret->infraspecificName = cloneString(row[8]);
ret->isolate = cloneString(row[9]);
ret->versionStatus = cloneString(row[10]);
ret->assemblyLevel = cloneString(row[11]);
ret->releaseType = cloneString(row[12]);
ret->genomeRep = cloneString(row[13]);
ret->seqRelDate = cloneString(row[14]);
ret->asmName = cloneString(row[15]);
ret->asmSubmitter = cloneString(row[16]);
ret->gbrsPairedAsm = cloneString(row[17]);
ret->pairedAsmComp = cloneString(row[18]);
ret->ftpPath = cloneString(row[19]);
ret->excludedFromRefseq = cloneString(row[20]);
ret->relationToTypeMaterial = cloneString(row[21]);
ret->assemblyType = cloneString(row[22]);
ret->phyloGroup = cloneString(row[23]);
ret->genomeSize = 0;
ret->genomeSizeUngapped = 0;
ret->gcPercent = 0.0;
ret->repliconCount = 0;
ret->scaffoldCount = 0;
ret->contigCount = 0;
ret->proteinCodingGeneCount = 0;
if (row[24] != NULL)
    {
    ret->genomeSize = sqlLongLong(row[24]);
    }
if (row[25] != NULL)
    {
    ret->genomeSizeUngapped = sqlLongLong(row[25]);
    }
if (row[26] != NULL)
    {
    ret->gcPercent = sqlFloat(row[26]);
    }
if (row[27] != NULL)
    {
    ret->repliconCount = sqlUnsigned(row[27]);
    }
if (row[28] != NULL)
    {
    ret->scaffoldCount = sqlUnsigned(row[28]);
    }
if (row[29] != NULL)
    {
    ret->contigCount = sqlUnsigned(row[29]);
    }
ret->annotationProvider = cloneString(row[30]);
ret->annotationName = cloneString(row[31]);
ret->annotationDate = cloneString(row[32]);
ret->totalGeneCount = cloneString(row[33]);
if (row[34] != NULL)
    {
    ret->proteinCodingGeneCount = sqlUnsigned(row[34]);
    }
ret->nonCodingGeneCount = cloneString(row[35]);
ret->pubmedId = cloneString(row[36]);
return ret;
}

struct asmSummary *asmSummaryLoadAll(char *fileName) 
/* Load all asmSummary from a whitespace-separated file.
 * Dispose of this with asmSummaryFreeList(). */
{
struct asmSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[37];

while (lineFileRow(lf, row))
    {
    el = asmSummaryLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct asmSummary *asmSummaryLoadAllByChar(char *fileName, char chopper) 
/* Load all asmSummary from a chopper separated file.
 * Dispose of this with asmSummaryFreeList(). */
{
struct asmSummary *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[37];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = asmSummaryLoadWithNull(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct asmSummary *asmSummaryCommaIn(char **pS, struct asmSummary *ret)
/* Create a asmSummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new asmSummary */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->assemblyAccession = sqlStringComma(&s);
ret->bioproject = sqlStringComma(&s);
ret->biosample = sqlStringComma(&s);
ret->wgsMaster = sqlStringComma(&s);
ret->refseqCategory = sqlStringComma(&s);
ret->taxId = sqlUnsignedComma(&s);
ret->speciesTaxid = sqlUnsignedComma(&s);
ret->organismName = sqlStringComma(&s);
ret->infraspecificName = sqlStringComma(&s);
ret->isolate = sqlStringComma(&s);
ret->versionStatus = sqlStringComma(&s);
ret->assemblyLevel = sqlStringComma(&s);
ret->releaseType = sqlStringComma(&s);
ret->genomeRep = sqlStringComma(&s);
ret->seqRelDate = sqlStringComma(&s);
ret->asmName = sqlStringComma(&s);
ret->asmSubmitter = sqlStringComma(&s);
ret->gbrsPairedAsm = sqlStringComma(&s);
ret->pairedAsmComp = sqlStringComma(&s);
ret->ftpPath = sqlStringComma(&s);
ret->excludedFromRefseq = sqlStringComma(&s);
ret->relationToTypeMaterial = sqlStringComma(&s);
ret->assemblyType = sqlStringComma(&s);
ret->phyloGroup = sqlStringComma(&s);
ret->genomeSize = sqlLongLongComma(&s);
ret->genomeSizeUngapped = sqlLongLongComma(&s);
ret->gcPercent = sqlFloatComma(&s);
ret->repliconCount = sqlUnsignedComma(&s);
ret->scaffoldCount = sqlUnsignedComma(&s);
ret->contigCount = sqlUnsignedComma(&s);
ret->annotationProvider = sqlStringComma(&s);
ret->annotationName = sqlStringComma(&s);
ret->annotationDate = sqlStringComma(&s);
ret->totalGeneCount = sqlStringComma(&s);
ret->proteinCodingGeneCount = sqlUnsignedComma(&s);
ret->nonCodingGeneCount = sqlStringComma(&s);
ret->pubmedId = sqlStringComma(&s);
*pS = s;
return ret;
}

void asmSummaryFree(struct asmSummary **pEl)
/* Free a single dynamically allocated asmSummary such as created
 * with asmSummaryLoad(). */
{
struct asmSummary *el;

if ((el = *pEl) == NULL) return;
freeMem(el->assemblyAccession);
freeMem(el->bioproject);
freeMem(el->biosample);
freeMem(el->wgsMaster);
freeMem(el->refseqCategory);
freeMem(el->organismName);
freeMem(el->infraspecificName);
freeMem(el->isolate);
freeMem(el->versionStatus);
freeMem(el->assemblyLevel);
freeMem(el->releaseType);
freeMem(el->genomeRep);
freeMem(el->seqRelDate);
freeMem(el->asmName);
freeMem(el->asmSubmitter);
freeMem(el->gbrsPairedAsm);
freeMem(el->pairedAsmComp);
freeMem(el->ftpPath);
freeMem(el->excludedFromRefseq);
freeMem(el->relationToTypeMaterial);
freeMem(el->assemblyType);
freeMem(el->phyloGroup);
freeMem(el->annotationProvider);
freeMem(el->annotationName);
freeMem(el->annotationDate);
freeMem(el->totalGeneCount);
freeMem(el->nonCodingGeneCount);
freeMem(el->pubmedId);
freez(pEl);
}

void asmSummaryFreeList(struct asmSummary **pList)
/* Free a list of dynamically allocated asmSummary's */
{
struct asmSummary *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    asmSummaryFree(&el);
    }
*pList = NULL;
}

void asmSummaryOutput(struct asmSummary *el, FILE *f, char sep, char lastSep) 
/* Print out asmSummary.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assemblyAccession);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bioproject);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->biosample);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->wgsMaster);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->refseqCategory);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->taxId);
fputc(sep,f);
fprintf(f, "%u", el->speciesTaxid);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->organismName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->infraspecificName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->isolate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->versionStatus);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assemblyLevel);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->releaseType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->genomeRep);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seqRelDate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->asmName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->asmSubmitter);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gbrsPairedAsm);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pairedAsmComp);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->ftpPath);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->excludedFromRefseq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->relationToTypeMaterial);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->assemblyType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->phyloGroup);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%lld", el->genomeSize);
fputc(sep,f);
fprintf(f, "%lld", el->genomeSizeUngapped);
fputc(sep,f);
fprintf(f, "%g", el->gcPercent);
fputc(sep,f);
fprintf(f, "%u", el->repliconCount);
fputc(sep,f);
fprintf(f, "%u", el->scaffoldCount);
fputc(sep,f);
fprintf(f, "%u", el->contigCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->annotationProvider);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->annotationName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->annotationDate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->totalGeneCount);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->proteinCodingGeneCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->nonCodingGeneCount);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->pubmedId);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

void asmSummaryJsonOutput(struct asmSummary *el, FILE *f) 
/* Print out asmSummary in JSON format. */
{
fputc('{',f);
fputc('"',f);
fprintf(f,"assemblyAccession");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->assemblyAccession);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"bioproject");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->bioproject);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"biosample");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->biosample);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"wgsMaster");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->wgsMaster);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"refseqCategory");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->refseqCategory);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"taxId");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->taxId);
fputc(',',f);
fputc('"',f);
fprintf(f,"speciesTaxid");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->speciesTaxid);
fputc(',',f);
fputc('"',f);
fprintf(f,"organismName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->organismName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"infraspecificName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->infraspecificName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"isolate");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->isolate);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"versionStatus");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->versionStatus);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"assemblyLevel");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->assemblyLevel);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"releaseType");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->releaseType);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"genomeRep");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->genomeRep);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"seqRelDate");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->seqRelDate);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"asmName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->asmName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"asmSubmitter");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->asmSubmitter);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"gbrsPairedAsm");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->gbrsPairedAsm);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"pairedAsmComp");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->pairedAsmComp);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"ftpPath");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->ftpPath);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"excludedFromRefseq");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->excludedFromRefseq);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"relationToTypeMaterial");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->relationToTypeMaterial);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"assemblyType");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->assemblyType);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"phyloGroup");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->phyloGroup);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"genomeSize");
fputc('"',f);
fputc(':',f);
fprintf(f, "%lld", el->genomeSize);
fputc(',',f);
fputc('"',f);
fprintf(f,"genomeSizeUngapped");
fputc('"',f);
fputc(':',f);
fprintf(f, "%lld", el->genomeSizeUngapped);
fputc(',',f);
fputc('"',f);
fprintf(f,"gcPercent");
fputc('"',f);
fputc(':',f);
fprintf(f, "%g", el->gcPercent);
fputc(',',f);
fputc('"',f);
fprintf(f,"repliconCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->repliconCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"scaffoldCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->scaffoldCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"contigCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->contigCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"annotationProvider");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->annotationProvider);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"annotationName");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->annotationName);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"annotationDate");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->annotationDate);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"totalGeneCount");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->totalGeneCount);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"proteinCodingGeneCount");
fputc('"',f);
fputc(':',f);
fprintf(f, "%u", el->proteinCodingGeneCount);
fputc(',',f);
fputc('"',f);
fprintf(f,"nonCodingGeneCount");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->nonCodingGeneCount);
fputc('"',f);
fputc(',',f);
fputc('"',f);
fprintf(f,"pubmedId");
fputc('"',f);
fputc(':',f);
fputc('"',f);
fprintf(f, "%s", el->pubmedId);
fputc('"',f);
fputc('}',f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

struct asmSummary *asmSummaryFullText(struct sqlConnection *conn, char *words, long long rowLimit, long long *totalMatch)
/* perform a FULLTEXT search on the asmSummary table with the list
 *   of words string (may be only a single word)
 * return is a list of items found up to rowLimit, or NULL if none found
 *   also returning totalMatch to understand if it is more than the rowLimit
 */
{
char query[4096];
sqlSafef(query, sizeof(query), "SELECT count(*) FROM asmSummary WHERE MATCH (bioproject, biosample, organismName, isolate, asmName, asmSubmitter, annotationProvider, annotationName) AGAINST (\"%s\")", words);
*totalMatch = (long long) sqlQuickNum(conn, query);
sqlSafef(query, sizeof(query), "SELECT * FROM asmSummary WHERE MATCH (bioproject, biosample, organismName, isolate, asmName, asmSubmitter, annotationProvider, annotationName) AGAINST (\"%s\") LIMIT %lld", words, rowLimit);
struct asmSummary *list = asmSummaryLoadByQuery(conn, query);
return list;
}
