/* chainLink.c was originally generated by the autoSql program, which also 
 * generated chainLink.h and chainLink.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "chain.h"
#include "chainLink.h"


void chainLinkStaticLoad(char **row, struct chainLink *ret)
/* Load a row from chainLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->tName = row[0];
ret->tStart = sqlUnsigned(row[1]);
ret->tEnd = sqlUnsigned(row[2]);
ret->qStart = sqlUnsigned(row[3]);
ret->chainId = sqlUnsigned(row[4]);
}

struct chainLink *chainLinkLoad(char **row)
/* Load a chainLink from row fetched with select * from chainLink
 * from database.  Dispose of this with chainLinkFree(). */
{
struct chainLink *ret;

AllocVar(ret);
ret->tName = cloneString(row[0]);
ret->tStart = sqlUnsigned(row[1]);
ret->tEnd = sqlUnsigned(row[2]);
ret->qStart = sqlUnsigned(row[3]);
ret->chainId = sqlUnsigned(row[4]);
return ret;
}

struct chainLink *chainLinkLoadAll(char *fileName) 
/* Load all chainLink from a tab-separated file.
 * Dispose of this with chainLinkFreeList(). */
{
struct chainLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = chainLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct chainLink *chainLinkCommaIn(char **pS, struct chainLink *ret)
/* Create a chainLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chainLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->tName = sqlStringComma(&s);
ret->tStart = sqlUnsignedComma(&s);
ret->tEnd = sqlUnsignedComma(&s);
ret->qStart = sqlUnsignedComma(&s);
ret->chainId = sqlUnsignedComma(&s);
*pS = s;
return ret;
}

void chainLinkFree(struct chainLink **pEl)
/* Free a single dynamically allocated chainLink such as created
 * with chainLinkLoad(). */
{
struct chainLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->tName);
freez(pEl);
}

void chainLinkFreeList(struct chainLink **pList)
/* Free a list of dynamically allocated chainLink's */
{
struct chainLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    chainLinkFree(&el);
    }
*pList = NULL;
}

void chainLinkOutput(struct chainLink *el, FILE *f, char sep, char lastSep) 
/* Print out chainLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->tName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->tStart);
fputc(sep,f);
fprintf(f, "%u", el->tEnd);
fputc(sep,f);
fprintf(f, "%u", el->qStart);
fputc(sep,f);
fprintf(f, "%u", el->chainId);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

