/* cogsxra.c was originally generated by the autoSql program, which also 
 * generated cogsxra.h and cogsxra.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cogsxra.h"


void COGXraStaticLoad(char **row, struct COGXra *ret)
/* Load a row from COGXra table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->name = row[0];
ret->info = row[1];
}

struct COGXra *COGXraLoad(char **row)
/* Load a COGXra from row fetched with select * from COGXra
 * from database.  Dispose of this with COGXraFree(). */
{
struct COGXra *ret;

AllocVar(ret);
ret->name = cloneString(row[0]);
ret->info = cloneString(row[1]);
return ret;
}

struct COGXra *COGXraLoadAll(char *fileName) 
/* Load all COGXra from a whitespace-separated file.
 * Dispose of this with COGXraFreeList(). */
{
struct COGXra *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileRow(lf, row))
    {
    el = COGXraLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct COGXra *COGXraLoadAllByChar(char *fileName, char chopper) 
/* Load all COGXra from a chopper separated file.
 * Dispose of this with COGXraFreeList(). */
{
struct COGXra *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[2];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = COGXraLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct COGXra *COGXraCommaIn(char **pS, struct COGXra *ret)
/* Create a COGXra out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new COGXra */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->info = sqlStringComma(&s);
*pS = s;
return ret;
}

void COGXraFree(struct COGXra **pEl)
/* Free a single dynamically allocated COGXra such as created
 * with COGXraLoad(). */
{
struct COGXra *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->info);
freez(pEl);
}

void COGXraFreeList(struct COGXra **pList)
/* Free a list of dynamically allocated COGXra's */
{
struct COGXra *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    COGXraFree(&el);
    }
*pList = NULL;
}

void COGXraOutput(struct COGXra *el, FILE *f, char sep, char lastSep) 
/* Print out COGXra.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->info);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

