/* jaxQTL2.c was originally generated by the autoSql program, which also 
 * generated jaxQTL2.h and jaxQTL2.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "jaxQTL2.h"


void jaxQTL2StaticLoad(char **row, struct jaxQTL2 *ret)
/* Load a row from jaxQTL2 table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
int sizeOne,i;
char *s;

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->marker = row[8];
ret->mgiID = row[9];
ret->description = row[10];
ret->cMscore = atof(row[11]);
}

struct jaxQTL2 *jaxQTL2Load(char **row)
/* Load a jaxQTL2 from row fetched with select * from jaxQTL2
 * from database.  Dispose of this with jaxQTL2Free(). */
{
struct jaxQTL2 *ret;
int sizeOne,i;
char *s;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->score = sqlUnsigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->marker = cloneString(row[8]);
ret->mgiID = cloneString(row[9]);
ret->description = cloneString(row[10]);
ret->cMscore = atof(row[11]);
return ret;
}

struct jaxQTL2 *jaxQTL2LoadAll(char *fileName) 
/* Load all jaxQTL2 from a tab-separated file.
 * Dispose of this with jaxQTL2FreeList(). */
{
struct jaxQTL2 *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[12];

while (lineFileRow(lf, row))
    {
    el = jaxQTL2Load(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct jaxQTL2 *jaxQTL2CommaIn(char **pS, struct jaxQTL2 *ret)
/* Create a jaxQTL2 out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new jaxQTL2 */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->score = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->marker = sqlStringComma(&s);
ret->mgiID = sqlStringComma(&s);
ret->description = sqlStringComma(&s);
ret->cMscore = sqlFloatComma(&s);
*pS = s;
return ret;
}

void jaxQTL2Free(struct jaxQTL2 **pEl)
/* Free a single dynamically allocated jaxQTL2 such as created
 * with jaxQTL2Load(). */
{
struct jaxQTL2 *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->marker);
freeMem(el->mgiID);
freeMem(el->description);
freez(pEl);
}

void jaxQTL2FreeList(struct jaxQTL2 **pList)
/* Free a list of dynamically allocated jaxQTL2's */
{
struct jaxQTL2 *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    jaxQTL2Free(&el);
    }
*pList = NULL;
}

void jaxQTL2Output(struct jaxQTL2 *el, FILE *f, char sep, char lastSep) 
/* Print out jaxQTL2.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->score);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->marker);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->mgiID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->cMscore);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

