/* sage.c was originally generated by the autoSql program, which also 
 * generated sage.h and sage.sql.  This module links the database and
 * the RAM representation of objects. */

/* Copyright (C) 2014 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "linefile.h"
#include "jksql.h"
#include "sage.h"


struct sage *sageLoad(char **row)
/* Load a sage from row fetched with select * from sage
 * from database.  Dispose of this with sageFree(). */
{
struct sage *ret;
int sizeOne;

AllocVar(ret);
ret->numTags = sqlSigned(row[4]);
ret->numExps = sqlSigned(row[6]);
ret->uni = sqlSigned(row[0]);
strcpy(ret->gb, row[1]);
strcpy(ret->gi, row[2]);
ret->description = cloneString(row[3]);
sqlStringDynamicArray(row[5], &ret->tags, &sizeOne);
assert(sizeOne == ret->numTags);
sqlSignedDynamicArray(row[7], &ret->exps, &sizeOne);
assert(sizeOne == ret->numExps);
sqlFloatDynamicArray(row[8], &ret->meds, &sizeOne);
assert(sizeOne == ret->numExps);
sqlFloatDynamicArray(row[9], &ret->aves, &sizeOne);
assert(sizeOne == ret->numExps);
sqlFloatDynamicArray(row[10], &ret->stdevs, &sizeOne);
assert(sizeOne == ret->numExps);
return ret;
}

struct sage *sageLoadAll(char *fileName) 
/* Load all sage from a tab-separated file.
 * Dispose of this with sageFreeList(). */
{
struct sage *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[11];

while (lineFileRow(lf, row))
    {
    el = sageLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct sage *sageCommaIn(char **pS, struct sage *ret)
/* Create a sage out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new sage */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->uni = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->gb, sizeof(ret->gb));
sqlFixedStringComma(&s, ret->gi, sizeof(ret->gi));
ret->description = sqlStringComma(&s);
ret->numTags = sqlSignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->tags, ret->numTags);
for (i=0; i<ret->numTags; ++i)
    {
    ret->tags[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->numExps = sqlSignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->exps, ret->numExps);
for (i=0; i<ret->numExps; ++i)
    {
    ret->exps[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->meds, ret->numExps);
for (i=0; i<ret->numExps; ++i)
    {
    ret->meds[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->aves, ret->numExps);
for (i=0; i<ret->numExps; ++i)
    {
    ret->aves[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->stdevs, ret->numExps);
for (i=0; i<ret->numExps; ++i)
    {
    ret->stdevs[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
*pS = s;
return ret;
}

void sageFree(struct sage **pEl)
/* Free a single dynamically allocated sage such as created
 * with sageLoad(). */
{
struct sage *el;

if ((el = *pEl) == NULL) return;
freeMem(el->description);
/* All strings in tags are allocated at once, so only need to free first. */
freeMem(el->tags[0]);
freeMem(el->tags);
freeMem(el->exps);
freeMem(el->meds);
freeMem(el->aves);
freeMem(el->stdevs);
freez(pEl);
}

void sageFreeList(struct sage **pList)
/* Free a list of dynamically allocated sage's */
{
struct sage *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    sageFree(&el);
    }
*pList = NULL;
}

void sageOutput(struct sage *el, FILE *f, char sep, char lastSep) 
/* Print out sage.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
fprintf(f, "%d", el->uni);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gb);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gi);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->description);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->numTags);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->numTags; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->tags[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
fprintf(f, "%d", el->numExps);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->numExps; ++i)
    {
    fprintf(f, "%d", el->exps[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->numExps; ++i)
    {
    fprintf(f, "%f", el->meds[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->numExps; ++i)
    {
    fprintf(f, "%f", el->aves[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->numExps; ++i)
    {
    fprintf(f, "%f", el->stdevs[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(lastSep,f);
}

