table snp132Ext
"Polymorphism data from dbSNP"
    (
    string   chrom;      "Reference sequence chromosome or scaffold"
    uint     chromStart; "Start position in chrom"
    uint     chromEnd;   "End position in chrom"
    string   name;       "dbSNP Reference SNP (rs) identifier"
    uint     score;      "Not used"
    char[1]  strand;     "Which DNA strand contains the observed alleles"
    lstring  refNCBI;  	 "Reference genomic sequence from dbSNP"
    lstring  refUCSC;    "Reference genomic sequence from UCSC lookup of chrom,chromStart,chromEnd"
    string   observed;   "The sequences of the observed alleles from rs-fasta files"
    string   molType;    "Sample type from exemplar submitted SNPs (ss)"
    string   class;      "Class of variant (single, in-del, named, mixed, etc.)"
    string   valid;      "Validation status of the SNP"
    float    avHet;      "Average heterozygosity from all observations.  Note: may be computed on small number of samples."
    float    avHetSE;    "Standard Error for the average heterozygosity"
    string   func;       "Functional category of the SNP (coding-synon, coding-nonsynon, intron, etc.)"
    string   locType;    "Type of mapping inferred from size on reference; may not agree with class"
    uint     weight;     "The quality of the alignment: 1 = unique mapping, 2 = non-unique, 3 = many matches"
    
    lstring  exceptions; "Unusual conditions noted by UCSC that may indicate a problem with the data"
    int      submitterCount; "Number of distinct submitter handles for submitted SNPs for this ref SNP"
    string[submitterCount] submitters; "List of submitter handles"
    int      alleleFreqCount; "Number of observed alleles with frequency data"
    string[alleleFreqCount] alleles; "Observed alleles for which frequency data are available"
    float[alleleFreqCount] alleleNs; "Count of chromosomes (2N) on which each allele was observed. Note: this is extrapolated by dbSNP from submitted frequencies and total sample 2N, and is not always an integer."
    float[alleleFreqCount] alleleFreqs; "Allele frequencies"
    string    bitfields; "SNP attributes extracted from dbSNP's SNP_bitfield table"
    )
