# snp.sql was originally generated by the autoSql program, which also 
# generated snp.c and snp.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#SNP positions from various sources
CREATE TABLE snpSingleValid (
    bin        smallint unsigned not null, 
    chrom      enum (
		'unknown',	#
		'chr1',		#
		'chr10',	#
		'chr10_random',	#
		'chr11',	#
		'chr12',	#
		'chr13',	#
		'chr13_random',	#
		'chr14',	#
		'chr15',	#
		'chr15_random',	#
		'chr16',	#
		'chr17',	#
		'chr17_random',	#
		'chr18',	#
		'chr18_random',	#
		'chr19',	#
		'chr19_random',	#
		'chr1_random',	#
		'chr2',		#
		'chr20',	#
		'chr21',	#
		'chr22',	#
		'chr2_random',	#
		'chr3',		#
		'chr3_random',	#
		'chr4',		#
		'chr4_random',	#
		'chr5',		#
		'chr5_random',	#
		'chr6',		#
		'chr6_random',	#
		'chr7',		#
		'chr7_random',	#
		'chr8',		#
		'chr8_random',	#
		'chr9',		#
		'chr9_random',	#
		'chrM',		#
		'chrUn_random',	#
		'chrX',		#
		'chrX_random',	#
		'chrY'		#
		)		  not null default 'unknown',
    chromStart int unsigned       not null,	# Start position in chrom
    chromEnd   int unsigned       not null,	# End position in chrom
    name       varchar(255)       not null,	# Name of SNP - rsId or Affy name
    score      float              not null,	# certainty of variation
    strand     enum ('?','+','-') not null default '?',
    alleles    varchar(255)      not null,	# the sequence of the observed alleles
    source     enum (
		 'dbSnp',               # generic dbSnp
		 'BAC_OVERLAP',         # dbSnp
		 'MIXED',               # dbSnp
		 'RANDOM',              # dbSnp
		 'OTHER',               # dbSnp
		 'Affy10K',             # Affymetrix
		 'Affy120K',            # Affymetrix
		 'unknown'              # default value
		 )               not null default 'unknown',
    class      enum (
		 'unknown',             # default value
		 'snp',                 # Single Nucleotide Polymorphism
		 'in-del',              # Insertion / Deletion
		 'microsat',            # Microsatellite
		 'named',               # Named mutation (mostly LAEGEDELETION and  LARGEINSERTION)
		 'mnp',                 # Multiple Nucleotide Polymorphism (segmental, some should be mixed)
		 'het',                 # heterozygous
		 'mixed'                # multiple classes
		 )               not null default 'unknown',
    valid      set (
		 'no-information',	# no validation information
		 'by-2hit-2allele',	# each allele seen in at least two individuals
		 'by-cluster',		# 
		 'by-frequency',	# 
		 'other-pop'		# seen in another population
		 ) 	         not null default 'no-information',
    avHet      float             not null,	# the average heterozygosity from all observations
    avHetSE    float             not null,	# the Standard Error for the average heterozygosity
    func       set (
		 'unknown',   		# no functional classification
		 'coding',    		# unknown coding mutation
		 'coding-synon',    	# synonymous mutation
		 'coding-nonsynon', 	# non-synonymous mutation
		 'mrna-utr',        	# untranslated region
		 'intron',          	# intronic region
		 'splice-site',     	# splice site
		 'exception',       	# alignment gap
		 'reference',       	# 
		 'locus-region'    	# locus region
		 ) 	         not null default 'unknown',
              #Indices
    INDEX(chrom,bin),
    INDEX(chrom,chromStart),
    INDEX(name)
);

