table TOGABigData
    "TOGA Big Data"
    (
    string chrom;      "Chromosome (or contig, scaffold, etc.)"
    uint   chromStart; "Start position in chromosome"
    uint   chromEnd;   "End position in chromosome"
    string name;       "Name of item"
    uint   score;      "Score from 0-1000"
    char[1] strand;    "+ or -"
    uint thickStart;   "Start of where display should be thick (start codon)"
    uint thickEnd;     "End of where display should be thick (stop codon)"
    uint reserved;     "Used as itemRgb as of 2004-11-22"
    int blockCount;    "Number of blocks"
    int[blockCount] blockSizes; "Comma separated list of block sizes"
    int[blockCount] chromStarts; "Start positions relative to chromStart"

    string ref_transcript_ID;"transcript ID in reference"
    string ref_region;    "transcript region in reference"
    string query_region;  "projection region in query"
    float chain_score;    "chain orthology score"
    int chain_synteny;    "chain synteny"
    float chain_flank;    "flank coverage"
    float chain_gl_cds_fract;"global CDS fraction"
    float chain_loc_cds_fract;"local CDS fraction"
    float chain_exon_cov; "local CDS coverage"
    float chain_intron_cov;"local intron coverage"
    string status;        "projection GLP status: loss, intact, etc"
    float perc_intact_ign_M;"%intact ignoring Missing"
    float perc_intact_int_M;"%intact considering missing seq intact"
    float intact_codon_prop;"% of intact codons"
    float ouf_prop;       "out of chain proportion"
    ubyte mid_intact;     "middle 80% intact? 1 - True 0 - False, else - undefined"
    ubyte mid_pres;       "middle 80% present? 1 - True 0 - False, else - undefined"
    lstring prot_sequence;"protein sequence"
    lstring svg_plot;     "svg string"
    )
