/* gsSeqInfo.c was originally generated by the autoSql program, which also 
 * generated gsSeqInfo.h and gsSeqInfo.sql.  This module links the database and the RAM 
 * representation of objects. */

/* Copyright (C) 2011 The Regents of the University of California 
 * See kent/LICENSE or http://genome.ucsc.edu/license/ for licensing information. */

#include "common.h"
#include "jksql.h"
#include "gsSeqInfo.h"


void gsSeqInfoStaticLoad(char **row, struct gsSeqInfo *ret)
/* Load a row from gsSeqInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->acc = row[0];
strcpy(ret->gi, row[1]);
ret->size = sqlUnsigned(row[2]);
ret->phase = sqlUnsigned(row[3]);
strcpy(ret->draft, row[4]);
ret->chrom = row[5];
ret->lab = row[6];
ret->cloneName = row[7];
}

struct gsSeqInfo *gsSeqInfoLoad(char **row)
/* Load a gsSeqInfo from row fetched with select * from gsSeqInfo
 * from database.  Dispose of this with gsSeqInfoFree(). */
{
struct gsSeqInfo *ret;

AllocVar(ret);
ret->acc = cloneString(row[0]);
strcpy(ret->gi, row[1]);
ret->size = sqlUnsigned(row[2]);
ret->phase = sqlUnsigned(row[3]);
strcpy(ret->draft, row[4]);
ret->chrom = cloneString(row[5]);
ret->lab = cloneString(row[6]);
ret->cloneName = cloneString(row[7]);
return ret;
}

struct gsSeqInfo *gsSeqInfoCommaIn(char **pS, struct gsSeqInfo *ret)
/* Create a gsSeqInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new gsSeqInfo */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->acc = sqlStringComma(&s);
sqlFixedStringComma(&s, ret->gi, sizeof(ret->gi));
ret->size = sqlUnsignedComma(&s);
ret->phase = sqlUnsignedComma(&s);
sqlFixedStringComma(&s, ret->draft, sizeof(ret->draft));
ret->chrom = sqlStringComma(&s);
ret->lab = sqlStringComma(&s);
ret->cloneName = sqlStringComma(&s);
*pS = s;
return ret;
}

void gsSeqInfoFree(struct gsSeqInfo **pEl)
/* Free a single dynamically allocated gsSeqInfo such as created
 * with gsSeqInfoLoad(). */
{
struct gsSeqInfo *el;

if ((el = *pEl) == NULL) return;
freeMem(el->acc);
freeMem(el->chrom);
freeMem(el->lab);
freeMem(el->cloneName);
freez(pEl);
}

void gsSeqInfoFreeList(struct gsSeqInfo **pList)
/* Free a list of dynamically allocated gsSeqInfo's */
{
struct gsSeqInfo *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    gsSeqInfoFree(&el);
    }
*pList = NULL;
}

void gsSeqInfoOutput(struct gsSeqInfo *el, FILE *f, char sep, char lastSep) 
/* Print out gsSeqInfo.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->acc);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->gi);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->size);
fputc(sep,f);
fprintf(f, "%u", el->phase);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->draft);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->lab);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->cloneName);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

